/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.profile.operation;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.soda.devicekit.generator.model.xml.IXmlElement;
import org.eclipse.soda.devicekit.ui.profile.operation.ProfileOperation;
import org.eclipse.soda.devicekit.util.DkmlFileFinder;

public class ProfileImplementationOperation
extends ProfileOperation {
    public ProfileImplementationOperation(Map variables, DkmlFileFinder finder) {
        super(variables);
        this.setFinder(finder);
    }

    protected void addProfileDkmlBody(IXmlElement dkmlElement) {
        Object needDevice;
        String packageBase;
        String simpleName;
        Object needAdapter;
        StringBuffer refBuffer;
        IXmlElement element = dkmlElement.add("profile");
        boolean abstractState = this.createCommonTop(element, true);
        Object parent = this.getVariables().get("profileparent");
        if (parent != null) {
            String simpleName2 = parent.toString();
            IXmlElement profileParent = element.add("profileparent");
            IXmlElement profile = profileParent.add("profileref");
            String profileName = String.valueOf(simpleName2) + "Profile";
            refBuffer = new StringBuffer(128);
            IFile file = this.getFinder().findFile("profile", profileName);
            if (file != null && file.exists()) {
                String projectId = file.getProject().getName();
                refBuffer.append(projectId);
            } else {
                String packageBase2 = this.getPackageBase();
                refBuffer.append(this.getNewBundleName(profileName, packageBase2));
            }
            refBuffer.append("/dk/profile.xml#");
            refBuffer.append(profileName);
            profile.addAttribute("idref", refBuffer.toString());
        }
        if ((needAdapter = this.getVariables().get("need.adapter")) == null || needAdapter.equals("true")) {
            IXmlElement adapter = element.add("adapter");
            simpleName = (String)this.getVariables().get("name");
            String adapterName = String.valueOf(simpleName) + "Adapter";
            refBuffer = new StringBuffer(128);
            packageBase = this.getPackageBase();
            refBuffer.append(this.getNewBundleName(adapterName, packageBase));
            refBuffer.append("/dk/adapter.xml#");
            refBuffer.append(adapterName);
            adapter.addAttribute("idref", refBuffer.toString());
        }
        if ((needDevice = this.getVariables().get("need.device")) == null || needDevice.equals("true")) {
            IXmlElement device = element.add("device");
            simpleName = (String)this.getVariables().get("name");
            String deviceName = String.valueOf(simpleName) + "Device";
            refBuffer = new StringBuffer(128);
            packageBase = this.getPackageBase();
            refBuffer.append(this.getNewBundleName(deviceName, packageBase));
            refBuffer.append("/dk/device.xml#");
            refBuffer.append(deviceName);
            device.addAttribute("idref", refBuffer.toString());
        }
        if (!abstractState) {
            this.addCommonBundle(element);
        }
    }

    protected String getNameFull() {
        String name = (String)this.getVariables().get("name");
        Object parent = this.getVariables().get("profileparent");
        if (parent != null) {
            String parentName = parent.toString();
            if (parentName.startsWith("Rfid")) {
                parentName = parentName.substring(4);
            }
            return String.valueOf(name) + parentName + "Profile";
        }
        return super.getNameFull();
    }
}

