/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.view;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerMessages;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerPlugin;
import org.eclipse.soda.devicekit.ui.testmanager.model.TestModel;
import org.eclipse.soda.devicekit.ui.testmanager.util.TestManagerImages;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Node;

public class TestReportLabelProvider
extends LabelProvider {
    private Map imageDescriptorMap;
    private Map formatPatternMap;
    public final ImageDescriptor fActionImageDescriptor = TestManagerImages.createImageDescriptor("obj16/", "action.gif");
    public final ImageDescriptor fHtmlTagImageDescriptor = TestManagerImages.createImageDescriptor("obj16/", "html_tag.gif");
    public final ImageDescriptor fInfoImageDescriptor = TestManagerImages.createImageDescriptor("obj16/", "info.gif");
    public final ImageDescriptor fTestImageDescriptor = TestManagerImages.createImageDescriptor("obj16/", "test.gif");
    public final ImageDescriptor fPropertyImageDescriptor = TestManagerImages.createImageDescriptor("obj16/", "property.gif");
    public final ImageDescriptor fTestRunImageDescriptor = TestManagerImages.createImageDescriptor("obj16/", "trun.gif");

    private static String getDetail(Node node) {
        Node firstChild = node.getFirstChild();
        if (firstChild != null && firstChild.getNodeType() == 3) {
            String detail = TestModel.getTextContent(firstChild).trim();
            int pos = detail.indexOf(10);
            if (pos > 0) {
                detail = detail.substring(0, pos);
            }
            if (detail.length() > 0) {
                return detail;
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
    }

    private synchronized Map getFormatPatternMap() {
        if (this.formatPatternMap == null) {
            this.formatPatternMap = new HashMap();
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "info"), TestManagerMessages.TestReportLabelProvider_NodeInfo);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "actionRun"), TestManagerMessages.TestReportLabelProvider_NodeActionRun);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "reportStatistics"), TestManagerMessages.TestReportLabelProvider_NodeReportStatistics);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "scriptErrors"), TestManagerMessages.TestReportLabelProvider_NodeScriptErrors);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "actionCount"), TestManagerMessages.TestReportLabelProvider_NodeActionCount);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "actionErrors"), TestManagerMessages.TestReportLabelProvider_NodeActionErrors);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "testCount"), TestManagerMessages.TestReportLabelProvider_NodeTestCount);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "testErrors"), TestManagerMessages.TestReportLabelProvider_NodeTestErrors);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "testcaseCount"), TestManagerMessages.TestReportLabelProvider_NodeTestCaseCount);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "testcaseErrors"), TestManagerMessages.TestReportLabelProvider_NodeTestCaseErrors);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "testcaseFailures"), TestManagerMessages.TestReportLabelProvider_NodeTestCaseFailures);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "title"), TestManagerMessages.TestReportLabelProvider_NodeTitle);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "version"), TestManagerMessages.TestReportLabelProvider_NodeVersion);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "vendor"), TestManagerMessages.TestReportLabelProvider_NodeVendor);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "description"), TestManagerMessages.TestReportLabelProvider_NodeDescription);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "url"), TestManagerMessages.TestReportLabelProvider_NodeURL);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "testRun"), TestManagerMessages.TestReportLabelProvider_NodeTestRun);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "testcaseRun"), TestManagerMessages.TestReportLabelProvider_NodeTestCaseRun);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "failure"), TestManagerMessages.TestReportLabelProvider_NodeFailure);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)1, "error"), TestManagerMessages.TestReportLabelProvider_NodeError);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)2, "start"), TestManagerMessages.TestReportLabelProvider_AttrStart);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)2, "end"), TestManagerMessages.TestReportLabelProvider_AttrEnd);
            this.formatPatternMap.put(this.getImageDescriptorKey((short)2, "time"), TestManagerMessages.TestReportLabelProvider_AttrTime);
        }
        return this.formatPatternMap;
    }

    public Image getImage(Object obj) {
        Node node = (Node)obj;
        String key = this.getImageDescriptorKey(node.getNodeType(), node.getNodeName());
        ImageDescriptor descriptor = (ImageDescriptor)this.getImageDescriptorMap().get(key);
        if (descriptor == null) {
            descriptor = node.getNodeType() == 1 ? this.fHtmlTagImageDescriptor : this.fPropertyImageDescriptor;
        }
        return TestManagerPlugin.getImageDescriptorRegistry().get(descriptor);
    }

    private String getImageDescriptorKey(short nodeType, String nodeName) {
        return String.valueOf(Short.toString(nodeType)) + '/' + nodeName;
    }

    private synchronized Map getImageDescriptorMap() {
        if (this.imageDescriptorMap == null) {
            this.imageDescriptorMap = new HashMap();
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "info"), this.fInfoImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "actionRun"), this.fActionImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "reportStatistics"), this.fHtmlTagImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "scriptErrors"), this.fInfoImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "actionCount"), this.fInfoImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "actionErrors"), this.fInfoImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "testCount"), this.fInfoImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "testErrors"), this.fInfoImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "testcaseCount"), this.fInfoImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "testcaseErrors"), this.fInfoImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "testcaseFailures"), this.fInfoImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "title"), this.fInfoImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "version"), this.fInfoImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "vendor"), this.fInfoImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "description"), this.fInfoImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "url"), this.fInfoImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "testRun"), this.fTestRunImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "testcaseRun"), this.fTestImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "failure"), this.fTestImageDescriptor);
            this.imageDescriptorMap.put(this.getImageDescriptorKey((short)1, "error"), this.fTestImageDescriptor);
        }
        return this.imageDescriptorMap;
    }

    public String getText(Object obj) {
        Node node = (Node)obj;
        String key = this.getImageDescriptorKey(node.getNodeType(), node.getNodeName());
        String pattern = (String)this.getFormatPatternMap().get(key);
        if (pattern == null) {
            return node.getNodeName();
        }
        Object[] parms = new Object[10];
        parms[0] = node.getNodeName();
        parms[1] = node.getNodeValue();
        parms[2] = TestReportLabelProvider.getDetail(node);
        int i = 3;
        while (i < 9) {
            String var = "{" + i + ':';
            int pos = pattern.indexOf(var);
            if (pos == -1) break;
            int end = pattern.indexOf(125, pos);
            String attributeName = pattern.substring(pos + var.length(), end);
            Node attr = node.getAttributes().getNamedItem(attributeName);
            if (attr != null) {
                parms[i] = attr.getNodeValue();
            }
            pattern = String.valueOf(pattern.substring(0, pos + var.length() - 1)) + pattern.substring(end);
            ++i;
        }
        return Nls.format((String)pattern, (Object[])parms);
    }
}

