/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.io.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;
import org.eclipse.equinox.internal.io.impl.Activator;
import org.eclipse.equinox.internal.io.impl.ConnectionFactoryListener;
import org.eclipse.equinox.internal.util.ref.Log;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.io.ConnectionFactory;
import org.osgi.service.io.ConnectorService;

public class ConnectorServiceImpl
implements ConnectorService {
    static BundleContext bc;
    ServiceRegistration reg;
    ConnectionFactoryListener listener;
    static boolean enableNotification;
    public static boolean hasDebug;
    private static Log log;
    static char[] chars;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        enableNotification = Activator.getBoolean("eclipse.io.enable.notification");
        chars = new char[]{'~', '='};
    }

    public ConnectorServiceImpl(BundleContext bc, Log log) {
        ConnectorServiceImpl.log = log;
        hasDebug = log.getDebug();
        this.init(bc);
    }

    public static void debug(int id, String message, Throwable t) {
        log.debug(4608, id, message, t, false);
    }

    public ConnectorServiceImpl(BundleContext bc) {
        this.init(bc);
    }

    private void init(BundleContext bc) {
        Class<?> clazz;
        ConnectorServiceImpl.bc = bc;
        if (enableNotification) {
            this.listener = new ConnectionFactoryListener(bc);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.io.ConnectorService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.reg = bc.registerService(clazz.getName(), (Object)this, null);
    }

    public void close() {
        this.reg.unregister();
        if (this.listener != null) {
            this.listener.close();
        }
    }

    public Connection open(String uri) throws IOException {
        return this.open(uri, 3);
    }

    public Connection open(String uri, int mode) throws IOException {
        return this.open(uri, mode, false);
    }

    public Connection open(String uri, int mode, boolean timeouts) throws IOException {
        long timeStart = 0L;
        if (hasDebug) {
            ConnectorServiceImpl.debug(16001, String.valueOf(uri) + ", " + (mode == 3 ? "READ_WRITE" : (mode == 1 ? "READ" : "WRITE")), null);
            timeStart = System.currentTimeMillis();
        }
        try {
            Connection c;
            if (uri == null) {
                throw new IllegalArgumentException("URL cannot be NULL!");
            }
            int sPos = uri.indexOf(":");
            if (sPos < 1) {
                throw new IllegalArgumentException("Does not have scheme");
            }
            String scheme = uri.substring(0, sPos);
            StringBuffer filter = new StringBuffer(scheme.length() + 13);
            filter.append('(');
            filter.append("io.scheme");
            filter.append(chars);
            filter.append(scheme);
            filter.append(')');
            int count = 0;
            if (this.listener != null) {
                count = ConnectionFactoryListener.count;
            }
            if ((c = ConnectorServiceImpl.getConnection(filter.toString(), uri, mode, timeouts, true)) == null && this.listener != null) {
                c = ConnectionFactoryListener.getConnectionNotifier(scheme, uri, mode, timeouts, filter.toString(), count);
            }
            if (c == null) {
                throw new ConnectionNotFoundException("Failed to create connection " + uri);
            }
            Connection connection = c;
            return connection;
        }
        finally {
            if (hasDebug) {
                ConnectorServiceImpl.debug(16002, String.valueOf(System.currentTimeMillis() - timeStart), null);
            }
        }
    }

    protected static Connection getConnection(String filter, String uri, int mode, boolean timeouts, boolean connector) throws IOException {
        ServiceReference[] cfRefs = null;
        Connection ret = null;
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.osgi.service.io.ConnectionFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            cfRefs = bc.getServiceReferences(clazz.getName(), filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (cfRefs != null) {
            ConnectorServiceImpl.sort(cfRefs, 0, cfRefs.length);
        }
        IOException ioExc = null;
        boolean not_found = false;
        if (cfRefs != null) {
            int i = 0;
            while (i < cfRefs.length) {
                block40: {
                    ConnectionFactory prov = (ConnectionFactory)bc.getService(cfRefs[i]);
                    if (prov != null) {
                        try {
                            try {
                                not_found = true;
                                ret = prov.createConnection(uri, mode, timeouts);
                            }
                            catch (IOException e) {
                                if (hasDebug) {
                                    ConnectorServiceImpl.debug(16003, prov.getClass().getName(), e);
                                }
                                if (ioExc == null) {
                                    ioExc = e;
                                }
                                if (ret == null) {
                                    bc.ungetService(cfRefs[i]);
                                    break block40;
                                }
                                if (hasDebug) {
                                    ConnectorServiceImpl.debug(16004, prov.getClass().getName(), null);
                                }
                                return ret;
                            }
                        }
                        catch (Throwable throwable) {
                            if (ret != null) {
                                if (hasDebug) {
                                    ConnectorServiceImpl.debug(16004, prov.getClass().getName(), null);
                                }
                                return ret;
                            }
                            bc.ungetService(cfRefs[i]);
                            throw throwable;
                        }
                        if (ret == null) {
                            bc.ungetService(cfRefs[i]);
                        } else {
                            if (hasDebug) {
                                ConnectorServiceImpl.debug(16004, prov.getClass().getName(), null);
                            }
                            return ret;
                        }
                    }
                }
                ++i;
            }
        }
        if (connector) {
            try {
                try {
                    ret = Connector.open(uri, mode, timeouts);
                }
                catch (ConnectionNotFoundException ignore) {
                    ConnectorServiceImpl.debug(16014, null, ignore);
                    if (ret == null) {
                        if (ioExc != null) {
                            throw ioExc;
                        }
                        if (not_found) {
                            throw new ConnectionNotFoundException("Failed to create connection " + uri);
                        }
                    } else if (hasDebug) {
                        ConnectorServiceImpl.debug(16005, null, null);
                    }
                }
            }
            finally {
                if (ret == null) {
                    if (ioExc != null) {
                        throw ioExc;
                    }
                    if (not_found) {
                        throw new ConnectionNotFoundException("Failed to create connection " + uri);
                    }
                } else if (hasDebug) {
                    ConnectorServiceImpl.debug(16005, null, null);
                }
            }
        }
        return ret;
    }

    private static void sort(ServiceReference[] array, int start, int end) {
        int middle = (start + end) / 2;
        if (start + 1 < middle) {
            ConnectorServiceImpl.sort(array, start, middle);
        }
        if (middle + 1 < end) {
            ConnectorServiceImpl.sort(array, middle, end);
        }
        if (start + 1 >= end) {
            return;
        }
        if (ConnectorServiceImpl.getRanking(array[middle - 1]) == ConnectorServiceImpl.getRanking(array[middle]) ? ConnectorServiceImpl.getServiceID(array[middle - 1]) < ConnectorServiceImpl.getServiceID(array[middle]) : ConnectorServiceImpl.getRanking(array[middle - 1]) >= ConnectorServiceImpl.getRanking(array[middle])) {
            return;
        }
        if (start + 2 == end) {
            ServiceReference temp = array[start];
            array[start] = array[middle];
            array[middle] = temp;
            return;
        }
        int i1 = start;
        int i2 = middle;
        int i3 = 0;
        Object[] merge = new Object[end - start];
        while (i1 < middle && i2 < end) {
            if (ConnectorServiceImpl.getRanking(array[i1]) == ConnectorServiceImpl.getRanking(array[i2])) {
                merge[i3++] = ConnectorServiceImpl.getServiceID(array[i1]) < ConnectorServiceImpl.getServiceID(array[i2]) ? array[i1++] : array[i2++];
                continue;
            }
            Object object = merge[i3++] = ConnectorServiceImpl.getRanking(array[i1]) >= ConnectorServiceImpl.getRanking(array[i2]) ? array[i1++] : array[i2++];
        }
        if (i1 < middle) {
            System.arraycopy(array, i1, merge, i3, middle - i1);
        }
        System.arraycopy(merge, 0, array, start, i2 - start);
    }

    private static int getRanking(ServiceReference ref) {
        Object rank = ref.getProperty("service.ranking");
        if (rank == null || !(rank instanceof Integer)) {
            return 0;
        }
        return (Integer)rank;
    }

    private static long getServiceID(ServiceReference ref) {
        Object sid = ref.getProperty("service.id");
        if (sid == null || !(sid instanceof Long)) {
            return 0L;
        }
        return ((Long)sid).intValue();
    }

    public DataInputStream openDataInputStream(String name) throws IOException {
        long timeBegin = 0L;
        if (hasDebug) {
            ConnectorServiceImpl.debug(16006, name, null);
            timeBegin = System.currentTimeMillis();
        }
        try {
            Connection conn = this.open(name, 1);
            if (!(conn instanceof InputConnection)) {
                try {
                    conn.close();
                }
                catch (IOException iOException) {}
                throw new IOException("Connection does not implement InputConnection:" + conn.getClass());
            }
            DataInputStream dataInputStream = ((InputConnection)conn).openDataInputStream();
            return dataInputStream;
        }
        finally {
            if (hasDebug) {
                ConnectorServiceImpl.debug(16007, String.valueOf(System.currentTimeMillis() - timeBegin), null);
            }
        }
    }

    public DataOutputStream openDataOutputStream(String name) throws IOException {
        long timeBegin = 0L;
        if (hasDebug) {
            ConnectorServiceImpl.debug(16008, name, null);
        }
        try {
            Connection conn = this.open(name, 2);
            if (!(conn instanceof OutputConnection)) {
                try {
                    conn.close();
                }
                catch (IOException iOException) {}
                throw new IOException("Connection does not implement OutputConnection:" + conn.getClass());
            }
            DataOutputStream dataOutputStream = ((OutputConnection)conn).openDataOutputStream();
            return dataOutputStream;
        }
        finally {
            if (hasDebug) {
                ConnectorServiceImpl.debug(16009, String.valueOf(System.currentTimeMillis() - timeBegin), null);
            }
        }
    }

    public InputStream openInputStream(String name) throws IOException {
        long timeBegin = 0L;
        if (hasDebug) {
            ConnectorServiceImpl.debug(16010, name, null);
            timeBegin = System.currentTimeMillis();
        }
        try {
            Connection conn = this.open(name, 1);
            if (!(conn instanceof InputConnection)) {
                try {
                    conn.close();
                }
                catch (IOException iOException) {}
                throw new IOException("Connection does not implement InputConnection:" + conn.getClass());
            }
            InputStream inputStream = ((InputConnection)conn).openInputStream();
            return inputStream;
        }
        finally {
            if (hasDebug) {
                ConnectorServiceImpl.debug(16011, String.valueOf(System.currentTimeMillis() - timeBegin), null);
            }
        }
    }

    public OutputStream openOutputStream(String name) throws IOException {
        long timeBegin = 0L;
        if (hasDebug) {
            ConnectorServiceImpl.debug(16012, name, null);
            timeBegin = System.currentTimeMillis();
        }
        try {
            Connection conn = this.open(name, 2);
            if (!(conn instanceof OutputConnection)) {
                try {
                    conn.close();
                }
                catch (IOException iOException) {}
                throw new IOException("Connection does not implement OutputConnection:" + conn.getClass());
            }
            OutputStream outputStream = ((OutputConnection)conn).openOutputStream();
            return outputStream;
        }
        finally {
            if (hasDebug) {
                ConnectorServiceImpl.debug(16013, String.valueOf(System.currentTimeMillis() - timeBegin), null);
            }
        }
    }
}

