/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.diagram.util;

import java.io.File;
import java.io.FileReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.tooling.simplemap.diagram.part.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SimpleMapMigrationUtil {
    private static final String LATEST_RELEASE = "http://org.msl.simple.gmfmap/simplemappings_1.1";

    public static File getJavaFile(URI uri) {
        if (uri.isPlatform()) {
            IFile file = SimpleMapMigrationUtil.getFile(uri);
            IPath location = file.getLocation();
            return location.toFile();
        }
        return new File(uri.toFileString());
    }

    public static String getNamespaceURI_SAX(File file) {
        ContentHandler contentHandler = new ContentHandler();
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(contentHandler);
            FileReader fileReader = new FileReader(file);
            reader.parse(new InputSource(fileReader));
        }
        catch (Exception exception) {}
        return contentHandler.getNsURI();
    }

    public static IFile getFile(URI uri) {
        String platformString = uri.toPlatformString(true);
        if (platformString != null) {
            Path path = new Path(platformString);
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return null;
    }

    public static boolean needsToMigrate(IEditorInput element) {
        File inputFile = SimpleMapMigrationUtil.getFile(element);
        if (inputFile == null) {
            return false;
        }
        String nsUri = SimpleMapMigrationUtil.getNamespaceURI_SAX(inputFile);
        return !nsUri.equals(LATEST_RELEASE);
    }

    public static void checkMigration(IEditorInput element) {
        if (SimpleMapMigrationUtil.needsToMigrate(element)) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Incompatible Version", (String)Messages.bind((String)Messages.SimplemapDocumentProvider_MigrationNeeded, (Object)element.getName()));
        }
    }

    private static File getFile(IEditorInput element) {
        if (element instanceof FileEditorInput) {
            return ((FileEditorInput)element).getPath().toFile();
        }
        if (element instanceof URIEditorInput) {
            URI uri = ((URIEditorInput)element).getURI();
            return SimpleMapMigrationUtil.getJavaFile(uri);
        }
        return null;
    }

    private static class ContentHandler
    extends DefaultHandler {
        private String nsURI;

        private ContentHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!"http://www.omg.org/XMI".equals(uri) && !"http://www.w3.org/2001/XMLSchema".equals(uri)) {
                this.nsURI = uri;
                throw new SAXException();
            }
        }

        public String getNsURI() {
            return this.nsURI;
        }
    }
}

