/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.diagram.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.gmfgraph.RGBColor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class WrappingLabelWithColorIcon
extends WrappingLabel {
    private Point colorIconLocation;
    private Color backroundColor = new Color((Device)Display.getCurrent(), 255, 255, 255);
    private Color foregroundColor = new Color((Device)Display.getCurrent(), 255, 255, 255);

    public void setBackgroundColor(RGBColor bckColor) {
        if (bckColor != null) {
            this.backroundColor = new Color((Device)Display.getCurrent(), bckColor.getRed(), bckColor.getGreen(), bckColor.getBlue());
            this.repaint();
        }
    }

    public void setForegroundColor(RGBColor foreColor) {
        if (foreColor != null) {
            this.foregroundColor = new Color((Device)Display.getCurrent(), foreColor.getRed(), foreColor.getGreen(), foreColor.getBlue());
            this.repaint();
        }
    }

    public void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.foregroundColor != null) {
            graphics.setForegroundColor(this.foregroundColor);
        }
        if (this.backroundColor != null) {
            graphics.setBackgroundColor(this.backroundColor);
        }
        this.paintColorIcon(graphics);
    }

    public void layout() {
        super.layout();
        Rectangle iconBounds = new Rectangle();
        iconBounds.setSize(this.getTotalIconSize());
        iconBounds.x = this.getParent().getBounds().width - this.getTotalIconSize().width;
        iconBounds.y = 4;
        this.setColorIconLocation(iconBounds.getLocation());
    }

    private void paintColorIcon(Graphics graphics) {
        Point p = Point.SINGLETON;
        p.setLocation(this.getColorIconLocation());
        Rectangle figBounds = this.getBounds();
        graphics.translate(figBounds.x, figBounds.y);
        Rectangle colorMonitor = new Rectangle(p, new Dimension(16, 16));
        graphics.fillRectangle(colorMonitor);
        graphics.setLineWidth(2);
        graphics.drawRoundRectangle(colorMonitor, 2, 2);
        graphics.translate(-figBounds.x, -figBounds.y);
    }

    protected Point getColorIconLocation() {
        return this.colorIconLocation;
    }

    protected void setColorIconLocation(Point location) {
        this.colorIconLocation = location;
    }
}

