/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.codegen;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.common.codegen.ImportAssistant;
import org.eclipse.gmf.internal.common.codegen.TextEmitter;
import org.eclipse.gmf.internal.xpand.BufferOutput;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.XpandFacade;
import org.eclipse.gmf.internal.xpand.model.AmbiguousDefinitionException;
import org.eclipse.gmf.internal.xpand.model.EvaluationException;
import org.eclipse.gmf.internal.xpand.model.Output;
import org.eclipse.gmf.internal.xpand.model.Scope;
import org.eclipse.gmf.internal.xpand.model.Variable;

public class XpandTextEmitter
implements TextEmitter {
    public final String PATH_SEPARATOR = "::";
    private final ResourceManager myResourceManager;
    private final String myTemplateFQN;
    private final String myMethod;
    private final List<Variable> myGlobals;

    public XpandTextEmitter(ResourceManager manager, String templateFQN, String method) {
        this(manager, templateFQN, method, null);
    }

    public XpandTextEmitter(ResourceManager manager, String templateFQN, String method, Map<String, Object> globals) {
        assert (manager != null && templateFQN != null);
        this.myResourceManager = manager;
        this.myTemplateFQN = templateFQN;
        this.myMethod = method;
        if (globals != null && globals.size() > 0) {
            this.myGlobals = new ArrayList<Variable>(globals.size());
            for (Map.Entry<String, Object> e : globals.entrySet()) {
                assert (e.getValue() instanceof EObject);
                this.myGlobals.add(new Variable(e.getKey(), (EClassifier)((EObject)e.getValue()).eClass(), e.getValue()));
            }
        } else {
            this.myGlobals = Collections.emptyList();
        }
    }

    @Override
    public String generate(IProgressMonitor monitor, Object[] arguments) throws InterruptedException, InvocationTargetException, UnexpectedBehaviourException {
        return this.generate(monitor, this.myMethod, arguments);
    }

    protected String generate(IProgressMonitor monitor, String method, Object[] arguments) throws InterruptedException, InvocationTargetException {
        if (monitor != null && monitor.isCanceled()) {
            throw new InterruptedException();
        }
        try {
            StringBuilder result = new StringBuilder();
            new XpandFacade(this.createContext(result)).evaluate(String.valueOf(this.myTemplateFQN) + "::" + method, this.extractTarget(arguments), this.extractArguments(arguments));
            return result.toString();
        }
        catch (EvaluationException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (AmbiguousDefinitionException e) {
            throw new InvocationTargetException(e);
        }
    }

    public ResourceManager getResourceManager() {
        return this.myResourceManager;
    }

    protected Object extractTarget(Object[] arguments) {
        assert (arguments != null && arguments.length > 0);
        return arguments[0];
    }

    protected String getTemplateFQN() {
        return this.myTemplateFQN;
    }

    protected Object[] extractArguments(Object[] arguments) {
        assert (arguments != null && arguments.length > 0);
        ArrayList<Object> res = new ArrayList<Object>(arguments.length);
        int i = 1;
        while (i < arguments.length) {
            if (!(arguments[i] instanceof ImportAssistant)) {
                res.add(arguments[i]);
            }
            ++i;
        }
        return res.toArray();
    }

    private Scope createContext(StringBuilder result) {
        return new Scope(this.myResourceManager, this.myGlobals, (Output)new BufferOutput(result));
    }
}

