/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.codegen;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.gmf.internal.common.Activator;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class ManifestFileMerge {
    private static final String IGNORE_MERGE_HEADER = "GMF-IgnoreMerge";
    private String[] myIgnoredHeaders;
    private final String myLineSeparator;

    public ManifestFileMerge() {
        this(System.getProperties().getProperty("line.separator"));
    }

    public ManifestFileMerge(String lineSeparator) {
        assert (lineSeparator != null);
        this.myLineSeparator = lineSeparator;
    }

    public String process(String oldText, String newText) {
        try {
            this.cleanIgnoredHeaders();
            LinkedHashMap<String, String> oldHeaders = new LinkedHashMap<String, String>();
            ManifestElement.parseBundleManifest((InputStream)new ByteArrayInputStream(oldText.getBytes("UTF8")), oldHeaders);
            LinkedHashMap newHeaders = new LinkedHashMap();
            ManifestElement.parseBundleManifest((InputStream)new ByteArrayInputStream(newText.getBytes("UTF8")), newHeaders);
            this.initializeIgnoredHeaders(oldHeaders);
            for (String newHeader : newHeaders.keySet()) {
                if (this.isIgnoredHeader(newHeader)) continue;
                if (oldHeaders.containsKey(newHeader)) {
                    String oldValue = oldHeaders.get(newHeader);
                    String newValue = (String)newHeaders.get(newHeader);
                    if (this.isMultivalued(oldValue) || this.isMultivalued(newValue)) {
                        oldHeaders.put(newHeader, this.mergeMultivalued(newHeader, oldValue, newValue));
                        continue;
                    }
                    oldHeaders.put(newHeader, newValue);
                    continue;
                }
                oldHeaders.put(newHeader, (String)newHeaders.get(newHeader));
            }
            return this.format(oldHeaders);
        }
        catch (IOException iOException) {
            return newText;
        }
        catch (BundleException ex) {
            Activator.logError("Error merging MANIFEST.MF", (Exception)((Object)ex));
            return newText;
        }
    }

    protected String format(Map<String, String> oldHeaders) throws BundleException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : oldHeaders.entrySet()) {
            sb.append(e.getKey());
            sb.append(':');
            sb.append(' ');
            if (this.valueFitsSingleLine(e.getKey(), e.getValue())) {
                sb.append(e.getValue());
            } else {
                sb.append(this.formatValue(e.getKey(), e.getValue()));
            }
            sb.append(this.myLineSeparator);
        }
        return sb.toString();
    }

    protected boolean valueFitsSingleLine(String headerHint, String value) {
        return headerHint.length() + 2 + value.length() < 70;
    }

    protected CharSequence formatValue(String headerHint, String value) throws BundleException {
        if (!this.isMultivalued(value)) {
            return value;
        }
        ManifestElement[] values = ManifestElement.parseHeader((String)headerHint, (String)value);
        assert (values.length > 0);
        StringBuilder sb = new StringBuilder();
        sb.append(this.formatValue(values[0]));
        int i = 1;
        while (i < values.length) {
            sb.append(',');
            sb.append(this.myLineSeparator);
            sb.append(' ');
            sb.append(this.formatValue(values[i]));
            ++i;
        }
        return sb;
    }

    protected CharSequence formatValue(ManifestElement element) {
        String v;
        int n;
        int n2;
        String[] stringArray;
        StringBuilder sb = new StringBuilder(element.getValue());
        Enumeration en = element.getDirectiveKeys();
        while (en != null && en.hasMoreElements()) {
            String directiveKey = (String)en.nextElement();
            stringArray = element.getDirectives(directiveKey);
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                sb.append(';');
                sb.append(directiveKey);
                sb.append(':');
                sb.append('=');
                sb.append(v);
                ++n;
            }
        }
        en = element.getKeys();
        while (en != null && en.hasMoreElements()) {
            String attrKey = (String)en.nextElement();
            stringArray = element.getAttributes(attrKey);
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                v = stringArray[n];
                sb.append(';');
                sb.append(attrKey);
                sb.append('=');
                sb.append('\"');
                sb.append(v);
                sb.append('\"');
                ++n;
            }
        }
        return sb;
    }

    private boolean isIgnoredHeader(String header) {
        assert (this.myIgnoredHeaders != null);
        return Arrays.binarySearch(this.myIgnoredHeaders, header) >= 0;
    }

    private void initializeIgnoredHeaders(LinkedHashMap<String, String> oldHeaders) throws BundleException {
        if (!oldHeaders.containsKey(IGNORE_MERGE_HEADER)) {
            this.myIgnoredHeaders = new String[0];
            return;
        }
        ManifestElement[] values = ManifestElement.parseHeader((String)IGNORE_MERGE_HEADER, (String)oldHeaders.get(IGNORE_MERGE_HEADER));
        if (values == null) {
            this.myIgnoredHeaders = new String[0];
            return;
        }
        this.myIgnoredHeaders = new String[values.length];
        int i = 0;
        while (i < values.length) {
            this.myIgnoredHeaders[i] = values[i].getValue();
            ++i;
        }
        Arrays.sort(this.myIgnoredHeaders);
    }

    private void cleanIgnoredHeaders() {
        this.myIgnoredHeaders = null;
    }

    private boolean isMultivalued(String value) {
        return value.indexOf(44) > 0;
    }

    private String mergeMultivalued(String header, String oldValue, String newValue) throws BundleException {
        ManifestElement[] oldValues = ManifestElement.parseHeader((String)header, (String)oldValue);
        if (oldValues == null || oldValues.length == 0) {
            return newValue;
        }
        Object[] lookupValues = new String[oldValues.length];
        int i = 0;
        while (i < oldValues.length) {
            lookupValues[i] = oldValues[i].getValue();
            ++i;
        }
        Arrays.sort(lookupValues);
        LinkedList<ManifestElement> additionalElements = new LinkedList<ManifestElement>();
        ManifestElement[] manifestElementArray = ManifestElement.parseHeader((String)header, (String)newValue);
        int n = manifestElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestElement n3 = manifestElementArray[n2];
            if (Arrays.binarySearch(lookupValues, n3.getValue()) < 0) {
                additionalElements.add(n3);
            }
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        ManifestElement[] manifestElementArray2 = oldValues;
        int n4 = oldValues.length;
        n = 0;
        while (n < n4) {
            ManifestElement me = manifestElementArray2[n];
            sb.append(this.formatValue(me));
            sb.append(',');
            ++n;
        }
        for (ManifestElement me : additionalElements) {
            sb.append(this.formatValue(me));
            sb.append(',');
        }
        assert (sb.charAt(sb.length() - 1) == ',');
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }
}

