/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.model.element;

import java.util.Collection;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.exception.MatlabRuntimeException;
import org.eclipse.epsilon.emc.simulink.model.SimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.util.SimulinkUtil;
import org.eclipse.epsilon.emc.simulink.util.collection.SimulinkPortCollection;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class SimulinkBlock
extends SimulinkElement {
    private static final String HANDLE_DELETE_BLOCK_HANDLE = "handle = ?; delete_block(handle);";
    private static final String INSPECT_HANDLE = "handle = ?; inspect(handle);";
    private static final String GET_SIMULINK_BLOCK_HANDLE = "getSimulinkBlockHandle('?');";
    private static final String DELETE = "delete";
    private static final String CREATE = "add";
    private static final String DELETE_BLOCK = "handle = ?; delete_block(handle);";

    public SimulinkBlock(SimulinkModel model, MatlabEngine engine, Double handle) throws MatlabRuntimeException {
        super(model, engine, handle);
    }

    public SimulinkBlock(String path, SimulinkModel model, MatlabEngine engine) throws MatlabRuntimeException {
        super(path, model, engine);
    }

    public SimulinkBlock(SimulinkModel model, MatlabEngine engine, String type) throws MatlabRuntimeException {
        super(model, engine, type);
    }

    protected String getParentPath() throws EolRuntimeException {
        SimulinkBlock parent = this.getParent();
        return parent == null ? ((SimulinkModel)this.model).getSimulinkModelName() : parent.getPath();
    }

    public void setParent(SimulinkBlock parent) {
        try {
            String name = (String)this.getProperty("name");
            String parentPath = parent == null ? ((SimulinkModel)this.model).getSimulinkModelName() : parent.getPath();
            Double newHandle = (Double)this.engine.evalWithResult("add_block('?', '?', 'MakeNameUnique', 'on');", new Object[]{this.getPath(), String.valueOf(parentPath) + "/" + name});
            this.engine.eval("handle = ?; delete_block(handle);", new Object[]{this.handle});
            this.handle = newHandle;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SimulinkBlock getParent() throws EolRuntimeException {
        String name;
        String path = this.getPath();
        if (!path.equalsIgnoreCase(name = ((String)this.getProperty("name")).replace("/", "//").replace("\n", " "))) {
            String parentPath = path.substring(0, path.length() - name.length() - 1);
            if (parentPath.replace("//", "").indexOf("/") < 0) {
                return null;
            }
            try {
                return new SimulinkBlock(parentPath, (SimulinkModel)this.model, this.engine);
            }
            catch (MatlabRuntimeException matlabRuntimeException) {
                throw new MatlabRuntimeException("Unable to retrieve parent");
            }
        }
        return null;
    }

    public Collection<ISimulinkModelElement> getChildren() throws MatlabException {
        return SimulinkUtil.getChildren((SimulinkModel)this.model, this);
    }

    public SimulinkModelElement inspect() throws EolRuntimeException {
        try {
            this.engine.eval(INSPECT_HANDLE, new Object[]{this.handle});
            return this;
        }
        catch (MatlabException e) {
            throw e.toEolRuntimeException();
        }
    }

    public boolean deleteElementInModel() throws EolRuntimeException {
        try {
            this.engine.eval("handle = ?; delete_block(handle);", new Object[]{this.getHandle()});
            return true;
        }
        catch (MatlabException e) {
            throw e.toEolRuntimeException();
        }
    }

    public void setScript(String script) throws EolRuntimeException {
        try {
            this.engine.eval("sf = sfroot();block = sf.find('Path','?','-isa','Stateflow.EMChart');block.Script = sprintf('?');", new Object[]{this.getPath(), script});
        }
        catch (MatlabException e) {
            throw e.toEolRuntimeException();
        }
    }

    public String getScript() throws EolRuntimeException {
        try {
            this.engine.eval("sf = sfroot();block = sf.find('Path','?','-isa','Stateflow.EMChart');script = string(block.Script);", new Object[]{this.getPath()});
            return "" + this.engine.getVariable("script");
        }
        catch (MatlabException e) {
            throw e.toEolRuntimeException();
        }
    }

    public void link(SimulinkBlock other) throws EolRuntimeException {
        this.link(other, 1, 1);
    }

    public void linkTo(SimulinkBlock other, int inPort) throws EolRuntimeException {
        this.link(other, 1, inPort);
    }

    public void linkFrom(SimulinkBlock other, int outPort) throws EolRuntimeException {
        this.link(other, outPort, 1);
    }

    public void link(SimulinkBlock other, int outPort, int inPort) throws EolRuntimeException {
        this.manageLink(other, outPort, inPort, true);
    }

    public void unlink(SimulinkBlock other) throws EolRuntimeException {
        this.unlink(other, 1, 1);
    }

    public void unlinkTo(SimulinkBlock other, int inPort) throws EolRuntimeException {
        this.unlink(other, 1, inPort);
    }

    public void unlinkFrom(SimulinkBlock other, int outPort) throws EolRuntimeException {
        this.unlink(other, outPort, 1);
    }

    public void unlink(SimulinkBlock other, int outPort, int inPort) throws EolRuntimeException {
        this.manageLink(other, outPort, inPort, false);
    }

    public void manageLink(SimulinkBlock other, int outPort, int inPort, boolean create) throws EolRuntimeException {
        String command = "sourceHandle = ?;targetHandle = ?;OutPortHandles = get_param(sourceHandle,'PortHandles');InPortHandles = get_param(targetHandle,'PortHandles');?_line('?',OutPortHandles.Outport(?),InPortHandles.Inport(?));";
        try {
            this.engine.eval(command, new Object[]{this.getHandle(), other.getHandle(), create ? CREATE : DELETE, this.getParentPath(), outPort, inPort});
        }
        catch (MatlabException ex) {
            throw ex.toEolRuntimeException();
        }
    }

    public SimulinkPortCollection getOutports() throws EolRuntimeException {
        try {
            Object handles = this.engine.evalWithSetupAndResult("handle = ?; ph = get_param(handle, 'PortHandles');", "ph.Outport;", new Object[]{this.handle});
            return new SimulinkPortCollection(handles, (SimulinkModel)this.model);
        }
        catch (MatlabException e) {
            throw e.toEolRuntimeException();
        }
    }

    public SimulinkPortCollection getInports() throws EolRuntimeException {
        try {
            Object handles = this.engine.evalWithSetupAndResult("handle = ?; ph = get_param(handle, 'PortHandles');", "ph.Inport;", new Object[]{this.handle});
            return new SimulinkPortCollection(handles, (SimulinkModel)this.model);
        }
        catch (MatlabException e) {
            throw e.toEolRuntimeException();
        }
    }
}

