/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.spreadsheet;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gs", nsUri="http://schemas.google.com/spreadsheets/2006", localName="field")
public class Field
extends AbstractExtension {
    static final String XML_NAME = "field";
    private static final String INDEX = "index";
    private static final String NAME = "name";
    private String index = null;
    private String name = null;
    private String value = null;

    public Field() {
    }

    public Field(String index, String name, String value) {
        this.setIndex(index);
        this.setName(name);
        this.setValue(value);
        this.setImmutable(true);
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.throwExceptionIfImmutable();
        this.index = index;
    }

    public boolean hasIndex() {
        return this.getIndex() != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.throwExceptionIfImmutable();
        this.name = name;
    }

    public boolean hasName() {
        return this.getName() != null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    protected void validate() {
        if (this.name == null) {
            Field.throwExceptionForMissingAttribute(NAME);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Field.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(INDEX, this.index);
        generator.put(NAME, this.name);
        generator.setContent(this.value);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.index = helper.consume(INDEX, false);
        this.name = helper.consume(NAME, true);
        this.value = helper.consume(null, false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        Field other = (Field)obj;
        return Field.eq(this.index, other.index) && Field.eq(this.name, other.name) && Field.eq(this.value, other.value);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.index != null) {
            result = 37 * result + this.index.hashCode();
        }
        if (this.name != null) {
            result = 37 * result + this.name.hashCode();
        }
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{Field index=" + this.index + " name=" + this.name + " value=" + this.value + "}";
    }
}

