/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emfcloud.jackson.databind.EMFContext;
import org.eclipse.emfcloud.jackson.databind.property.EObjectProperty;
import org.eclipse.emfcloud.jackson.databind.property.EObjectPropertyMap;
import org.eclipse.emfcloud.jackson.databind.property.EObjectTypeProperty;
import org.eclipse.emfcloud.jackson.errors.JSONException;

public class EObjectDeserializer
extends JsonDeserializer<EObject> {
    private final EObjectPropertyMap.Builder builder;
    private final Class<?> currentType;

    public EObjectDeserializer(EObjectPropertyMap.Builder builder, Class<?> currentType) {
        this.builder = builder;
        this.currentType = currentType;
    }

    public EObject deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        EMFContext.prepare((DatabindContext)ctxt);
        Resource resource = EMFContext.getResource((DatabindContext)ctxt);
        EStructuralFeature feature = EMFContext.getFeature((DatabindContext)ctxt);
        EClass defaultType = this.getDefaultType(ctxt);
        EObject current = null;
        EObjectPropertyMap propertyMap = feature == null && defaultType != null ? this.builder.construct((DatabindContext)ctxt, defaultType) : (feature instanceof EReference ? this.builder.construct((DatabindContext)ctxt, ((EReference)feature).getEReferenceType()) : this.builder.constructDefault((DatabindContext)ctxt));
        TokenBuffer buffer = null;
        JsonToken nextToken = jp.nextToken();
        while (nextToken != JsonToken.END_OBJECT && nextToken != null) {
            String field = jp.getCurrentName();
            EObjectProperty property = propertyMap.findProperty(field);
            if (property instanceof EObjectTypeProperty) {
                current = property.deserialize(jp, ctxt);
                if (current != null) {
                    propertyMap = this.builder.construct((DatabindContext)ctxt, current.eClass());
                }
            } else if (property != null && current != null) {
                property.deserializeAndSet(jp, current, ctxt, resource);
            } else if (property == null && current != null) {
                this.handleUnknownProperty(jp, resource, ctxt);
            } else {
                if (buffer == null) {
                    buffer = new TokenBuffer(jp);
                }
                buffer.copyCurrentStructure(jp);
            }
            nextToken = jp.nextToken();
        }
        if (buffer == null && current == null && defaultType != null) {
            return EcoreUtil.create((EClass)defaultType);
        }
        return buffer == null ? current : this.postDeserialize(buffer, current, defaultType, ctxt);
    }

    public EObject deserialize(JsonParser jp, DeserializationContext ctxt, EObject intoValue) throws IOException {
        if (intoValue == null) {
            return null;
        }
        EMFContext.prepare((DatabindContext)ctxt);
        EObjectPropertyMap propertyMap = this.builder.construct((DatabindContext)ctxt, intoValue.eClass());
        Resource resource = EMFContext.getResource((DatabindContext)ctxt);
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String field = jp.getCurrentName();
            EObjectProperty property = propertyMap.findProperty(field);
            if (property != null) {
                property.deserializeAndSet(jp, intoValue, ctxt, resource);
                continue;
            }
            this.handleUnknownProperty(jp, resource, ctxt);
        }
        return intoValue;
    }

    private EObject postDeserialize(TokenBuffer buffer, EObject object, EClass defaultType, DeserializationContext ctxt) throws IOException {
        JsonNode value;
        if (object == null && defaultType == null) {
            return null;
        }
        Resource resource = EMFContext.getResource((DatabindContext)ctxt);
        JsonParser jp = buffer.asParser();
        JsonNode tree = (JsonNode)jp.readValueAsTree();
        jp.close();
        EObjectPropertyMap propertyMap = this.builder.find(ctxt, defaultType, tree.fieldNames());
        EObjectTypeProperty typeProperty = propertyMap.getTypeProperty();
        if (typeProperty != null && (value = tree.get(typeProperty.getFieldName())) != null) {
            object = typeProperty.create(value.asText(), ctxt);
        }
        if (object == null) {
            object = EcoreUtil.create((EClass)defaultType);
        }
        propertyMap = this.builder.construct((DatabindContext)ctxt, object.eClass());
        jp = buffer.asParser();
        JsonToken nextToken = jp.nextToken();
        while (nextToken != JsonToken.END_OBJECT && nextToken != null) {
            String field = jp.getCurrentName();
            EObjectProperty property = propertyMap.findProperty(field);
            if (property != null) {
                property.deserializeAndSet(jp, object, ctxt, resource);
            } else {
                this.handleUnknownProperty(jp, resource, ctxt);
            }
            nextToken = jp.nextToken();
        }
        jp.close();
        buffer.close();
        return object;
    }

    private void handleUnknownProperty(JsonParser jp, Resource resource, DeserializationContext ctxt) throws IOException {
        if (resource != null && ctxt.getConfig().hasDeserializationFeatures(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES.getMask())) {
            resource.getErrors().add((Object)new JSONException("Unknown feature " + jp.getCurrentName(), jp.getCurrentLocation()));
        }
        jp.nextToken();
        jp.skipChildren();
    }

    public boolean isCachable() {
        return true;
    }

    public Class<?> handledType() {
        return EObject.class;
    }

    private EClass getDefaultType(DeserializationContext ctxt) {
        EClass type = null;
        EObject parent = EMFContext.getParent((DatabindContext)ctxt);
        if (parent == null) {
            if (this.currentType != null && this.currentType != EObject.class) {
                type = EMFContext.findEClassByQualifiedName((DatabindContext)ctxt, this.currentType.getCanonicalName());
            }
            if (type == null) {
                type = EMFContext.getRoot((DatabindContext)ctxt);
            }
        } else {
            EReference reference = (EReference)EMFContext.getFeature((DatabindContext)ctxt);
            if (reference != null && !reference.getEReferenceType().isAbstract()) {
                type = reference.getEReferenceType();
            }
        }
        return type;
    }
}

