/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfatic.compare.ecore;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.accessor.AccessorAdapter;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl.MatchAccessor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.emfatic.core.generator.emfatic.Writer;
import org.eclipse.emf.emfatic.ui.editor.EmfaticEditor;
import org.eclipse.emf.emfatic.ui.editor.EmfaticSourceViewerConfiguration;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class EcoreToEmfaticViewer
extends TextMergeViewer {
    public EcoreToEmfaticViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
    }

    public void setInput(Object input) {
        if (input instanceof ICompareInput) {
            ICompareInput originalInput = (ICompareInput)input;
            EObject ancestor = this.getEObject(originalInput.getAncestor());
            EObject left = this.getEObject(originalInput.getLeft());
            EObject right = this.getEObject(originalInput.getRight());
            super.setInput((Object)new EmfaticCompareInput(originalInput, left, right, ancestor));
        } else {
            super.setInput(input);
        }
    }

    public String getTitle() {
        return "Emfatic Compare";
    }

    protected void configureTextViewer(TextViewer textViewer) {
        super.configureTextViewer(textViewer);
        if (textViewer instanceof ISourceViewer) {
            EmfaticSourceViewerConfiguration configuration = new EmfaticSourceViewerConfiguration(new EmfaticEditor());
            configuration.getPresentationReconciler((ISourceViewer)textViewer).install((ITextViewer)textViewer);
        }
    }

    protected EObject getEObject(Object inputSide) {
        AccessorAdapter accAdapter;
        Object target;
        if (inputSide instanceof AccessorAdapter && (target = (accAdapter = (AccessorAdapter)inputSide).getTarget()) instanceof MatchAccessor) {
            MatchAccessor ma = (MatchAccessor)target;
            IMergeViewerItem mergeItem = ma.getInitialItem();
            switch (mergeItem.getSide()) {
                case LEFT: {
                    return (EObject)mergeItem.getLeft();
                }
                case RIGHT: {
                    return (EObject)mergeItem.getRight();
                }
                case ANCESTOR: {
                    return (EObject)mergeItem.getAncestor();
                }
            }
        }
        return null;
    }

    protected static class DummyDocument
    extends AbstractDocument
    implements ITypedElement {
        public DummyDocument() {
            this.setTextStore(new StringStore());
            this.setLineTracker((ILineTracker)new DefaultLineTracker());
        }

        public String getName() {
            return "Name";
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return "dummy";
        }

        protected static class StringStore
        implements ITextStore {
            private String store = "";

            protected StringStore() {
            }

            public char get(int offset) {
                return this.store.charAt(offset);
            }

            public String get(int offset, int length) {
                return this.store.substring(offset, offset + length);
            }

            public int getLength() {
                return this.store.length();
            }

            public void replace(int offset, int length, String text) {
            }

            public void set(String text) {
                this.store = text;
            }
        }
    }

    protected static class EmfaticCompareInput
    implements ICompareInput {
        private final ICompareInput originalInput;
        private final EObject left;
        private final EObject right;
        private final EObject ancestor;

        public EmfaticCompareInput(ICompareInput originalInput, EObject left, EObject right, EObject ancestor) {
            this.originalInput = originalInput;
            this.left = left;
            this.right = right;
            this.ancestor = ancestor;
        }

        public String getName() {
            return this.originalInput.getName();
        }

        public Image getImage() {
            return this.originalInput.getImage();
        }

        public int getKind() {
            return this.originalInput.getKind();
        }

        public ITypedElement getAncestor() {
            return this.ancestor == null ? null : this.getDocument(this.ancestor);
        }

        public ITypedElement getLeft() {
            return this.left == null ? null : this.getDocument(this.left);
        }

        private ITypedElement getDocument(EObject eObject) {
            String text = null;
            if (eObject == null || !"http://www.eclipse.org/emf/2002/Ecore".equals(eObject.eClass().getEPackage().getNsURI())) {
                text = "Not an Ecore metamodel - cannot turn into Emfatic source";
            }
            if (text == null) {
                if (eObject.eContainer() == null) {
                    Writer w = new Writer();
                    text = w.write(eObject.eResource());
                } else {
                    text = eObject instanceof EPackage ? Writer.stringify((EPackage)((EPackage)eObject)) : (eObject instanceof EStructuralFeature ? Writer.stringify((EStructuralFeature)((EStructuralFeature)eObject)) : Writer.stringify((EObject)eObject));
                }
            }
            DummyDocument leftDoc = new DummyDocument();
            leftDoc.set(text);
            return leftDoc;
        }

        public ITypedElement getRight() {
            return this.right == null ? null : this.getDocument(this.right);
        }

        public void addCompareInputChangeListener(ICompareInputChangeListener listener) {
        }

        public void removeCompareInputChangeListener(ICompareInputChangeListener listener) {
        }

        public void copy(boolean leftToRight) {
        }
    }
}

