/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package PAM.util;

import PAM.*;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see PAM.PAMPackage
 * @generated
 */
public class PAMAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static PAMPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PAMAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = PAMPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PAMSwitch modelSwitch =
		new PAMSwitch() {
			public Object caseNodes(Nodes object) {
				return createNodesAdapter();
			}
			public Object caseNetworkNode(NetworkNode object) {
				return createNetworkNodeAdapter();
			}
			public Object caseServerNode(ServerNode object) {
				return createServerNodeAdapter();
			}
			public Object caseClientNode(ClientNode object) {
				return createClientNodeAdapter();
			}
			public Object caseNetworkObjectLink(NetworkObjectLink object) {
				return createNetworkObjectLinkAdapter();
			}
			public Object caseRoom(Room object) {
				return createRoomAdapter();
			}
			public Object caseCooling(Cooling object) {
				return createCoolingAdapter();
			}
			public Object caseUninterruptiblePowerSupply(UninterruptiblePowerSupply object) {
				return createUninterruptiblePowerSupplyAdapter();
			}
			public Object defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	public Adapter createAdapter(Notifier target) {
		return (Adapter)modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link PAM.Nodes <em>Nodes</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see PAM.Nodes
	 * @generated
	 */
	public Adapter createNodesAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link PAM.NetworkNode <em>Network Node</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see PAM.NetworkNode
	 * @generated
	 */
	public Adapter createNetworkNodeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link PAM.ServerNode <em>Server Node</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see PAM.ServerNode
	 * @generated
	 */
	public Adapter createServerNodeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link PAM.ClientNode <em>Client Node</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see PAM.ClientNode
	 * @generated
	 */
	public Adapter createClientNodeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link PAM.NetworkObjectLink <em>Network Object Link</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see PAM.NetworkObjectLink
	 * @generated
	 */
	public Adapter createNetworkObjectLinkAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link PAM.Room <em>Room</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see PAM.Room
	 * @generated
	 */
	public Adapter createRoomAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link PAM.Cooling <em>Cooling</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see PAM.Cooling
	 * @generated
	 */
	public Adapter createCoolingAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link PAM.UninterruptiblePowerSupply <em>Uninterruptible Power Supply</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see PAM.UninterruptiblePowerSupply
	 * @generated
	 */
	public Adapter createUninterruptiblePowerSupplyAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //PAMAdapterFactory
