package simplewebmodel.smells;

import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

import simplewebmodel.Entity;
import simplewebmodel.smells.helper.SimpleWebModelHelper;

public class UnusedEntity implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		List<Entity> entities = SimpleWebModelHelper.getAllEntities(root);	
		for (Entity entity : entities) {
			boolean isReferencedByDynamicPage = 
					SimpleWebModelHelper.isReferencedByDynamicPage(entity, root);
			boolean isReferencedByEntity = 
					SimpleWebModelHelper.isReferencedByEntity(entity, root);
			if (! isReferencedByDynamicPage && ! isReferencedByEntity) {
				LinkedList<EObject> result = new LinkedList<EObject>();
				result.add(entity);
				results.add(result);
			}
		}
		return results;
	}
}
