package simplewebmodel.smells;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

import simplewebmodel.DataPage;
import simplewebmodel.Entity;
import simplewebmodel.IndexPage;

public class MissingDataPage implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		List<Entity> entities = getAllEntities(root);
		List<IndexPage> indexPages = getAllIndexPages(root);
		List<DataPage> dataPages = getAllDataPages(root);
		for (Entity entity : entities) {
			boolean isReferencedByIndexPage = false;
			IndexPage page = null;
			for (IndexPage indexPage : indexPages) {
				if (indexPage.getEntity() == entity) {
					page = indexPage;
					isReferencedByIndexPage = true;
				}
			}
			if (isReferencedByIndexPage) {
				boolean isReferencedByDataPage = false;
				for (DataPage dataPage : dataPages) {
					if (dataPage.getEntity() == entity) {
						isReferencedByDataPage = true;
					}
				}
				if (! isReferencedByDataPage) {
					LinkedList<EObject> result = new LinkedList<EObject>();
					result.add(entity);
					result.add(page);
					results.add(result);
				}
			}
		}
		return results;		
	}
	
	private List<Entity> getAllEntities(EObject root) {
		List<Entity> entities = new ArrayList<Entity>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof Entity) {
				entities.add((Entity) eObject);
			}
		}
		return entities;
	}
	
	private List<IndexPage> getAllIndexPages(EObject root) {
		List<IndexPage> indexPages = new ArrayList<IndexPage>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof IndexPage) {
				indexPages.add((IndexPage) eObject);
			}
		}
		return indexPages;
	}
	
	private List<DataPage> getAllDataPages(EObject root) {
		List<DataPage> dataPages = new ArrayList<DataPage>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof DataPage) {
				dataPages.add((DataPage) eObject);
			}
		}
		return dataPages;
	}

}
