package simplewebmodel.smells;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.smells.interfaces.IModelSmellFinder;

import simplewebmodel.Page;

public class EquallyNamedPages implements IModelSmellFinder {

	@Override
	public LinkedList<LinkedList<EObject>> findSmell(EObject root) {
		LinkedList<LinkedList<EObject>> results = new LinkedList<LinkedList<EObject>>();
		List<Page> pages = getAllPages(root);
		for (Page page1 : pages) {
			for (Page page2 : pages) {
				if (page1.getName() != null && page2.getName() != null)
				if (page1 != page2 && page1.getName().equals(page2.getName())) {
					LinkedList<EObject> result = new LinkedList<EObject>();
					result.add(page1);
					result.add(page2);
					results.add(result);
				}
			}
		}
		return results;		
	}
	
	private List<Page> getAllPages(EObject root) {
		List<Page> pages = new ArrayList<Page>();
		TreeIterator<EObject> iter = root.eAllContents();
		while (iter.hasNext()) {
			EObject eObject = iter.next();
			if (eObject instanceof Page) {
				pages.add((Page) eObject);
			}
		}
		return pages;
	}

}
