package simplewebmodel.metrics;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.refactor.metrics.interfaces.IMetricCalculator;

import simplewebmodel.DynamicPage;
import simplewebmodel.Entity;
import simplewebmodel.Page;
import simplewebmodel.WebModel;

public class NumberOfReferencedDynamicPages implements IMetricCalculator {

	private List<EObject> context; 

	@Override
	public double calculate() {
		Entity entity = (Entity) context.get(0);
		WebModel model = (WebModel) EcoreUtil.getRootContainer(entity);	
		double result = 0;
		for (Page page : model.getHypertextLayer().getPages()) {
			if (page instanceof DynamicPage) {
				if (((DynamicPage) page).getEntity() == entity) {
					result++;
				}
			}
		}
		return result;
	}

	@Override
	public void setContext(List<EObject> context) {
		this.context = context;
	}
	
}
