package simplewebmodel.metrics;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.metrics.interfaces.IMetricCalculator;

import simplewebmodel.WebModel;

public class NumberOfEntities implements IMetricCalculator {

	private List<EObject> context; 

	@Override
	public double calculate() {
		WebModel model = (WebModel) context.get(0);
		return model.getDataLayer().getEntities().size();
	}

	@Override
	public void setContext(List<EObject> context) {
		this.context = context;
	}

}
