package simplewebmodel.metrics;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.metrics.interfaces.IMetricCalculator;
import org.eclipse.emf.refactor.metrics.ocl.managers.OCLManager;

import simplewebmodel.Entity;

public class NumberOfAttributesInEntity implements IMetricCalculator {

	private List<EObject> context; 

	private final String expression = "self.attributes -> size()";	

	@Override
	public double calculate() {
		Entity entity = (Entity) context.get(0);
		return OCLManager.evaluateOCLOnContextObject(entity, expression);
	}

	@Override
	public void setContext(List<EObject> context) {
		this.context = context;
	}

}
