package simplewebmodel.metrics;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.metrics.interfaces.IMetricCalculator;
import org.eclipse.emf.refactor.metrics.ocl.managers.OCLManager;

import simplewebmodel.WebModel;

public class NumberOfAttributes implements IMetricCalculator {
	
	private List<EObject> context; 

	private final String expression = 
			"self.dataLayer.entities.attributes -> size()";	

	@Override
	public double calculate() {
		WebModel model = (WebModel) context.get(0);
		return OCLManager.evaluateOCLOnContextObject(model, expression);
	}

	@Override
	public void setContext(List<EObject> context) {
		this.context = context;
	}

}
