/*
 * 
 */
package simplewebmodel.diagram.providers;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

import simplewebmodel.SimplewebmodelPackage;
import simplewebmodel.diagram.edit.parts.AttributeEditPart;
import simplewebmodel.diagram.edit.parts.DataLayerEditPart;
import simplewebmodel.diagram.edit.parts.DataPageEditPart;
import simplewebmodel.diagram.edit.parts.DynamicPageEntityEditPart;
import simplewebmodel.diagram.edit.parts.EntityEditPart;
import simplewebmodel.diagram.edit.parts.HypertextLayerEditPart;
import simplewebmodel.diagram.edit.parts.IndexPageEditPart;
import simplewebmodel.diagram.edit.parts.LinkEditPart;
import simplewebmodel.diagram.edit.parts.ReferenceEditPart;
import simplewebmodel.diagram.edit.parts.StaticPageEditPart;
import simplewebmodel.diagram.edit.parts.WebModelEditPart;
import simplewebmodel.diagram.part.SimplewebmodelDiagramEditorPlugin;

/**
 * @generated
 */
public class SimplewebmodelElementTypes {

	/**
	 * @generated
	 */
	private SimplewebmodelElementTypes() {
	}

	/**
	 * @generated
	 */
	private static Map<IElementType, ENamedElement> elements;

	/**
	 * @generated
	 */
	private static ImageRegistry imageRegistry;

	/**
	 * @generated
	 */
	private static Set<IElementType> KNOWN_ELEMENT_TYPES;

	/**
	 * @generated
	 */
	public static final IElementType WebModel_1000 = getElementType("simplewebmodel.diagram.WebModel_1000"); //$NON-NLS-1$
	/**
	 * @generated
	 */
	public static final IElementType DataLayer_2001 = getElementType("simplewebmodel.diagram.DataLayer_2001"); //$NON-NLS-1$
	/**
	 * @generated
	 */
	public static final IElementType HypertextLayer_2002 = getElementType("simplewebmodel.diagram.HypertextLayer_2002"); //$NON-NLS-1$
	/**
	 * @generated
	 */
	public static final IElementType Entity_3001 = getElementType("simplewebmodel.diagram.Entity_3001"); //$NON-NLS-1$
	/**
	 * @generated
	 */
	public static final IElementType Attribute_3002 = getElementType("simplewebmodel.diagram.Attribute_3002"); //$NON-NLS-1$
	/**
	 * @generated
	 */
	public static final IElementType Reference_3003 = getElementType("simplewebmodel.diagram.Reference_3003"); //$NON-NLS-1$
	/**
	 * @generated
	 */
	public static final IElementType IndexPage_3004 = getElementType("simplewebmodel.diagram.IndexPage_3004"); //$NON-NLS-1$
	/**
	 * @generated
	 */
	public static final IElementType DataPage_3005 = getElementType("simplewebmodel.diagram.DataPage_3005"); //$NON-NLS-1$
	/**
	 * @generated
	 */
	public static final IElementType StaticPage_3006 = getElementType("simplewebmodel.diagram.StaticPage_3006"); //$NON-NLS-1$
	/**
	 * @generated
	 */
	public static final IElementType Link_4001 = getElementType("simplewebmodel.diagram.Link_4001"); //$NON-NLS-1$
	/**
	 * @generated
	 */
	public static final IElementType DynamicPageEntity_4002 = getElementType("simplewebmodel.diagram.DynamicPageEntity_4002"); //$NON-NLS-1$

	/**
	 * @generated
	 */
	private static ImageRegistry getImageRegistry() {
		if (imageRegistry == null) {
			imageRegistry = new ImageRegistry();
		}
		return imageRegistry;
	}

	/**
	 * @generated
	 */
	private static String getImageRegistryKey(ENamedElement element) {
		return element.getName();
	}

	/**
	 * @generated
	 */
	private static ImageDescriptor getProvidedImageDescriptor(
			ENamedElement element) {
		if (element instanceof EStructuralFeature) {
			EStructuralFeature feature = ((EStructuralFeature) element);
			EClass eContainingClass = feature.getEContainingClass();
			EClassifier eType = feature.getEType();
			if (eContainingClass != null && !eContainingClass.isAbstract()) {
				element = eContainingClass;
			} else if (eType instanceof EClass
					&& !((EClass) eType).isAbstract()) {
				element = eType;
			}
		}
		if (element instanceof EClass) {
			EClass eClass = (EClass) element;
			if (!eClass.isAbstract()) {
				return SimplewebmodelDiagramEditorPlugin.getInstance()
						.getItemImageDescriptor(
								eClass.getEPackage().getEFactoryInstance()
										.create(eClass));
			}
		}
		// TODO : support structural features
		return null;
	}

	/**
	 * @generated
	 */
	public static ImageDescriptor getImageDescriptor(ENamedElement element) {
		String key = getImageRegistryKey(element);
		ImageDescriptor imageDescriptor = getImageRegistry().getDescriptor(key);
		if (imageDescriptor == null) {
			imageDescriptor = getProvidedImageDescriptor(element);
			if (imageDescriptor == null) {
				imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
			}
			getImageRegistry().put(key, imageDescriptor);
		}
		return imageDescriptor;
	}

	/**
	 * @generated
	 */
	public static Image getImage(ENamedElement element) {
		String key = getImageRegistryKey(element);
		Image image = getImageRegistry().get(key);
		if (image == null) {
			ImageDescriptor imageDescriptor = getProvidedImageDescriptor(element);
			if (imageDescriptor == null) {
				imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
			}
			getImageRegistry().put(key, imageDescriptor);
			image = getImageRegistry().get(key);
		}
		return image;
	}

	/**
	 * @generated
	 */
	public static ImageDescriptor getImageDescriptor(IAdaptable hint) {
		ENamedElement element = getElement(hint);
		if (element == null) {
			return null;
		}
		return getImageDescriptor(element);
	}

	/**
	 * @generated
	 */
	public static Image getImage(IAdaptable hint) {
		ENamedElement element = getElement(hint);
		if (element == null) {
			return null;
		}
		return getImage(element);
	}

	/**
	 * Returns 'type' of the ecore object associated with the hint.
	 * 
	 * @generated
	 */
	public static ENamedElement getElement(IAdaptable hint) {
		Object type = hint.getAdapter(IElementType.class);
		if (elements == null) {
			elements = new IdentityHashMap<IElementType, ENamedElement>();

			elements.put(WebModel_1000,
					SimplewebmodelPackage.eINSTANCE.getWebModel());

			elements.put(DataLayer_2001,
					SimplewebmodelPackage.eINSTANCE.getDataLayer());

			elements.put(HypertextLayer_2002,
					SimplewebmodelPackage.eINSTANCE.getHypertextLayer());

			elements.put(Entity_3001,
					SimplewebmodelPackage.eINSTANCE.getEntity());

			elements.put(Attribute_3002,
					SimplewebmodelPackage.eINSTANCE.getAttribute());

			elements.put(Reference_3003,
					SimplewebmodelPackage.eINSTANCE.getReference());

			elements.put(IndexPage_3004,
					SimplewebmodelPackage.eINSTANCE.getIndexPage());

			elements.put(DataPage_3005,
					SimplewebmodelPackage.eINSTANCE.getDataPage());

			elements.put(StaticPage_3006,
					SimplewebmodelPackage.eINSTANCE.getStaticPage());

			elements.put(Link_4001, SimplewebmodelPackage.eINSTANCE.getLink());

			elements.put(DynamicPageEntity_4002,
					SimplewebmodelPackage.eINSTANCE.getDynamicPage_Entity());
		}
		return (ENamedElement) elements.get(type);
	}

	/**
	 * @generated
	 */
	private static IElementType getElementType(String id) {
		return ElementTypeRegistry.getInstance().getType(id);
	}

	/**
	 * @generated
	 */
	public static boolean isKnownElementType(IElementType elementType) {
		if (KNOWN_ELEMENT_TYPES == null) {
			KNOWN_ELEMENT_TYPES = new HashSet<IElementType>();
			KNOWN_ELEMENT_TYPES.add(WebModel_1000);
			KNOWN_ELEMENT_TYPES.add(DataLayer_2001);
			KNOWN_ELEMENT_TYPES.add(HypertextLayer_2002);
			KNOWN_ELEMENT_TYPES.add(Entity_3001);
			KNOWN_ELEMENT_TYPES.add(Attribute_3002);
			KNOWN_ELEMENT_TYPES.add(Reference_3003);
			KNOWN_ELEMENT_TYPES.add(IndexPage_3004);
			KNOWN_ELEMENT_TYPES.add(DataPage_3005);
			KNOWN_ELEMENT_TYPES.add(StaticPage_3006);
			KNOWN_ELEMENT_TYPES.add(Link_4001);
			KNOWN_ELEMENT_TYPES.add(DynamicPageEntity_4002);
		}
		return KNOWN_ELEMENT_TYPES.contains(elementType);
	}

	/**
	 * @generated
	 */
	public static IElementType getElementType(int visualID) {
		switch (visualID) {
		case WebModelEditPart.VISUAL_ID:
			return WebModel_1000;
		case DataLayerEditPart.VISUAL_ID:
			return DataLayer_2001;
		case HypertextLayerEditPart.VISUAL_ID:
			return HypertextLayer_2002;
		case EntityEditPart.VISUAL_ID:
			return Entity_3001;
		case AttributeEditPart.VISUAL_ID:
			return Attribute_3002;
		case ReferenceEditPart.VISUAL_ID:
			return Reference_3003;
		case IndexPageEditPart.VISUAL_ID:
			return IndexPage_3004;
		case DataPageEditPart.VISUAL_ID:
			return DataPage_3005;
		case StaticPageEditPart.VISUAL_ID:
			return StaticPage_3006;
		case LinkEditPart.VISUAL_ID:
			return Link_4001;
		case DynamicPageEntityEditPart.VISUAL_ID:
			return DynamicPageEntity_4002;
		}
		return null;
	}

}
