/*
 * 
 */
package simplewebmodel.diagram.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.structure.DiagramStructure;

import simplewebmodel.SimplewebmodelPackage;
import simplewebmodel.WebModel;
import simplewebmodel.diagram.edit.parts.AttributeEditPart;
import simplewebmodel.diagram.edit.parts.AttributeNameEditPart;
import simplewebmodel.diagram.edit.parts.DataLayerDataLayerEntitiesCompartmentEditPart;
import simplewebmodel.diagram.edit.parts.DataLayerEditPart;
import simplewebmodel.diagram.edit.parts.DataLayerNameEditPart;
import simplewebmodel.diagram.edit.parts.DataPageEditPart;
import simplewebmodel.diagram.edit.parts.DataPageNameEditPart;
import simplewebmodel.diagram.edit.parts.DynamicPageEntityEditPart;
import simplewebmodel.diagram.edit.parts.EntityEditPart;
import simplewebmodel.diagram.edit.parts.EntityEntityAttributesCompartmentEditPart;
import simplewebmodel.diagram.edit.parts.EntityEntityReferencesCompartmentEditPart;
import simplewebmodel.diagram.edit.parts.EntityNameEditPart;
import simplewebmodel.diagram.edit.parts.HypertextLayerEditPart;
import simplewebmodel.diagram.edit.parts.HypertextLayerHypertextLayerPagesCompartmentEditPart;
import simplewebmodel.diagram.edit.parts.HypertextLayerNameEditPart;
import simplewebmodel.diagram.edit.parts.IndexPageEditPart;
import simplewebmodel.diagram.edit.parts.IndexPageNameEditPart;
import simplewebmodel.diagram.edit.parts.LinkEditPart;
import simplewebmodel.diagram.edit.parts.ReferenceEditPart;
import simplewebmodel.diagram.edit.parts.ReferenceNameEditPart;
import simplewebmodel.diagram.edit.parts.StaticPageEditPart;
import simplewebmodel.diagram.edit.parts.StaticPageNameEditPart;
import simplewebmodel.diagram.edit.parts.WebModelEditPart;
import simplewebmodel.diagram.edit.parts.WrappingLabelEditPart;

/**
 * This registry is used to determine which type of visual object should be
 * created for the corresponding Diagram, Node, ChildNode or Link represented
 * by a domain model object.
 * 
 * @generated
 */
public class SimplewebmodelVisualIDRegistry {

	/**
	 * @generated
	 */
	private static final String DEBUG_KEY = "simplewebmodel.diagram/debug/visualID"; //$NON-NLS-1$

	/**
	 * @generated
	 */
	public static int getVisualID(View view) {
		if (view instanceof Diagram) {
			if (WebModelEditPart.MODEL_ID.equals(view.getType())) {
				return WebModelEditPart.VISUAL_ID;
			} else {
				return -1;
			}
		}
		return simplewebmodel.diagram.part.SimplewebmodelVisualIDRegistry
				.getVisualID(view.getType());
	}

	/**
	 * @generated
	 */
	public static String getModelID(View view) {
		View diagram = view.getDiagram();
		while (view != diagram) {
			EAnnotation annotation = view.getEAnnotation("Shortcut"); //$NON-NLS-1$
			if (annotation != null) {
				return (String) annotation.getDetails().get("modelID"); //$NON-NLS-1$
			}
			view = (View) view.eContainer();
		}
		return diagram != null ? diagram.getType() : null;
	}

	/**
	 * @generated
	 */
	public static int getVisualID(String type) {
		try {
			return Integer.parseInt(type);
		} catch (NumberFormatException e) {
			if (Boolean.TRUE.toString().equalsIgnoreCase(
					Platform.getDebugOption(DEBUG_KEY))) {
				SimplewebmodelDiagramEditorPlugin.getInstance().logError(
						"Unable to parse view type as a visualID number: "
								+ type);
			}
		}
		return -1;
	}

	/**
	 * @generated
	 */
	public static String getType(int visualID) {
		return Integer.toString(visualID);
	}

	/**
	 * @generated
	 */
	public static int getDiagramVisualID(EObject domainElement) {
		if (domainElement == null) {
			return -1;
		}
		if (SimplewebmodelPackage.eINSTANCE.getWebModel().isSuperTypeOf(
				domainElement.eClass())
				&& isDiagram((WebModel) domainElement)) {
			return WebModelEditPart.VISUAL_ID;
		}
		return -1;
	}

	/**
	 * @generated
	 */
	public static int getNodeVisualID(View containerView, EObject domainElement) {
		if (domainElement == null) {
			return -1;
		}
		String containerModelID = simplewebmodel.diagram.part.SimplewebmodelVisualIDRegistry
				.getModelID(containerView);
		if (!WebModelEditPart.MODEL_ID.equals(containerModelID)
				&& !"simplewebmodel".equals(containerModelID)) { //$NON-NLS-1$
			return -1;
		}
		int containerVisualID;
		if (WebModelEditPart.MODEL_ID.equals(containerModelID)) {
			containerVisualID = simplewebmodel.diagram.part.SimplewebmodelVisualIDRegistry
					.getVisualID(containerView);
		} else {
			if (containerView instanceof Diagram) {
				containerVisualID = WebModelEditPart.VISUAL_ID;
			} else {
				return -1;
			}
		}
		switch (containerVisualID) {
		case WebModelEditPart.VISUAL_ID:
			if (SimplewebmodelPackage.eINSTANCE.getDataLayer().isSuperTypeOf(
					domainElement.eClass())) {
				return DataLayerEditPart.VISUAL_ID;
			}
			if (SimplewebmodelPackage.eINSTANCE.getHypertextLayer()
					.isSuperTypeOf(domainElement.eClass())) {
				return HypertextLayerEditPart.VISUAL_ID;
			}
			break;
		case DataLayerDataLayerEntitiesCompartmentEditPart.VISUAL_ID:
			if (SimplewebmodelPackage.eINSTANCE.getEntity().isSuperTypeOf(
					domainElement.eClass())) {
				return EntityEditPart.VISUAL_ID;
			}
			break;
		case EntityEntityAttributesCompartmentEditPart.VISUAL_ID:
			if (SimplewebmodelPackage.eINSTANCE.getAttribute().isSuperTypeOf(
					domainElement.eClass())) {
				return AttributeEditPart.VISUAL_ID;
			}
			break;
		case EntityEntityReferencesCompartmentEditPart.VISUAL_ID:
			if (SimplewebmodelPackage.eINSTANCE.getReference().isSuperTypeOf(
					domainElement.eClass())) {
				return ReferenceEditPart.VISUAL_ID;
			}
			break;
		case HypertextLayerHypertextLayerPagesCompartmentEditPart.VISUAL_ID:
			if (SimplewebmodelPackage.eINSTANCE.getIndexPage().isSuperTypeOf(
					domainElement.eClass())) {
				return IndexPageEditPart.VISUAL_ID;
			}
			if (SimplewebmodelPackage.eINSTANCE.getDataPage().isSuperTypeOf(
					domainElement.eClass())) {
				return DataPageEditPart.VISUAL_ID;
			}
			if (SimplewebmodelPackage.eINSTANCE.getStaticPage().isSuperTypeOf(
					domainElement.eClass())) {
				return StaticPageEditPart.VISUAL_ID;
			}
			break;
		}
		return -1;
	}

	/**
	 * @generated
	 */
	public static boolean canCreateNode(View containerView, int nodeVisualID) {
		String containerModelID = simplewebmodel.diagram.part.SimplewebmodelVisualIDRegistry
				.getModelID(containerView);
		if (!WebModelEditPart.MODEL_ID.equals(containerModelID)
				&& !"simplewebmodel".equals(containerModelID)) { //$NON-NLS-1$
			return false;
		}
		int containerVisualID;
		if (WebModelEditPart.MODEL_ID.equals(containerModelID)) {
			containerVisualID = simplewebmodel.diagram.part.SimplewebmodelVisualIDRegistry
					.getVisualID(containerView);
		} else {
			if (containerView instanceof Diagram) {
				containerVisualID = WebModelEditPart.VISUAL_ID;
			} else {
				return false;
			}
		}
		switch (containerVisualID) {
		case WebModelEditPart.VISUAL_ID:
			if (DataLayerEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (HypertextLayerEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case DataLayerEditPart.VISUAL_ID:
			if (DataLayerNameEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (DataLayerDataLayerEntitiesCompartmentEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case HypertextLayerEditPart.VISUAL_ID:
			if (HypertextLayerNameEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (HypertextLayerHypertextLayerPagesCompartmentEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case EntityEditPart.VISUAL_ID:
			if (EntityNameEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (EntityEntityAttributesCompartmentEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (EntityEntityReferencesCompartmentEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case AttributeEditPart.VISUAL_ID:
			if (AttributeNameEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case ReferenceEditPart.VISUAL_ID:
			if (ReferenceNameEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case IndexPageEditPart.VISUAL_ID:
			if (IndexPageNameEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case DataPageEditPart.VISUAL_ID:
			if (DataPageNameEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case StaticPageEditPart.VISUAL_ID:
			if (StaticPageNameEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case DataLayerDataLayerEntitiesCompartmentEditPart.VISUAL_ID:
			if (EntityEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case EntityEntityAttributesCompartmentEditPart.VISUAL_ID:
			if (AttributeEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case EntityEntityReferencesCompartmentEditPart.VISUAL_ID:
			if (ReferenceEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case HypertextLayerHypertextLayerPagesCompartmentEditPart.VISUAL_ID:
			if (IndexPageEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (DataPageEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			if (StaticPageEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		case DynamicPageEntityEditPart.VISUAL_ID:
			if (WrappingLabelEditPart.VISUAL_ID == nodeVisualID) {
				return true;
			}
			break;
		}
		return false;
	}

	/**
	 * @generated
	 */
	public static int getLinkWithClassVisualID(EObject domainElement) {
		if (domainElement == null) {
			return -1;
		}
		if (SimplewebmodelPackage.eINSTANCE.getLink().isSuperTypeOf(
				domainElement.eClass())) {
			return LinkEditPart.VISUAL_ID;
		}
		return -1;
	}

	/**
	 * User can change implementation of this method to handle some specific
	 * situations not covered by default logic.
	 * 
	 * @generated
	 */
	private static boolean isDiagram(WebModel element) {
		return true;
	}

	/**
	 * @generated
	 */
	public static boolean checkNodeVisualID(View containerView,
			EObject domainElement, int candidate) {
		if (candidate == -1) {
			//unrecognized id is always bad
			return false;
		}
		int basic = getNodeVisualID(containerView, domainElement);
		return basic == candidate;
	}

	/**
	 * @generated
	 */
	public static boolean isCompartmentVisualID(int visualID) {
		switch (visualID) {
		case DataLayerDataLayerEntitiesCompartmentEditPart.VISUAL_ID:
		case EntityEntityAttributesCompartmentEditPart.VISUAL_ID:
		case EntityEntityReferencesCompartmentEditPart.VISUAL_ID:
		case HypertextLayerHypertextLayerPagesCompartmentEditPart.VISUAL_ID:
			return true;
		default:
			break;
		}
		return false;
	}

	/**
	 * @generated
	 */
	public static boolean isSemanticLeafVisualID(int visualID) {
		switch (visualID) {
		case WebModelEditPart.VISUAL_ID:
			return false;
		case AttributeEditPart.VISUAL_ID:
		case ReferenceEditPart.VISUAL_ID:
		case IndexPageEditPart.VISUAL_ID:
		case DataPageEditPart.VISUAL_ID:
		case StaticPageEditPart.VISUAL_ID:
			return true;
		default:
			break;
		}
		return false;
	}

	/**
	 * @generated
	 */
	public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure() {
		/**
		 * @generated
		 */
		@Override
		public int getVisualID(View view) {
			return simplewebmodel.diagram.part.SimplewebmodelVisualIDRegistry
					.getVisualID(view);
		}

		/**
		 * @generated
		 */
		@Override
		public String getModelID(View view) {
			return simplewebmodel.diagram.part.SimplewebmodelVisualIDRegistry
					.getModelID(view);
		}

		/**
		 * @generated
		 */
		@Override
		public int getNodeVisualID(View containerView, EObject domainElement) {
			return simplewebmodel.diagram.part.SimplewebmodelVisualIDRegistry
					.getNodeVisualID(containerView, domainElement);
		}

		/**
		 * @generated
		 */
		@Override
		public boolean checkNodeVisualID(View containerView,
				EObject domainElement, int candidate) {
			return simplewebmodel.diagram.part.SimplewebmodelVisualIDRegistry
					.checkNodeVisualID(containerView, domainElement, candidate);
		}

		/**
		 * @generated
		 */
		@Override
		public boolean isCompartmentVisualID(int visualID) {
			return simplewebmodel.diagram.part.SimplewebmodelVisualIDRegistry
					.isCompartmentVisualID(visualID);
		}

		/**
		 * @generated
		 */
		@Override
		public boolean isSemanticLeafVisualID(int visualID) {
			return simplewebmodel.diagram.part.SimplewebmodelVisualIDRegistry
					.isSemanticLeafVisualID(visualID);
		}
	};

}
