/*
 * 
 */
package simplewebmodel.diagram.part;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.update.DiagramUpdater;

import simplewebmodel.Attribute;
import simplewebmodel.DataLayer;
import simplewebmodel.DataPage;
import simplewebmodel.DynamicPage;
import simplewebmodel.Entity;
import simplewebmodel.HypertextLayer;
import simplewebmodel.IndexPage;
import simplewebmodel.Link;
import simplewebmodel.Page;
import simplewebmodel.Reference;
import simplewebmodel.SimplewebmodelPackage;
import simplewebmodel.StaticPage;
import simplewebmodel.WebModel;
import simplewebmodel.diagram.edit.parts.AttributeEditPart;
import simplewebmodel.diagram.edit.parts.DataLayerDataLayerEntitiesCompartmentEditPart;
import simplewebmodel.diagram.edit.parts.DataLayerEditPart;
import simplewebmodel.diagram.edit.parts.DataPageEditPart;
import simplewebmodel.diagram.edit.parts.DynamicPageEntityEditPart;
import simplewebmodel.diagram.edit.parts.EntityEditPart;
import simplewebmodel.diagram.edit.parts.EntityEntityAttributesCompartmentEditPart;
import simplewebmodel.diagram.edit.parts.EntityEntityReferencesCompartmentEditPart;
import simplewebmodel.diagram.edit.parts.HypertextLayerEditPart;
import simplewebmodel.diagram.edit.parts.HypertextLayerHypertextLayerPagesCompartmentEditPart;
import simplewebmodel.diagram.edit.parts.IndexPageEditPart;
import simplewebmodel.diagram.edit.parts.LinkEditPart;
import simplewebmodel.diagram.edit.parts.ReferenceEditPart;
import simplewebmodel.diagram.edit.parts.StaticPageEditPart;
import simplewebmodel.diagram.edit.parts.WebModelEditPart;
import simplewebmodel.diagram.providers.SimplewebmodelElementTypes;

/**
 * @generated
 */
public class SimplewebmodelDiagramUpdater {

	/**
	 * @generated
	 */
	public static boolean isShortcutOrphaned(View view) {
		return !view.isSetElement() || view.getElement() == null
				|| view.getElement().eIsProxy();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelNodeDescriptor> getSemanticChildren(
			View view) {
		switch (SimplewebmodelVisualIDRegistry.getVisualID(view)) {
		case WebModelEditPart.VISUAL_ID:
			return getWebModel_1000SemanticChildren(view);
		case DataLayerDataLayerEntitiesCompartmentEditPart.VISUAL_ID:
			return getDataLayerDataLayerEntitiesCompartment_7001SemanticChildren(view);
		case EntityEntityAttributesCompartmentEditPart.VISUAL_ID:
			return getEntityEntityAttributesCompartment_7002SemanticChildren(view);
		case EntityEntityReferencesCompartmentEditPart.VISUAL_ID:
			return getEntityEntityReferencesCompartment_7003SemanticChildren(view);
		case HypertextLayerHypertextLayerPagesCompartmentEditPart.VISUAL_ID:
			return getHypertextLayerHypertextLayerPagesCompartment_7004SemanticChildren(view);
		}
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelNodeDescriptor> getWebModel_1000SemanticChildren(
			View view) {
		if (!view.isSetElement()) {
			return Collections.emptyList();
		}
		WebModel modelElement = (WebModel) view.getElement();
		LinkedList<SimplewebmodelNodeDescriptor> result = new LinkedList<SimplewebmodelNodeDescriptor>();
		{
			DataLayer childElement = modelElement.getDataLayer();
			int visualID = SimplewebmodelVisualIDRegistry.getNodeVisualID(view,
					childElement);
			if (visualID == DataLayerEditPart.VISUAL_ID) {
				result.add(new SimplewebmodelNodeDescriptor(childElement,
						visualID));
			}
		}
		{
			HypertextLayer childElement = modelElement.getHypertextLayer();
			int visualID = SimplewebmodelVisualIDRegistry.getNodeVisualID(view,
					childElement);
			if (visualID == HypertextLayerEditPart.VISUAL_ID) {
				result.add(new SimplewebmodelNodeDescriptor(childElement,
						visualID));
			}
		}
		return result;
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelNodeDescriptor> getDataLayerDataLayerEntitiesCompartment_7001SemanticChildren(
			View view) {
		if (false == view.eContainer() instanceof View) {
			return Collections.emptyList();
		}
		View containerView = (View) view.eContainer();
		if (!containerView.isSetElement()) {
			return Collections.emptyList();
		}
		DataLayer modelElement = (DataLayer) containerView.getElement();
		LinkedList<SimplewebmodelNodeDescriptor> result = new LinkedList<SimplewebmodelNodeDescriptor>();
		for (Iterator<?> it = modelElement.getEntities().iterator(); it
				.hasNext();) {
			Entity childElement = (Entity) it.next();
			int visualID = SimplewebmodelVisualIDRegistry.getNodeVisualID(view,
					childElement);
			if (visualID == EntityEditPart.VISUAL_ID) {
				result.add(new SimplewebmodelNodeDescriptor(childElement,
						visualID));
				continue;
			}
		}
		return result;
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelNodeDescriptor> getEntityEntityAttributesCompartment_7002SemanticChildren(
			View view) {
		if (false == view.eContainer() instanceof View) {
			return Collections.emptyList();
		}
		View containerView = (View) view.eContainer();
		if (!containerView.isSetElement()) {
			return Collections.emptyList();
		}
		Entity modelElement = (Entity) containerView.getElement();
		LinkedList<SimplewebmodelNodeDescriptor> result = new LinkedList<SimplewebmodelNodeDescriptor>();
		for (Iterator<?> it = modelElement.getAttributes().iterator(); it
				.hasNext();) {
			Attribute childElement = (Attribute) it.next();
			int visualID = SimplewebmodelVisualIDRegistry.getNodeVisualID(view,
					childElement);
			if (visualID == AttributeEditPart.VISUAL_ID) {
				result.add(new SimplewebmodelNodeDescriptor(childElement,
						visualID));
				continue;
			}
		}
		return result;
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelNodeDescriptor> getEntityEntityReferencesCompartment_7003SemanticChildren(
			View view) {
		if (false == view.eContainer() instanceof View) {
			return Collections.emptyList();
		}
		View containerView = (View) view.eContainer();
		if (!containerView.isSetElement()) {
			return Collections.emptyList();
		}
		Entity modelElement = (Entity) containerView.getElement();
		LinkedList<SimplewebmodelNodeDescriptor> result = new LinkedList<SimplewebmodelNodeDescriptor>();
		for (Iterator<?> it = modelElement.getReferences().iterator(); it
				.hasNext();) {
			Reference childElement = (Reference) it.next();
			int visualID = SimplewebmodelVisualIDRegistry.getNodeVisualID(view,
					childElement);
			if (visualID == ReferenceEditPart.VISUAL_ID) {
				result.add(new SimplewebmodelNodeDescriptor(childElement,
						visualID));
				continue;
			}
		}
		return result;
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelNodeDescriptor> getHypertextLayerHypertextLayerPagesCompartment_7004SemanticChildren(
			View view) {
		if (false == view.eContainer() instanceof View) {
			return Collections.emptyList();
		}
		View containerView = (View) view.eContainer();
		if (!containerView.isSetElement()) {
			return Collections.emptyList();
		}
		HypertextLayer modelElement = (HypertextLayer) containerView
				.getElement();
		LinkedList<SimplewebmodelNodeDescriptor> result = new LinkedList<SimplewebmodelNodeDescriptor>();
		for (Iterator<?> it = modelElement.getPages().iterator(); it.hasNext();) {
			Page childElement = (Page) it.next();
			int visualID = SimplewebmodelVisualIDRegistry.getNodeVisualID(view,
					childElement);
			if (visualID == IndexPageEditPart.VISUAL_ID) {
				result.add(new SimplewebmodelNodeDescriptor(childElement,
						visualID));
				continue;
			}
			if (visualID == DataPageEditPart.VISUAL_ID) {
				result.add(new SimplewebmodelNodeDescriptor(childElement,
						visualID));
				continue;
			}
			if (visualID == StaticPageEditPart.VISUAL_ID) {
				result.add(new SimplewebmodelNodeDescriptor(childElement,
						visualID));
				continue;
			}
		}
		return result;
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getContainedLinks(View view) {
		switch (SimplewebmodelVisualIDRegistry.getVisualID(view)) {
		case WebModelEditPart.VISUAL_ID:
			return getWebModel_1000ContainedLinks(view);
		case DataLayerEditPart.VISUAL_ID:
			return getDataLayer_2001ContainedLinks(view);
		case HypertextLayerEditPart.VISUAL_ID:
			return getHypertextLayer_2002ContainedLinks(view);
		case EntityEditPart.VISUAL_ID:
			return getEntity_3001ContainedLinks(view);
		case AttributeEditPart.VISUAL_ID:
			return getAttribute_3002ContainedLinks(view);
		case ReferenceEditPart.VISUAL_ID:
			return getReference_3003ContainedLinks(view);
		case IndexPageEditPart.VISUAL_ID:
			return getIndexPage_3004ContainedLinks(view);
		case DataPageEditPart.VISUAL_ID:
			return getDataPage_3005ContainedLinks(view);
		case StaticPageEditPart.VISUAL_ID:
			return getStaticPage_3006ContainedLinks(view);
		case LinkEditPart.VISUAL_ID:
			return getLink_4001ContainedLinks(view);
		}
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getIncomingLinks(View view) {
		switch (SimplewebmodelVisualIDRegistry.getVisualID(view)) {
		case DataLayerEditPart.VISUAL_ID:
			return getDataLayer_2001IncomingLinks(view);
		case HypertextLayerEditPart.VISUAL_ID:
			return getHypertextLayer_2002IncomingLinks(view);
		case EntityEditPart.VISUAL_ID:
			return getEntity_3001IncomingLinks(view);
		case AttributeEditPart.VISUAL_ID:
			return getAttribute_3002IncomingLinks(view);
		case ReferenceEditPart.VISUAL_ID:
			return getReference_3003IncomingLinks(view);
		case IndexPageEditPart.VISUAL_ID:
			return getIndexPage_3004IncomingLinks(view);
		case DataPageEditPart.VISUAL_ID:
			return getDataPage_3005IncomingLinks(view);
		case StaticPageEditPart.VISUAL_ID:
			return getStaticPage_3006IncomingLinks(view);
		case LinkEditPart.VISUAL_ID:
			return getLink_4001IncomingLinks(view);
		}
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getOutgoingLinks(View view) {
		switch (SimplewebmodelVisualIDRegistry.getVisualID(view)) {
		case DataLayerEditPart.VISUAL_ID:
			return getDataLayer_2001OutgoingLinks(view);
		case HypertextLayerEditPart.VISUAL_ID:
			return getHypertextLayer_2002OutgoingLinks(view);
		case EntityEditPart.VISUAL_ID:
			return getEntity_3001OutgoingLinks(view);
		case AttributeEditPart.VISUAL_ID:
			return getAttribute_3002OutgoingLinks(view);
		case ReferenceEditPart.VISUAL_ID:
			return getReference_3003OutgoingLinks(view);
		case IndexPageEditPart.VISUAL_ID:
			return getIndexPage_3004OutgoingLinks(view);
		case DataPageEditPart.VISUAL_ID:
			return getDataPage_3005OutgoingLinks(view);
		case StaticPageEditPart.VISUAL_ID:
			return getStaticPage_3006OutgoingLinks(view);
		case LinkEditPart.VISUAL_ID:
			return getLink_4001OutgoingLinks(view);
		}
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getWebModel_1000ContainedLinks(
			View view) {
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getDataLayer_2001ContainedLinks(
			View view) {
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getHypertextLayer_2002ContainedLinks(
			View view) {
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getEntity_3001ContainedLinks(
			View view) {
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getAttribute_3002ContainedLinks(
			View view) {
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getReference_3003ContainedLinks(
			View view) {
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getIndexPage_3004ContainedLinks(
			View view) {
		IndexPage modelElement = (IndexPage) view.getElement();
		LinkedList<SimplewebmodelLinkDescriptor> result = new LinkedList<SimplewebmodelLinkDescriptor>();
		result.addAll(getContainedTypeModelFacetLinks_Link_4001(modelElement));
		result.addAll(getOutgoingFeatureModelFacetLinks_DynamicPage_Entity_4002(modelElement));
		return result;
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getDataPage_3005ContainedLinks(
			View view) {
		DataPage modelElement = (DataPage) view.getElement();
		LinkedList<SimplewebmodelLinkDescriptor> result = new LinkedList<SimplewebmodelLinkDescriptor>();
		result.addAll(getContainedTypeModelFacetLinks_Link_4001(modelElement));
		result.addAll(getOutgoingFeatureModelFacetLinks_DynamicPage_Entity_4002(modelElement));
		return result;
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getStaticPage_3006ContainedLinks(
			View view) {
		StaticPage modelElement = (StaticPage) view.getElement();
		LinkedList<SimplewebmodelLinkDescriptor> result = new LinkedList<SimplewebmodelLinkDescriptor>();
		result.addAll(getContainedTypeModelFacetLinks_Link_4001(modelElement));
		return result;
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getLink_4001ContainedLinks(
			View view) {
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getDataLayer_2001IncomingLinks(
			View view) {
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getHypertextLayer_2002IncomingLinks(
			View view) {
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getEntity_3001IncomingLinks(
			View view) {
		Entity modelElement = (Entity) view.getElement();
		Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences = EcoreUtil.CrossReferencer
				.find(view.eResource().getResourceSet().getResources());
		LinkedList<SimplewebmodelLinkDescriptor> result = new LinkedList<SimplewebmodelLinkDescriptor>();
		result.addAll(getIncomingFeatureModelFacetLinks_DynamicPage_Entity_4002(
				modelElement, crossReferences));
		return result;
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getAttribute_3002IncomingLinks(
			View view) {
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getReference_3003IncomingLinks(
			View view) {
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getIndexPage_3004IncomingLinks(
			View view) {
		IndexPage modelElement = (IndexPage) view.getElement();
		Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences = EcoreUtil.CrossReferencer
				.find(view.eResource().getResourceSet().getResources());
		LinkedList<SimplewebmodelLinkDescriptor> result = new LinkedList<SimplewebmodelLinkDescriptor>();
		result.addAll(getIncomingTypeModelFacetLinks_Link_4001(modelElement,
				crossReferences));
		return result;
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getDataPage_3005IncomingLinks(
			View view) {
		DataPage modelElement = (DataPage) view.getElement();
		Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences = EcoreUtil.CrossReferencer
				.find(view.eResource().getResourceSet().getResources());
		LinkedList<SimplewebmodelLinkDescriptor> result = new LinkedList<SimplewebmodelLinkDescriptor>();
		result.addAll(getIncomingTypeModelFacetLinks_Link_4001(modelElement,
				crossReferences));
		return result;
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getStaticPage_3006IncomingLinks(
			View view) {
		StaticPage modelElement = (StaticPage) view.getElement();
		Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences = EcoreUtil.CrossReferencer
				.find(view.eResource().getResourceSet().getResources());
		LinkedList<SimplewebmodelLinkDescriptor> result = new LinkedList<SimplewebmodelLinkDescriptor>();
		result.addAll(getIncomingTypeModelFacetLinks_Link_4001(modelElement,
				crossReferences));
		return result;
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getLink_4001IncomingLinks(
			View view) {
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getDataLayer_2001OutgoingLinks(
			View view) {
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getHypertextLayer_2002OutgoingLinks(
			View view) {
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getEntity_3001OutgoingLinks(
			View view) {
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getAttribute_3002OutgoingLinks(
			View view) {
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getReference_3003OutgoingLinks(
			View view) {
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getIndexPage_3004OutgoingLinks(
			View view) {
		IndexPage modelElement = (IndexPage) view.getElement();
		LinkedList<SimplewebmodelLinkDescriptor> result = new LinkedList<SimplewebmodelLinkDescriptor>();
		result.addAll(getOutgoingTypeModelFacetLinks_Link_4001(modelElement));
		result.addAll(getOutgoingFeatureModelFacetLinks_DynamicPage_Entity_4002(modelElement));
		return result;
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getDataPage_3005OutgoingLinks(
			View view) {
		DataPage modelElement = (DataPage) view.getElement();
		LinkedList<SimplewebmodelLinkDescriptor> result = new LinkedList<SimplewebmodelLinkDescriptor>();
		result.addAll(getOutgoingTypeModelFacetLinks_Link_4001(modelElement));
		result.addAll(getOutgoingFeatureModelFacetLinks_DynamicPage_Entity_4002(modelElement));
		return result;
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getStaticPage_3006OutgoingLinks(
			View view) {
		StaticPage modelElement = (StaticPage) view.getElement();
		LinkedList<SimplewebmodelLinkDescriptor> result = new LinkedList<SimplewebmodelLinkDescriptor>();
		result.addAll(getOutgoingTypeModelFacetLinks_Link_4001(modelElement));
		return result;
	}

	/**
	 * @generated
	 */
	public static List<SimplewebmodelLinkDescriptor> getLink_4001OutgoingLinks(
			View view) {
		return Collections.emptyList();
	}

	/**
	 * @generated
	 */
	private static Collection<SimplewebmodelLinkDescriptor> getContainedTypeModelFacetLinks_Link_4001(
			Page container) {
		LinkedList<SimplewebmodelLinkDescriptor> result = new LinkedList<SimplewebmodelLinkDescriptor>();
		for (Iterator<?> links = container.getLinks().iterator(); links
				.hasNext();) {
			EObject linkObject = (EObject) links.next();
			if (false == linkObject instanceof Link) {
				continue;
			}
			Link link = (Link) linkObject;
			if (LinkEditPart.VISUAL_ID != SimplewebmodelVisualIDRegistry
					.getLinkWithClassVisualID(link)) {
				continue;
			}
			Page dst = link.getTarget();
			Page src = link.getSource();
			result.add(new SimplewebmodelLinkDescriptor(src, dst, link,
					SimplewebmodelElementTypes.Link_4001,
					LinkEditPart.VISUAL_ID));
		}
		return result;
	}

	/**
	 * @generated
	 */
	private static Collection<SimplewebmodelLinkDescriptor> getIncomingTypeModelFacetLinks_Link_4001(
			Page target,
			Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
		LinkedList<SimplewebmodelLinkDescriptor> result = new LinkedList<SimplewebmodelLinkDescriptor>();
		Collection<EStructuralFeature.Setting> settings = crossReferences
				.get(target);
		for (EStructuralFeature.Setting setting : settings) {
			if (setting.getEStructuralFeature() != SimplewebmodelPackage.eINSTANCE
					.getLink_Target()
					|| false == setting.getEObject() instanceof Link) {
				continue;
			}
			Link link = (Link) setting.getEObject();
			if (LinkEditPart.VISUAL_ID != SimplewebmodelVisualIDRegistry
					.getLinkWithClassVisualID(link)) {
				continue;
			}
			Page src = link.getSource();
			result.add(new SimplewebmodelLinkDescriptor(src, target, link,
					SimplewebmodelElementTypes.Link_4001,
					LinkEditPart.VISUAL_ID));
		}
		return result;
	}

	/**
	 * @generated
	 */
	private static Collection<SimplewebmodelLinkDescriptor> getIncomingFeatureModelFacetLinks_DynamicPage_Entity_4002(
			Entity target,
			Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
		LinkedList<SimplewebmodelLinkDescriptor> result = new LinkedList<SimplewebmodelLinkDescriptor>();
		Collection<EStructuralFeature.Setting> settings = crossReferences
				.get(target);
		for (EStructuralFeature.Setting setting : settings) {
			if (setting.getEStructuralFeature() == SimplewebmodelPackage.eINSTANCE
					.getDynamicPage_Entity()) {
				result.add(new SimplewebmodelLinkDescriptor(setting
						.getEObject(), target,
						SimplewebmodelElementTypes.DynamicPageEntity_4002,
						DynamicPageEntityEditPart.VISUAL_ID));
			}
		}
		return result;
	}

	/**
	 * @generated
	 */
	private static Collection<SimplewebmodelLinkDescriptor> getOutgoingTypeModelFacetLinks_Link_4001(
			Page source) {
		Page container = null;
		// Find container element for the link.
		// Climb up by containment hierarchy starting from the source
		// and return the first element that is instance of the container class.
		for (EObject element = source; element != null && container == null; element = element
				.eContainer()) {
			if (element instanceof Page) {
				container = (Page) element;
			}
		}
		if (container == null) {
			return Collections.emptyList();
		}
		LinkedList<SimplewebmodelLinkDescriptor> result = new LinkedList<SimplewebmodelLinkDescriptor>();
		for (Iterator<?> links = container.getLinks().iterator(); links
				.hasNext();) {
			EObject linkObject = (EObject) links.next();
			if (false == linkObject instanceof Link) {
				continue;
			}
			Link link = (Link) linkObject;
			if (LinkEditPart.VISUAL_ID != SimplewebmodelVisualIDRegistry
					.getLinkWithClassVisualID(link)) {
				continue;
			}
			Page dst = link.getTarget();
			Page src = link.getSource();
			if (src != source) {
				continue;
			}
			result.add(new SimplewebmodelLinkDescriptor(src, dst, link,
					SimplewebmodelElementTypes.Link_4001,
					LinkEditPart.VISUAL_ID));
		}
		return result;
	}

	/**
	 * @generated
	 */
	private static Collection<SimplewebmodelLinkDescriptor> getOutgoingFeatureModelFacetLinks_DynamicPage_Entity_4002(
			DynamicPage source) {
		LinkedList<SimplewebmodelLinkDescriptor> result = new LinkedList<SimplewebmodelLinkDescriptor>();
		Entity destination = source.getEntity();
		if (destination == null) {
			return result;
		}
		result.add(new SimplewebmodelLinkDescriptor(source, destination,
				SimplewebmodelElementTypes.DynamicPageEntity_4002,
				DynamicPageEntityEditPart.VISUAL_ID));
		return result;
	}

	/**
	 * @generated
	 */
	public static final DiagramUpdater TYPED_INSTANCE = new DiagramUpdater() {
		/**
		 * @generated
		 */
		@Override
		public List<SimplewebmodelNodeDescriptor> getSemanticChildren(View view) {
			return SimplewebmodelDiagramUpdater.getSemanticChildren(view);
		}

		/**
		 * @generated
		 */
		@Override
		public List<SimplewebmodelLinkDescriptor> getContainedLinks(View view) {
			return SimplewebmodelDiagramUpdater.getContainedLinks(view);
		}

		/**
		 * @generated
		 */
		@Override
		public List<SimplewebmodelLinkDescriptor> getIncomingLinks(View view) {
			return SimplewebmodelDiagramUpdater.getIncomingLinks(view);
		}

		/**
		 * @generated
		 */
		@Override
		public List<SimplewebmodelLinkDescriptor> getOutgoingLinks(View view) {
			return SimplewebmodelDiagramUpdater.getOutgoingLinks(view);
		}
	};

}
