/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.refactor.metrics.uml24.est;

import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.metrics.interfaces.IMetricCalculator;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TypedElement;

public class CE
implements IMetricCalculator {
    private List<EObject> context;

    public void setContext(List<EObject> context) {
        this.context = context;
    }

    public double calculate() {
        double ret = 0.0;
        for (Class ownedclass : this.getOwnedClasses()) {
            if (!this.dependsOn(ownedclass, this.getOtherClasses())) continue;
            ret += 1.0;
        }
        return ret;
    }

    private boolean dependsOn(Class ownedclass, EList<Class> otherClasses) {
        boolean depends = false;
        for (Property attribute : ownedclass.getOwnedAttributes()) {
            depends |= this.hasType((TypedElement)attribute, otherClasses);
        }
        for (Operation operation : ownedclass.getOwnedOperations()) {
            for (Parameter parameter : operation.getOwnedParameters()) {
                depends |= this.hasType((TypedElement)parameter, otherClasses);
            }
        }
        for (Class superclass : ownedclass.getSuperClasses()) {
            depends |= otherClasses.contains((Object)superclass);
        }
        return depends;
    }

    private boolean hasType(TypedElement te, EList<Class> otherClasses) {
        if (te.getType() != null && te.getType() instanceof Class) {
            return otherClasses.contains((Object)te.getType());
        }
        return false;
    }

    private EList<Class> getAllClasses() {
        BasicEList classes = new BasicEList();
        TreeIterator iter = this.context.get(0).eResource().getAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof Class)) continue;
            classes.add((Object)((Class)eObject));
        }
        return classes;
    }

    private EList<Class> getOwnedClasses() {
        BasicEList classes = new BasicEList();
        for (PackageableElement pe : ((Package)this.context.get(0)).getPackagedElements()) {
            if (!(pe instanceof Class)) continue;
            classes.add((Object)((Class)pe));
        }
        return classes;
    }

    private EList<Class> getOtherClasses() {
        EList<Class> classes = this.getAllClasses();
        classes.removeAll(this.getOwnedClasses());
        return classes;
    }
}

