/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.core.datamodel;

import java.math.BigInteger;
import java.util.LinkedList;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdObjectDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdRegisterDMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.datamodel.SvdUtils;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.eclipse.embedcdt.packs.core.tree.Node;

public class SvdClusterDMNode
extends SvdDMNode {
    public SvdClusterDMNode(Leaf node) {
        super(node);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected SvdObjectDMNode[] prepareChildren(Leaf node) {
        if (node == null || !node.hasChildren()) {
            return null;
        }
        LinkedList<SvdDMNode> list = new LinkedList<SvdDMNode>();
        for (Leaf child : ((Node)node).getChildren()) {
            if (child.isType("register")) {
                list.add(new SvdRegisterDMNode(child));
                continue;
            }
            if (!child.isType("cluster")) continue;
            list.add(new SvdClusterDMNode(child));
        }
        if (this.getNode().getPackType() == Node.PACK_TYPE_XPACK) {
            Leaf clusters;
            Leaf group = ((Node)node).findChild("registers");
            if (group != null && group.hasChildren()) {
                for (Leaf child : ((Node)group).getChildren()) {
                    if (child.isType("register")) {
                        list.add(new SvdRegisterDMNode(child));
                        continue;
                    }
                    if (!child.isType("cluster")) continue;
                    list.add(new SvdClusterDMNode(child));
                }
            }
            if ((clusters = ((Node)node).findChild("clusters")) != null && clusters.hasChildren()) {
                for (Leaf child : ((Node)clusters).getChildren()) {
                    if (!child.isType("cluster")) continue;
                    list.add(new SvdClusterDMNode(child));
                }
            }
        }
        SvdObjectDMNode[] array = list.toArray(new SvdObjectDMNode[list.size()]);
        return array;
    }

    @Override
    public BigInteger getBigAddressOffset() {
        String str = this.getNode().getProperty("addressOffset");
        if (!str.isEmpty()) {
            return SvdUtils.parseScaledNonNegativeBigInteger(str);
        }
        return BigInteger.ZERO;
    }

    @Override
    public BigInteger getBigRepeatIncrement() {
        BigInteger bigRepeatIncrement = this.getBigArrayAddressIncrement();
        if (bigRepeatIncrement != BigInteger.ZERO) {
            return bigRepeatIncrement;
        }
        return null;
    }
}

