/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.core.dsf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Hashtable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.gdb.service.command.GDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.debug.gdbjtag.core.DebugUtils;
import org.eclipse.embedcdt.debug.gdbjtag.core.services.IGdbServerBackendService;
import org.eclipse.embedcdt.internal.debug.gdbjtag.core.Activator;
import org.osgi.framework.BundleContext;

public abstract class GnuMcuGdbServerBackend
extends AbstractDsfService
implements IGdbServerBackendService {
    protected final ILaunchConfiguration fLaunchConfiguration;
    protected boolean fDoStartGdbServer = true;
    protected Process fServerProcess;
    protected PushBackProcess fServerPipedProcess;
    protected GdbServerMonitorJob fServerMonitorJob;
    protected IMIBackend.State fServerBackendState = IMIBackend.State.NOT_INITIALIZED;
    private int fGdbServerExitValue = 0;
    protected IStatus fGdbServerExitStatus = null;
    private ScheduledFuture<?> fTimeoutFuture = null;
    private Job fStartGdbServerJob;
    private final String fBackendId;
    private static int fgInstanceCounter = 0;

    public GnuMcuGdbServerBackend(DsfSession session, ILaunchConfiguration lc) {
        super(session);
        this.fLaunchConfiguration = lc;
        this.fBackendId = "gdbServer[" + Integer.toString(fgInstanceCounter++) + "]";
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuGdbServerBackend(" + session + "," + lc.getName() + ")");
        }
    }

    public void initialize(final RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuGdbServerBackend.initialize()");
        }
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                GnuMcuGdbServerBackend.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        final Sequence.Step[] initializeSteps = this.fDoStartGdbServer ? new Sequence.Step[]{new RegisterStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING), new GdbServerStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING), new GdbServerMonitorStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING)} : new Sequence.Step[]{new RegisterStep(GDBControl.InitializationShutdownStep.Direction.INITIALIZING)};
        Sequence startupSequence = new Sequence(this.getExecutor(), rm){

            public Sequence.Step[] getSteps() {
                return initializeSteps;
            }
        };
        this.getExecutor().execute((Runnable)startupSequence);
    }

    public void shutdown(final RequestMonitor rm) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuGdbServerBackend.shutdown()");
        }
        final Sequence.Step[] shutdownSteps = this.fDoStartGdbServer ? new Sequence.Step[]{new GdbServerMonitorStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN), new GdbServerStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN), new RegisterStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN)} : new Sequence.Step[]{new RegisterStep(GDBControl.InitializationShutdownStep.Direction.SHUTTING_DOWN)};
        Sequence startupSequence = new Sequence(this.getExecutor(), (RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                GnuMcuGdbServerBackend.super.shutdown(rm);
            }
        }){

            public Sequence.Step[] getSteps() {
                return shutdownSteps;
            }
        };
        this.getExecutor().execute((Runnable)startupSequence);
    }

    @Override
    public void destroy() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuGdbServerBackend.destroy() " + Thread.currentThread());
        }
        if (this.fStartGdbServerJob != null && this.fStartGdbServerJob.getThread() != null) {
            this.fStartGdbServerJob.getThread().interrupt();
        }
        if (this.getServerProcess() != null && this.getServerState() == IMIBackend.State.STARTED) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GnuMcuGdbServerBackend.destroy() fServerProcess " + this.fServerProcess);
            }
            this.getServerProcess().destroy();
        } else if (this.fServerProcess != null) {
            this.fServerProcess.destroy();
        }
        if (this.fTimeoutFuture != null) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GnuMcuGdbServerBackend.destroy() cancel timeout");
            }
            this.fTimeoutFuture.cancel(true);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIStoppedEvent e) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(IMIBackend.BackendStateChangedEvent e) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuGdbServerBackend.eventDispatched() " + e);
        }
        if (this.fDoStartGdbServer) {
            if (e.getState() == IMIBackend.State.TERMINATED && e.getSessionId().equals(this.getSession().getId()) && this.getServerState() == IMIBackend.State.STARTED) {
                this.destroy();
            }
        } else {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GnuMcuGdbServerBackend.eventDispatched() -> dispatchEvent(ServerBackendStateChangedEvent, TERMINATED)");
            }
            this.getSession().dispatchEvent((Object)new IGdbServerBackendService.ServerBackendStateChangedEvent(this.getSession().getId(), this.getId(), IMIBackend.State.TERMINATED), this.getProperties());
        }
    }

    protected abstract BundleContext getBundleContext();

    public abstract String[] getServerCommandLineArray();

    public abstract int getServerLaunchTimeoutSeconds();

    public abstract String getServerName();

    public abstract String prepareMessageBoxText(int var1);

    public boolean canMatchStdOut() {
        return true;
    }

    public boolean matchStdOutExpectedPattern(String line) {
        return false;
    }

    public boolean canMatchStdErr() {
        return false;
    }

    public boolean matchStdErrExpectedPattern(String line) {
        return false;
    }

    public String getStartingServerJobName() {
        return "Starting " + this.getServerName();
    }

    public String getTerminatingServerJobName() {
        return "Terminating " + this.getServerName();
    }

    public String getMonitorServerJobName() {
        return String.valueOf(this.getServerName()) + " Monitor";
    }

    @Override
    public Process getServerProcess() {
        return this.fServerPipedProcess;
    }

    @Override
    public IMIBackend.State getServerState() {
        return this.fServerBackendState;
    }

    @Override
    public int getServerExitCode() {
        return this.fGdbServerExitValue;
    }

    @Override
    public IStatus getServerExitStatus() {
        return this.fGdbServerExitStatus;
    }

    @Override
    public String getId() {
        return this.fBackendId;
    }

    protected Process launchGdbServerProcess(String[] commandLineArray) throws CoreException {
        Process proc = null;
        File dir = null;
        IPath path = DebugUtils.getGdbWorkingDirectory(this.fLaunchConfiguration);
        if (path != null) {
            dir = new File(path.toOSString());
        }
        proc = DebugUtils.exec(commandLineArray, DebugUtils.getLaunchEnvironment(this.fLaunchConfiguration), dir);
        return proc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkServerStream(RequestMonitor serverLaunchRequestMonitor, IProgressMonitor monitor, StringBuffer buffer, boolean isStdoutStream) {
        String streamName = isStdoutStream ? "stdout" : "stderr";
        InputStream stream = null;
        try {
            byte[] b = new byte[1024];
            stream = isStdoutStream ? this.fServerProcess.getInputStream() : this.fServerProcess.getErrorStream();
            do {
                int count;
                if ((count = stream.read(b, 0, b.length)) == -1) {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("startGdbServerJob run() EOF " + streamName);
                    }
                    if (stream == null) return false;
                    try {
                        stream.close();
                        return false;
                    }
                    catch (IOException e) {
                        Activator.log((Throwable)e);
                        return false;
                    }
                }
                String str = new String(b, 0, count, "ascii");
                if (Activator.getInstance().isDebugging()) {
                    System.out.print(str);
                }
                buffer.append(new String(b, 0, count, "ascii"));
                if (isStdoutStream) {
                    if (this.matchStdOutExpectedPattern(buffer.toString())) return true;
                }
                if (isStdoutStream || !this.matchStdErrExpectedPattern(buffer.toString())) continue;
                return true;
            } while (!serverLaunchRequestMonitor.isCanceled() && !monitor.isCanceled());
            if (Activator.getInstance().isDebugging()) {
                System.out.println("startGdbServerJob run canceled read");
            }
            serverLaunchRequestMonitor.setStatus((IStatus)new Status(8, "org.eclipse.embedcdt.debug.gdbjtag.core", -1, String.valueOf(this.getStartingServerJobName()) + " cancelled.", null));
            serverLaunchRequestMonitor.done();
            return false;
        }
        catch (IOException e) {
            serverLaunchRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", -1, "Error reading " + this.getServerName() + " " + streamName, (Throwable)e));
            return false;
        }
    }

    protected boolean checkServer(RequestMonitor serverLaunchRequestMonitor, IProgressMonitor monitor, StringBuffer outBuffer, StringBuffer errBuffer) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("GnuMcuGdbServerBackend.checkServer()");
        }
        boolean success = false;
        if (!this.canMatchStdOut() && !this.canMatchStdErr()) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GnuMcuGdbServerBackend.checkServer() no need to match streams");
            }
            success = true;
        }
        if (this.canMatchStdOut() && this.checkServerStream(serverLaunchRequestMonitor, monitor, outBuffer, true)) {
            success = true;
        }
        if (this.canMatchStdErr() && this.checkServerStream(serverLaunchRequestMonitor, monitor, errBuffer, false)) {
            success = true;
        }
        if (success) {
            try {
                this.getExecutor().submit((Runnable)new DsfRunnable(){

                    public void run() {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println("startGdbServerJob run() State.STARTED");
                        }
                        GnuMcuGdbServerBackend.this.fServerBackendState = IMIBackend.State.STARTED;
                        if (GnuMcuGdbServerBackend.this.fGdbServerExitStatus == null) {
                            GnuMcuGdbServerBackend.this.fGdbServerExitStatus = Status.OK_STATUS;
                        }
                    }
                }).get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                Activator.log((Throwable)e);
            }
        }
        return success;
    }

    protected class GdbServerMonitorJob
    extends Job {
        boolean fMonitorExited;
        DsfRunnable fMonitorStarted;
        Process fProcess;

        public GdbServerMonitorJob(Process process, DsfRunnable monitorStarted) {
            super(GnuMcuGdbServerBackend.this.getMonitorServerJobName());
            this.fMonitorExited = false;
            this.fProcess = process;
            this.fMonitorStarted = monitorStarted;
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            Process process = this.fProcess;
            synchronized (process) {
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("GdbServerMonitorJob.run() submit " + this.fMonitorStarted + " thread " + this.getThread());
                }
                try {
                    boolean mustNotify = false;
                    try {
                        GnuMcuGdbServerBackend.this.fGdbServerExitValue = this.fProcess.exitValue();
                        mustNotify = true;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        GnuMcuGdbServerBackend.this.getExecutor().submit((Runnable)this.fMonitorStarted);
                        this.fProcess.waitFor();
                        GnuMcuGdbServerBackend.this.fGdbServerExitValue = this.fProcess.exitValue();
                    }
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("GdbServerMonitorJob.run() exitValue() " + GnuMcuGdbServerBackend.this.fGdbServerExitValue);
                    }
                    if (GnuMcuGdbServerBackend.this.fGdbServerExitValue != 0) {
                        final String message = GnuMcuGdbServerBackend.this.prepareMessageBoxText(GnuMcuGdbServerBackend.this.fGdbServerExitValue);
                        try {
                            GnuMcuGdbServerBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                                public void run() {
                                    if (Activator.getInstance().isDebugging()) {
                                        System.out.println("GdbServerMonitorJob.run() failed");
                                    }
                                    ((GdbServerMonitorJob)GdbServerMonitorJob.this).GnuMcuGdbServerBackend.this.fGdbServerExitStatus = new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", message);
                                }
                            }).get();
                        }
                        catch (ExecutionException e) {
                            Activator.log((Throwable)e);
                        }
                    }
                    GnuMcuGdbServerBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                        public void run() {
                            if (Activator.getInstance().isDebugging()) {
                                System.out.println("GdbServerMonitorJob.run() run() thread " + GdbServerMonitorJob.this.getThread());
                            }
                            GdbServerMonitorJob.this.fProcess.destroy();
                            GnuMcuGdbServerBackend.this.destroy();
                            if (Activator.getInstance().isDebugging()) {
                                System.out.println("GdbServerMonitorJob.run() run() State.TERMINATED");
                            }
                            if (((GdbServerMonitorJob)GdbServerMonitorJob.this).GnuMcuGdbServerBackend.this.fGdbServerExitStatus == null) {
                                ((GdbServerMonitorJob)GdbServerMonitorJob.this).GnuMcuGdbServerBackend.this.fGdbServerExitStatus = new Status(0, "org.eclipse.embedcdt.debug.gdbjtag.core", "TERMINATED");
                            }
                            ((GdbServerMonitorJob)GdbServerMonitorJob.this).GnuMcuGdbServerBackend.this.fServerBackendState = IMIBackend.State.TERMINATED;
                            if (Activator.getInstance().isDebugging()) {
                                System.out.println("GdbServerMonitorJob.run() run() dispatchEvent(ServerBackendStateChangedEvent, TERMINATED)");
                            }
                            GnuMcuGdbServerBackend.this.getSession().dispatchEvent((Object)new IGdbServerBackendService.ServerBackendStateChangedEvent(GnuMcuGdbServerBackend.this.getSession().getId(), GnuMcuGdbServerBackend.this.getId(), IMIBackend.State.TERMINATED), GnuMcuGdbServerBackend.this.getProperties());
                        }
                    });
                    if (mustNotify) {
                        GnuMcuGdbServerBackend.this.getExecutor().submit((Runnable)this.fMonitorStarted);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("GdbServerMonitorJob.run() fMonitorExited = true thread " + this.getThread());
                }
                this.fMonitorExited = true;
            }
            return status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            Process process = this.fProcess;
            synchronized (process) {
                if (!this.fMonitorExited) {
                    Thread thread = this.getThread();
                    if (thread != null) {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println("GdbServerMonitorJob.kill() interrupt " + thread.toString());
                        }
                        thread.interrupt();
                    } else {
                        Activator.log((String)"GdbServerMonitorJob.kill() null thread");
                    }
                }
            }
        }
    }

    protected class GdbServerMonitorStep
    extends GDBControl.InitializationShutdownStep {
        public GdbServerMonitorStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(final RequestMonitor rm) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GdbServerMonitorStep.initialize()");
            }
            GnuMcuGdbServerBackend.this.fServerMonitorJob = new GdbServerMonitorJob(GnuMcuGdbServerBackend.this.getServerProcess(), new DsfRunnable(){

                public void run() {
                    rm.done();
                }
            });
            GnuMcuGdbServerBackend.this.fServerMonitorJob.schedule();
        }

        protected void shutdown(RequestMonitor rm) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GdbServerMonitorStep.shutdown()");
            }
            if (GnuMcuGdbServerBackend.this.fServerMonitorJob != null) {
                GnuMcuGdbServerBackend.this.fServerMonitorJob.kill();
            }
            rm.done();
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GdbServerMonitorStep.shutdown() done");
            }
        }
    }

    protected class GdbServerStep
    extends GDBControl.InitializationShutdownStep {
        public GdbServerStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(final RequestMonitor rm) {
            Job startGdbServerJob;
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GdbServerStep.initialise()");
            }
            class ServerLaunchMonitor {
                boolean fIsTimeoutEnabled = true;
                boolean fWasTimeout = false;

                ServerLaunchMonitor() {
                }
            }
            final ServerLaunchMonitor fServerLaunchMonitor = new ServerLaunchMonitor();
            final RequestMonitor serverLaunchRequestMonitor = new RequestMonitor((Executor)GnuMcuGdbServerBackend.this.getExecutor(), rm){
                {
                    super($anonymous0, $anonymous1);
                }

                protected void handleCompleted() {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("GdbServerStep.initialise() handleCompleted()");
                    }
                    if (!fServerLaunchMonitor.fWasTimeout) {
                        fServerLaunchMonitor.fIsTimeoutEnabled = false;
                        if (!this.isSuccess()) {
                            rm.setStatus(this.getStatus());
                        }
                        rm.done();
                    }
                }
            };
            GnuMcuGdbServerBackend.this.fStartGdbServerJob = startGdbServerJob = new Job(GnuMcuGdbServerBackend.this.getStartingServerJobName()){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("GdbServerStep.initialise() Job run()");
                    }
                    if (serverLaunchRequestMonitor.isCanceled() || monitor.isCanceled()) {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println("startGdbServerJob run canceled");
                        }
                        serverLaunchRequestMonitor.setStatus((IStatus)new Status(8, "org.eclipse.embedcdt.debug.gdbjtag.core", -1, String.valueOf(GnuMcuGdbServerBackend.this.getStartingServerJobName()) + " cancelled.", null));
                        serverLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    String[] commandLineArray = GnuMcuGdbServerBackend.this.getServerCommandLineArray();
                    if (commandLineArray == null) {
                        serverLaunchRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", -1, String.valueOf(GnuMcuGdbServerBackend.this.getStartingServerJobName()) + " failed, cannot get commnd line.", null));
                        serverLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    try {
                        ((GdbServerStep)GdbServerStep.this).GnuMcuGdbServerBackend.this.fServerProcess = GnuMcuGdbServerBackend.this.launchGdbServerProcess(commandLineArray);
                    }
                    catch (CoreException e) {
                        serverLaunchRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", -1, e.getMessage(), (Throwable)e));
                        serverLaunchRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    boolean success = false;
                    StringBuffer outBuffer = new StringBuffer();
                    StringBuffer errBuffer = new StringBuffer();
                    success = GnuMcuGdbServerBackend.this.checkServer(serverLaunchRequestMonitor, monitor, outBuffer, errBuffer);
                    if (success || serverLaunchRequestMonitor.isSuccess()) {
                        ((GdbServerStep)GdbServerStep.this).GnuMcuGdbServerBackend.this.fServerPipedProcess = new PushBackProcess(((GdbServerStep)GdbServerStep.this).GnuMcuGdbServerBackend.this.fServerProcess, outBuffer, errBuffer);
                    }
                    if (!serverLaunchRequestMonitor.isCanceled()) {
                        serverLaunchRequestMonitor.done();
                    }
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("startGdbServerJob run completed");
                    }
                    return Status.OK_STATUS;
                }
            };
            startGdbServerJob.schedule();
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GdbServerStep.initialise() after job schedule");
            }
            GnuMcuGdbServerBackend.this.fTimeoutFuture = GnuMcuGdbServerBackend.this.getExecutor().schedule(new Runnable(){
                {
                }

                @Override
                public void run() {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("GdbServerStep.initialise() timeout run()");
                    }
                    if (fServerLaunchMonitor.fIsTimeoutEnabled) {
                        fServerLaunchMonitor.fWasTimeout = true;
                        Thread jobThread = startGdbServerJob.getThread();
                        if (jobThread != null) {
                            if (Activator.getInstance().isDebugging()) {
                                System.out.println("GdbServerStep.initialise() timeout interrupt thread " + jobThread);
                            }
                            jobThread.interrupt();
                        }
                        if (GnuMcuGdbServerBackend.this.getServerProcess() != null) {
                            GnuMcuGdbServerBackend.this.getServerProcess().destroy();
                        } else if (((GdbServerStep)GdbServerStep.this).GnuMcuGdbServerBackend.this.fServerProcess != null) {
                            ((GdbServerStep)GdbServerStep.this).GnuMcuGdbServerBackend.this.fServerProcess.destroy();
                        }
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", 5010, String.valueOf(GnuMcuGdbServerBackend.this.getStartingServerJobName()) + " timed out.", null));
                        rm.done();
                    }
                }
            }, (long)GnuMcuGdbServerBackend.this.getServerLaunchTimeoutSeconds(), TimeUnit.SECONDS);
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GdbServerStep.initialise() return");
            }
        }

        protected void shutdown(final RequestMonitor rm) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GdbServerStep.shutdown()");
            }
            if (GnuMcuGdbServerBackend.this.fServerBackendState == IMIBackend.State.TERMINATED) {
                rm.done();
                return;
            }
            new Job(GnuMcuGdbServerBackend.this.getTerminatingServerJobName()){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (Activator.getInstance().isDebugging()) {
                            System.out.println("GdbServerStep.shutdown() run()");
                        }
                        GnuMcuGdbServerBackend.this.getExecutor().submit((Runnable)new DsfRunnable(){

                            public void run() {
                                if (Activator.getInstance().isDebugging()) {
                                    System.out.println("GdbServerStep.shutdown() run() run()");
                                }
                                GnuMcuGdbServerBackend.this.destroy();
                                if (((GdbServerStep)(this).GdbServerStep.this).GnuMcuGdbServerBackend.this.fServerMonitorJob != null && ((GdbServerStep)(this).GdbServerStep.this).GnuMcuGdbServerBackend.this.fServerMonitorJob.fMonitorExited) {
                                    if (Activator.getInstance().isDebugging()) {
                                        System.out.println("GdbServerStep shutdown() run() run() State.TERMINATED");
                                    }
                                    ((GdbServerStep)(this).GdbServerStep.this).GnuMcuGdbServerBackend.this.fServerBackendState = IMIBackend.State.TERMINATED;
                                    if (Activator.getInstance().isDebugging()) {
                                        System.out.println("GdbServerStep.shutdown() run() dispatchEvent(ServerBackendStateChangedEvent, TERMINATED)");
                                    }
                                    GnuMcuGdbServerBackend.this.getSession().dispatchEvent((Object)new IGdbServerBackendService.ServerBackendStateChangedEvent(GnuMcuGdbServerBackend.this.getSession().getId(), GnuMcuGdbServerBackend.this.getId(), IMIBackend.State.TERMINATED), GnuMcuGdbServerBackend.this.getProperties());
                                }
                            }
                        }).get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {}
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("GdbServerStep.shutdown() run() before getting exitValue");
                    }
                    int attempts = 0;
                    while (attempts < 10) {
                        try {
                            ((GdbServerStep)GdbServerStep.this).GnuMcuGdbServerBackend.this.fGdbServerExitValue = ((GdbServerStep)GdbServerStep.this).GnuMcuGdbServerBackend.this.fServerProcess.exitValue();
                            if (Activator.getInstance().isDebugging()) {
                                System.out.println("GdbServerStep shutdown() run() return");
                            }
                            rm.done();
                            return Status.OK_STATUS;
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                            ++attempts;
                        }
                    }
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("GdbServerStep.shutdown() run() REQUEST_FAILED");
                    }
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.embedcdt.debug.gdbjtag.core", 10004, String.valueOf(GnuMcuGdbServerBackend.this.getTerminatingServerJobName()) + " failed.", null));
                    rm.done();
                    return Status.OK_STATUS;
                }
            }.schedule();
            if (Activator.getInstance().isDebugging()) {
                System.out.println("GdbServerStep.shutdown() return");
            }
        }
    }

    protected class PushBackProcess
    extends Process {
        private Process fProcess;
        private PushbackInputStream fInput;
        private PushbackInputStream fError;

        public PushBackProcess(Process process, StringBuffer outBuffer, StringBuffer errBuffer) {
            byte[] b;
            if (Activator.getInstance().isDebugging()) {
                System.out.println("PushBackProcess(" + process + ")");
            }
            this.fProcess = process;
            if (outBuffer != null && outBuffer.length() > 0) {
                this.fInput = new PushbackInputStream(this.fProcess.getInputStream(), outBuffer.length() + 1);
                b = outBuffer.toString().getBytes();
                try {
                    this.fInput.unread(b);
                }
                catch (IOException e) {
                    Activator.log((Throwable)e);
                }
            }
            if (errBuffer != null && errBuffer.length() > 0) {
                this.fError = new PushbackInputStream(this.fProcess.getErrorStream(), errBuffer.length() + 1);
                b = errBuffer.toString().getBytes();
                try {
                    this.fError.unread(b);
                }
                catch (IOException e) {
                    Activator.log((Throwable)e);
                }
            }
        }

        @Override
        public void destroy() {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("PushBackProcess.destroy()");
            }
            this.fProcess.destroy();
        }

        @Override
        public int exitValue() {
            int intExit = this.fProcess.exitValue();
            if (EclipseUtils.isMacOSX() || EclipseUtils.isLinux()) {
                byte byteExit = (byte)intExit;
                intExit = byteExit;
            }
            return intExit;
        }

        @Override
        public InputStream getErrorStream() {
            if (this.fError != null) {
                return this.fError;
            }
            return this.fProcess.getErrorStream();
        }

        @Override
        public InputStream getInputStream() {
            if (this.fInput != null) {
                return this.fInput;
            }
            return this.fProcess.getInputStream();
        }

        @Override
        public OutputStream getOutputStream() {
            return this.fProcess.getOutputStream();
        }

        @Override
        public int waitFor() throws InterruptedException {
            return this.fProcess.waitFor();
        }
    }

    protected class RegisterStep
    extends GDBControl.InitializationShutdownStep {
        RegisterStep(GDBControl.InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(RequestMonitor rm) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("register " + GnuMcuGdbServerBackend.this.getClass().getName());
            }
            GnuMcuGdbServerBackend.this.register(new String[]{IGdbServerBackendService.class.getName(), GnuMcuGdbServerBackend.this.getClass().getName()}, new Hashtable());
            GnuMcuGdbServerBackend.this.getSession().addServiceEventListener((Object)GnuMcuGdbServerBackend.this, null);
            GnuMcuGdbServerBackend.this.getSession().dispatchEvent((Object)new IGdbServerBackendService.ServerBackendStateChangedEvent(GnuMcuGdbServerBackend.this.getSession().getId(), GnuMcuGdbServerBackend.this.getId(), IMIBackend.State.STARTED), GnuMcuGdbServerBackend.this.getProperties());
            rm.done();
        }

        protected void shutdown(RequestMonitor rm) {
            GnuMcuGdbServerBackend.this.unregister();
            GnuMcuGdbServerBackend.this.getSession().removeServiceEventListener((Object)GnuMcuGdbServerBackend.this);
            rm.done();
        }
    }
}

