/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.dialogs.PatternElementSelectionDialog;
import org.eclipse.egf.pattern.ui.editors.providers.CommonListContentProvider;
import org.eclipse.egf.pattern.ui.editors.providers.PatternSelectionLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternSelectionDialog
extends PatternElementSelectionDialog {
    private Pattern currentPattern;
    private String currentPatternName = "";
    private TableViewer tableViewer;
    private Text text;
    private Text statusLine;

    public PatternSelectionDialog(Shell shell, Pattern parent) {
        super(shell);
        this.currentPattern = parent;
        if (parent != null) {
            this.currentPatternName = parent.getName();
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.checkPatternExist(this.currentPatternName);
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 380;
        container.setLayoutData((Object)gd);
        Label patternLabel = new Label(container, 0);
        patternLabel.setText(Messages.PatternSelectiondialog_pattern_label);
        this.text = new Text(container, 2048);
        gd = new GridData(768);
        gd.widthHint = 550;
        this.text.setLayoutData((Object)gd);
        this.text.setText(this.currentPatternName);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                List listAreaDisplay = PatternSelectionDialog.this.getListAreaDisplay(PatternSelectionDialog.this.text.getText());
                PatternSelectionDialog.this.tableViewer.setInput((Object)listAreaDisplay);
                PatternSelectionDialog.this.currentPatternName = PatternSelectionDialog.this.text.getText();
                PatternSelectionDialog.this.checkPatternExist(PatternSelectionDialog.this.text.getText());
                PatternSelectionDialog.this.getSelectDefault(listAreaDisplay);
            }
        });
        Label label = new Label(container, 0);
        label.setText(Messages.PatternSelectiondialog_dialogArea_label);
        this.createListArea(container);
        this.createStatusLine(container);
        return dialogArea;
    }

    private void createStatusLine(Composite container) {
        String statusContent = PatternHelper.getPlatformFcore((PatternElement)this.currentPattern).getName();
        this.statusLine = new Text(container, 2048);
        GridData gd = new GridData(768);
        this.statusLine.setText(statusContent);
        this.statusLine.setEditable(false);
        this.statusLine.setLayoutData((Object)gd);
    }

    private void createListArea(Composite container) {
        Table listTable = new Table(container, 2816);
        GridData gd = new GridData(1808);
        listTable.setLayoutData((Object)gd);
        TableColumn tableColumn = new TableColumn(listTable, 0);
        tableColumn.setWidth(500);
        this.tableViewer = new TableViewer(listTable);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PatternSelectionLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new CommonListContentProvider());
        List<Pattern> listAreaDisplay = this.getListAreaDisplay(this.currentPatternName);
        this.tableViewer.setInput(listAreaDisplay);
        this.getSelectDefault(listAreaDisplay);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof Pattern) {
                    PatternSelectionDialog.this.currentPattern = (Pattern)selection.getFirstElement();
                    PatternSelectionDialog.this.currentPatternName = PatternSelectionDialog.this.currentPattern.getName();
                    String statusContent = PatternHelper.getPlatformFcore((PatternElement)PatternSelectionDialog.this.currentPattern).getName();
                    PatternSelectionDialog.this.statusLine.setText(statusContent);
                }
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PatternSelectionDialog.this.okPressed();
            }
        });
    }

    private List<Pattern> getPatternsList() {
        return PatternHelper.TRANSACTIONNAL_COLLECTOR.getAllPatterns();
    }

    private List<Pattern> getListAreaDisplay(String name) {
        ArrayList<Pattern> patternsListNew = new ArrayList<Pattern>();
        for (Pattern patternEntry : this.getPatternsList()) {
            Pattern pattern;
            String content;
            if (!(patternEntry instanceof Pattern) || !PatternSelectionDialog.searchContainer(content = (pattern = patternEntry).getName(), name)) continue;
            patternsListNew.add(pattern);
        }
        return patternsListNew;
    }

    private void checkPatternExist(String name) {
        Status fLastStatusErr = new Status(4, "org.eclipse.jdt.core", -1, "", null);
        Status fLastStatusOk = new Status(0, "org.eclipse.jface", 0, "", null);
        if (this.getListAreaDisplay(name).size() > 0) {
            this.updateStatus((IStatus)fLastStatusOk);
            return;
        }
        this.updateStatus((IStatus)fLastStatusErr);
    }

    private void getSelectDefault(List<Pattern> model) {
        Object selectEntry = this.selectDefault(model, this.tableViewer);
        if (selectEntry instanceof Pattern) {
            this.currentPattern = (Pattern)selectEntry;
            this.currentPatternName = this.currentPattern.getName();
        }
    }

    public Pattern getCurrentPattern() {
        return this.currentPattern;
    }

    public String getCurrentPatternName() {
        return this.currentPatternName;
    }
}

