/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.java.extension;

import java.io.IOException;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.model.javapattern.provider.JavaPatternItemProviderAdapterFactory;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.engine.PatternEngine;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.extension.BasePatternInitializer;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.egf.pattern.extension.PatternFactory;
import org.eclipse.egf.pattern.extension.PatternInitializer;
import org.eclipse.egf.pattern.extension.RefactoringManager;
import org.eclipse.egf.pattern.java.engine.JavaEngine;
import org.eclipse.egf.pattern.java.engine.JavaNatureHelper;
import org.eclipse.egf.pattern.java.extension.JavaPatternFactory;
import org.eclipse.egf.pattern.java.extension.JavaPatternInitializer;
import org.eclipse.egf.pattern.utils.FileHelper;
import org.eclipse.emf.common.notify.AdapterFactory;

public class JavaPatternExtension
extends PatternExtension
implements RefactoringManager {
    private static final PatternNature NATURE = org.eclipse.egf.model.javapattern.JavaPatternFactory.eINSTANCE.createJavaNature();
    private final PatternFactory factory = new JavaPatternFactory();

    public PatternNature getNature() {
        return NATURE;
    }

    public PatternEngine doCreateRunner(Pattern pattern) throws PatternException {
        return new JavaEngine(pattern);
    }

    public PatternFactory getFactory() {
        return this.factory;
    }

    public String canTranslate(Pattern pattern) {
        String canTranslate = super.canTranslate(pattern);
        if (canTranslate == null) {
            try {
                JavaNatureHelper.getClassName(pattern);
            }
            catch (PatternException e) {
                return e.getMessage();
            }
        }
        return canTranslate;
    }

    protected PatternInitializer doCreateInitializer(IProject project, Pattern pattern) {
        return new JavaPatternInitializer(project, pattern);
    }

    protected AdapterFactory getAdapterFactory() {
        return new JavaPatternItemProviderAdapterFactory();
    }

    public RefactoringManager getRefactoringManager() {
        return this;
    }

    public void renamePattern(Pattern pattern, String oldName, String newName) throws PatternException {
        IProject project = PatternHelper.getProject((Pattern)pattern);
        BasePatternInitializer initializer = (BasePatternInitializer)this.doCreateInitializer(project, pattern);
        PatternMethod method = pattern.getHeaderMethod();
        IFile methodFile = initializer.getFile(method);
        try {
            String content = FileHelper.getFileContent((IFile)methodFile);
            String regex = "public[\\s]*class[\\s]*" + PatternHelper.dropNonWordCharacter((String)oldName) + "[\\s]*\\{";
            String replacement = "public class " + PatternHelper.dropNonWordCharacter((String)newName) + " {";
            String newContent = content.replaceAll(regex, replacement);
            if (newContent == null) {
                throw new PatternException(Messages.refactoring_error1);
            }
            regex = "public[\\s]*" + PatternHelper.dropNonWordCharacter((String)oldName) + "[\\s]*\\(\\)[\\s]*\\{";
            if ((newContent = newContent.replaceAll(regex, replacement = "public " + PatternHelper.dropNonWordCharacter((String)newName) + "() {")) == null) {
                throw new PatternException(Messages.refactoring_error1);
            }
            FileHelper.setContent((IFile)methodFile, (String)newContent);
        }
        catch (PatternSyntaxException e) {
            throw new PatternException((Throwable)e);
        }
        catch (CoreException e) {
            throw new PatternException((Throwable)e);
        }
        catch (IOException e) {
            throw new PatternException((Throwable)e);
        }
    }

    public void renameLibrary(PatternLibrary lib, String oldName, String newName) throws PatternException {
    }
}

