/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.extension;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.pattern.Activator;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.emf.ecore.EClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionHelper {
    public static Map<String, PatternExtension> getExtensions() {
        HashMap<String, PatternExtension> result = new HashMap<String, PatternExtension>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.egf.pattern.extension");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                PatternExtension pe = (PatternExtension)element.createExecutableExtension("class");
                result.put(ExtensionHelper.getName(pe.getNature()), pe);
            }
            catch (CoreException e) {
                Activator.getDefault().logError(e);
            }
            ++n2;
        }
        return result;
    }

    public static PatternNature createNature(String name) {
        PatternExtension patternExtension = ExtensionHelper.getExtensions().get(name);
        if (patternExtension == null) {
            throw new IllegalStateException();
        }
        EClass eClass = patternExtension.getNature().eClass();
        return (PatternNature)eClass.getEPackage().getEFactoryInstance().create(eClass);
    }

    public static PatternExtension getExtension(PatternNature nature) throws MissingExtensionException {
        Map<String, PatternExtension> extensions = ExtensionHelper.getExtensions();
        PatternExtension patternExtension = extensions.get(ExtensionHelper.getName(nature));
        if (patternExtension == null) {
            throw new MissingExtensionException(Messages.bind((String)Messages.extension_error1, (Object)ExtensionHelper.getName(nature)));
        }
        return patternExtension;
    }

    public static String getName(PatternNature nature) {
        return nature.eClass().getName();
    }

    public static class MissingExtensionException
    extends Exception {
        private static final long serialVersionUID = 8310777379305723688L;

        private MissingExtensionException(String message) {
            super(message);
        }
    }
}

