/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.resources.IProject;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.epackage.IProxyEObject;
import org.eclipse.egf.model.pattern.BackCall;
import org.eclipse.egf.model.pattern.Call;
import org.eclipse.egf.model.pattern.MethodCall;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternCall;
import org.eclipse.egf.model.pattern.PatternFactory;
import org.eclipse.egf.model.pattern.PatternInjectedCall;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.model.pattern.SuperCall;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.PatternUIHelper;
import org.eclipse.egf.pattern.ui.compare.CompareHelper;
import org.eclipse.egf.pattern.ui.compare.MethodCompareInput;
import org.eclipse.egf.pattern.ui.contributions.EditHelper;
import org.eclipse.egf.pattern.ui.editors.PatternTemplateEditor;
import org.eclipse.egf.pattern.ui.editors.adapter.LiveValidationContentAdapter;
import org.eclipse.egf.pattern.ui.editors.dialogs.MethodAddOrEditDialog;
import org.eclipse.egf.pattern.ui.editors.dialogs.VariablesEditDialog;
import org.eclipse.egf.pattern.ui.editors.editor.MethodsComboBoxViewerCellEditor;
import org.eclipse.egf.pattern.ui.editors.modifiers.MethodTableCellModifier;
import org.eclipse.egf.pattern.ui.editors.modifiers.VariablesTableCellModifier;
import org.eclipse.egf.pattern.ui.editors.pages.PatternEditorPage;
import org.eclipse.egf.pattern.ui.editors.providers.CommonListContentProvider;
import org.eclipse.egf.pattern.ui.editors.providers.MethodLabelProvider;
import org.eclipse.egf.pattern.ui.editors.providers.MethodsTableObservableListContentProvider;
import org.eclipse.egf.pattern.ui.editors.providers.OrchestrationTableLabelProvider;
import org.eclipse.egf.pattern.ui.editors.providers.ParametersTableLabelProvider;
import org.eclipse.egf.pattern.ui.editors.providers.TableObservableListContentProvider;
import org.eclipse.egf.pattern.ui.editors.wizards.OpenTypeWizard;
import org.eclipse.egf.pattern.ui.editors.wizards.OrchestrationWizard;
import org.eclipse.egf.pattern.ui.editors.wizards.pages.CallTypeEnum;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplementationPage
extends PatternEditorPage {
    public static final String ID = "org.eclipse.egf.pattern.ui.editors.pages.implementation.page.id";
    private TableViewer methodsTableViewer;
    private TableViewer variablesTableViewer;
    private TableViewer orchestrationTableViewer;
    public static final String NAME_COLUMN_ID = "Name";
    public static final String TYPE_COLUMN_ID = "Type";
    private Button methodsAdd;
    private Button methodsEdit;
    private Button methodsCompare;
    private Button methodsRemove;
    private Button methodsUp;
    private Button methodsDown;
    private Button methodsOpenTemplate;
    private Button orchestrationAdd;
    private Button orchestrationEdit;
    private Button orchestrationRemove;
    private Button orchestrationUp;
    private Button orchestrationDown;
    private Button variablesAdd;
    private Button variablesEdit;
    private Button variablesRemove;
    private MethodsComboBoxViewerCellEditor nameEditor;
    private PatternMethod dropEntry;
    private int methodsDragIndex = -1;
    private int orchestrationDragIndex = -1;
    private boolean isChangMethodsOrder;
    private boolean isChangOrchestrationeOrder;
    private static final String VARIABLE_NAME_DEFAULT_VALUE = "variable";
    private static final String VARIABLE_TYPE_DEFAULT_VALUE = "java.lang.String";
    private LiveValidationContentAdapter variableNameEmpetyValidationAdapter;
    private IMessageManager mmng;

    public ImplementationPage(FormEditor editor) {
        super(editor, ID, Messages.ImplementationPage_title);
    }

    @Override
    protected void doCreateFormContent(IManagedForm managedForm) {
        this.mmng = managedForm.getMessageManager();
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        toolkit.decorateFormHeading(form.getForm());
        GridLayout layout = new GridLayout(2, true);
        form.getBody().setLayout((Layout)layout);
        form.setImage(Activator.getDefault().getImage("obj16/plugin_mf_obj.gif"));
        form.setText(Messages.ImplementationPage_title);
        Composite containerLeft = this.createComposite(toolkit, form);
        this.createMethodsSection(toolkit, containerLeft);
        this.createVariablesSection(toolkit, containerLeft);
        Composite containerRight = this.createComposite(toolkit, form);
        this.createOrchestrationSection(toolkit, containerRight);
        form.reflow(true);
    }

    @Override
    protected void checkReadOnlyModel() {
        if (this.isReadOnly()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    private void setEnabled(boolean enabled) {
        if (!enabled) {
            this.methodsUp.setEnabled(false);
            this.methodsDown.setEnabled(false);
        } else {
            this.setMethodsButtonsStatus();
        }
        this.methodsAdd.setEnabled(enabled);
        this.methodsEdit.setEnabled(enabled);
        this.methodsRemove.setEnabled(enabled);
        this.orchestrationAdd.setEnabled(enabled);
        this.orchestrationEdit.setEnabled(enabled);
        this.orchestrationUp.setEnabled(enabled);
        this.orchestrationDown.setEnabled(enabled);
        this.variablesAdd.setEnabled(enabled);
        this.variablesEdit.setEnabled(enabled);
        this.variablesRemove.setEnabled(enabled);
    }

    private Composite createComposite(FormToolkit toolkit, ScrolledForm form) {
        Composite composite = toolkit.createComposite(form.getBody(), 0);
        GridLayout layout = new GridLayout(1, true);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1810);
        composite.setLayoutData((Object)gd);
        return composite;
    }

    private void createMethodsSection(FormToolkit toolkit, Composite composite) {
        Section methSection = toolkit.createSection(composite, 256);
        methSection.setText(Messages.ImplementationPage_Methods);
        GridData gd = new GridData(1810);
        methSection.setLayoutData((Object)gd);
        Composite methods = this.createMethodComposite(toolkit, methSection);
        this.createLabel(toolkit, methods, Messages.ImplementationPage_Methods_2, 1);
        this.createLabel(toolkit, methods, Messages.ImplementationPage_Methods_3, 2);
        this.createPatternMethodsArea(toolkit, methods);
        this.createImplementationMethodsTable(toolkit, methods);
        this.createImplementationMethodsButtons(toolkit, methods);
        methSection.setClient((Control)methods);
    }

    private Composite createMethodComposite(FormToolkit toolkit, Section section) {
        Composite container = toolkit.createComposite((Composite)section, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        return container;
    }

    private void createPatternMethodsArea(FormToolkit toolkit, Composite methods) {
        Composite patternMethodsArea = toolkit.createComposite(methods, 0);
        GridLayout layout = new GridLayout();
        patternMethodsArea.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.verticalIndent = 20;
        patternMethodsArea.setLayoutData((Object)gd);
        this.createPatternMethodsLink(toolkit, patternMethodsArea);
    }

    private void createPatternMethodsLink(FormToolkit toolkit, Composite container) {
        ImageHyperlink headerLink = this.createPatternMethodLink(toolkit, container, "header");
        headerLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                PatternMethod headerMethod = ImplementationPage.this.getPattern().getHeaderMethod();
                String headerMethodId = headerMethod.getID();
                ImplementationPage.this.openMethodTemplate(headerMethodId);
            }
        });
        ImageHyperlink initLink = this.createPatternMethodLink(toolkit, container, "init");
        initLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                PatternMethod initMethod = ImplementationPage.this.getPattern().getInitMethod();
                String initMethodId = initMethod.getID();
                ImplementationPage.this.openMethodTemplate(initMethodId);
            }
        });
        ImageHyperlink preConditionLink = this.createPatternMethodLink(toolkit, container, "preCondition");
        preConditionLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                final Pattern pattern = ImplementationPage.this.getPattern();
                if (pattern.getConditionMethod() == null) {
                    TransactionalEditingDomain editingDomain = ImplementationPage.this.getEditingDomain();
                    RecordingCommand cmd = new RecordingCommand(editingDomain){

                        protected void doExecute() {
                            try {
                                PatternExtension extension = ExtensionHelper.getExtension((PatternNature)pattern.getNature());
                                PatternMethod conditionMethod = PatternFactory.eINSTANCE.createPatternMethod();
                                conditionMethod.setName("preCondition");
                                pattern.getMethods().add((Object)conditionMethod);
                                pattern.setConditionMethod(conditionMethod);
                                conditionMethod.setPatternFilePath(extension.getFactory().createURI(conditionMethod));
                                IProject project = EMFHelper.getProject((Resource)pattern.eResource());
                                extension.createInitializer(project, pattern).updateSpecialMethods(false);
                            }
                            catch (Exception e2) {
                                Activator.getDefault().logError(e2);
                            }
                        }
                    };
                    editingDomain.getCommandStack().execute((Command)cmd);
                }
                if (pattern.getConditionMethod() != null) {
                    ImplementationPage.this.openMethodTemplate(pattern.getConditionMethod().getID());
                }
            }
        });
        ImageHyperlink footerLink = this.createPatternMethodLink(toolkit, container, "footer");
        footerLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                PatternMethod footerMethod = ImplementationPage.this.getPattern().getFooterMethod();
                String footerMethodId = footerMethod.getID();
                ImplementationPage.this.openMethodTemplate(footerMethodId);
            }
        });
    }

    private ImageHyperlink createPatternMethodLink(FormToolkit toolkit, Composite methods, String label) {
        ImageHyperlink patternMethodLink = toolkit.createImageHyperlink(methods, 0);
        patternMethodLink.setText(label);
        patternMethodLink.setImage(Activator.getDefault().getImage("obj16/method.gif"));
        GridData gd = new GridData();
        gd.verticalIndent = 0;
        patternMethodLink.setLayoutData((Object)gd);
        return patternMethodLink;
    }

    private void createLabel(FormToolkit toolkit, Composite container, String label, int horizontalSpan) {
        Label discrip = toolkit.createLabel(container, label, 64);
        GridData gd = new GridData(1808);
        gd = new GridData(768);
        gd.horizontalSpan = horizontalSpan;
        gd.horizontalIndent = 4;
        discrip.setLayoutData((Object)gd);
    }

    private void createImplementationMethodsTable(FormToolkit toolkit, Composite methods) {
        Composite tableComp = new Composite(methods, 0);
        TableColumnLayout layout = new TableColumnLayout();
        tableComp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        tableComp.setLayoutData((Object)gd);
        Table table = toolkit.createTable(tableComp, 2816);
        gd = new GridData(1808);
        gd.verticalIndent = 10;
        gd.horizontalIndent = 10;
        gd.widthHint = 100;
        table.setLayoutData((Object)gd);
        this.methodsTableViewer = new TableViewer(table);
        TableColumn tableColumn = new TableColumn(table, 0);
        layout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(200, true));
        this.methodsTableViewer.setContentProvider((IContentProvider)new MethodsTableObservableListContentProvider(this.methodsTableViewer, 3));
        this.methodsTableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !PatternUIHelper.isRenameDisable((PatternMethod)element);
            }
        });
        this.initMethodsTableEditor();
        this.methodsTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ImplementationPage.this.openPatternTemplate();
            }
        });
        this.methodsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ImplementationPage.this.isReadOnly()) {
                    return;
                }
                ImplementationPage.this.setMethodsButtonsStatus();
                CCombo control = (CCombo)ImplementationPage.this.nameEditor.getControl();
                if (control != null && !control.isDisposed()) {
                    PatternMethod selectItem = ImplementationPage.this.getmethodsSelectItem();
                    control.setText(selectItem == null ? "" : selectItem.getName());
                }
            }
        });
        this.addDragDropForMethodsTable();
    }

    private void addDragDropForMethodsTable() {
        this.methodsTableViewer.addDragSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                ImplementationPage.this.isChangOrchestrationeOrder = false;
                ImplementationPage.this.isChangMethodsOrder = true;
                if (ImplementationPage.this.methodsTableViewer.getSelection() == null) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (ImplementationPage.this.methodsTableViewer.getSelection() != null) {
                    ImplementationPage.this.dropEntry = ImplementationPage.this.getmethodsSelectItem();
                    ImplementationPage.this.methodsDragIndex = ImplementationPage.this.methodsTableViewer.getTable().getSelectionIndex();
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        this.methodsTableViewer.addDropSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.methodsTableViewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (ImplementationPage.this.isReadOnly()) {
                    return false;
                }
                return ImplementationPage.this.isChangMethodsOrder;
            }

            public boolean performDrop(Object data) {
                Object currentTarget = this.getCurrentTarget();
                EList methods = ImplementationPage.this.getPattern().getMethods();
                ImplementationPage.this.executeChangeOrder(currentTarget, ImplementationPage.this.methodsTableViewer, methods, ImplementationPage.this.methodsDragIndex);
                ImplementationPage.this.setMethodsButtonsStatus();
                return true;
            }
        });
    }

    private void initMethodsTableEditor() {
        this.methodsTableViewer.setColumnProperties(new String[]{NAME_COLUMN_ID});
        this.nameEditor = new MethodsComboBoxViewerCellEditor((Composite)this.methodsTableViewer.getTable(), this.getEditingDomain(), this.methodsTableViewer, this);
        this.nameEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.nameEditor.setContenProvider(new CommonListContentProvider());
        this.methodsTableViewer.setCellEditors(new CellEditor[]{this.nameEditor});
        this.methodsTableViewer.setCellModifier((ICellModifier)new MethodTableCellModifier(this.getEditingDomain(), this.methodsTableViewer){

            public boolean canModify(Object element, String property) {
                if (ImplementationPage.this.isReadOnly()) {
                    return false;
                }
                return super.canModify(element, property);
            }
        });
    }

    private void createImplementationMethodsButtons(FormToolkit toolkit, final Composite methods) {
        Composite buttons = toolkit.createComposite(methods, 0);
        GridLayout layout = new GridLayout();
        buttons.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.widthHint = 65;
        this.methodsAdd = toolkit.createButton(buttons, "", 8);
        this.methodsAdd.setLayoutData((Object)gd);
        this.methodsAdd.setImage(Activator.getDefault().getImage("obj16/add.gif"));
        this.methodsAdd.setToolTipText(Messages.ImplementationPage_button_add);
        this.methodsAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MethodAddOrEditDialog dialog = new MethodAddOrEditDialog(new Shell(), PatternUIHelper.getUseablePatternMethodsNameList(ImplementationPage.this.getPattern()), "");
                dialog.setTitle(Messages.ImplementationPage_methAdd_dialog_title);
                if (dialog.open() == 0) {
                    ImplementationPage.this.executeMethodsAdd(dialog.getName());
                    ImplementationPage.this.initNameEditorInput();
                    ImplementationPage.this.setMethodsButtonsStatus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.methodsEdit = toolkit.createButton(buttons, "", 8);
        this.methodsEdit.setLayoutData((Object)gd);
        this.methodsEdit.setEnabled(false);
        this.methodsEdit.setImage(Activator.getDefault().getImage("obj16/edit.gif"));
        this.methodsEdit.setToolTipText(Messages.ImplementationPage_button_edit);
        this.methodsEdit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object entry;
                int index = ImplementationPage.this.methodsTableViewer.getTable().getSelectionIndex();
                String selectName = "";
                if (index >= 0 && (entry = ImplementationPage.this.methodsTableViewer.getElementAt(index)) instanceof PatternMethod) {
                    selectName = ((PatternMethod)entry).getName();
                }
                Pattern parent = ImplementationPage.this.getPatternParent();
                MethodAddOrEditDialog dialog = new MethodAddOrEditDialog(new Shell(), PatternUIHelper.getUseablePatternMethodsNameList(parent), selectName);
                dialog.setTitle(Messages.ImplementationPage_methEdit_dialog_title);
                if (dialog.open() == 0) {
                    ImplementationPage.this.executeMethodsEdit(dialog.getName());
                    ImplementationPage.this.initNameEditorInput();
                    ImplementationPage.this.setMethodsButtonsStatus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.methodsOpenTemplate = toolkit.createButton(buttons, "", 8);
        this.methodsOpenTemplate.setLayoutData((Object)gd);
        this.methodsOpenTemplate.setImage(Activator.getDefault().getImage("obj16/method_content_edit.gif"));
        this.methodsOpenTemplate.setToolTipText(Messages.ImplementationPage_button_methodsOpenTemplate);
        this.methodsOpenTemplate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImplementationPage.this.openPatternTemplate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.methodsCompare = toolkit.createButton(buttons, "", 8);
        this.methodsCompare.setLayoutData((Object)gd);
        this.methodsCompare.setImage(Activator.getDefault().getImage("obj16/compare.gif"));
        this.methodsCompare.setToolTipText(Messages.ImplementationPage_button_methodsCompare);
        this.methodsCompare.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PatternMethod patternMethod;
                PatternMethod superMethod;
                ISelection selection = ImplementationPage.this.methodsTableViewer.getSelection();
                if (selection != null && !selection.isEmpty() && (superMethod = CompareHelper.getSuperMethod(patternMethod = (PatternMethod)((IStructuredSelection)selection).getFirstElement())) != null) {
                    CompareUI.openCompareEditor((CompareEditorInput)new MethodCompareInput(patternMethod, superMethod));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.methodsRemove = toolkit.createButton(buttons, "", 8);
        this.methodsRemove.setLayoutData((Object)gd);
        this.methodsRemove.setEnabled(false);
        this.methodsRemove.setImage(Activator.getDefault().getImage("obj16/delete.gif"));
        this.methodsRemove.setToolTipText(Messages.ImplementationPage_button_remove);
        this.methodsRemove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImplementationPage.this.executeMethodsRemove(methods);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.methodsUp = toolkit.createButton(buttons, "", 8);
        this.methodsUp.setLayoutData((Object)gd);
        this.methodsUp.setEnabled(false);
        this.methodsUp.setImage(Activator.getDefault().getImage("obj16/upward.gif"));
        this.methodsUp.setToolTipText(Messages.ImplementationPage_button_up);
        this.methodsUp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImplementationPage.this.executeMethodsUpOrDown(-1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.methodsDown = toolkit.createButton(buttons, "", 8);
        this.methodsDown.setLayoutData((Object)gd);
        this.methodsDown.setEnabled(false);
        this.methodsDown.setImage(Activator.getDefault().getImage("obj16/downward.gif"));
        this.methodsDown.setToolTipText(Messages.ImplementationPage_button_down);
        this.methodsDown.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImplementationPage.this.executeMethodsUpOrDown(1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void executeMethodsUpOrDown(int num) {
        final EList methods = this.getPattern().getMethods();
        int oldIndex = this.methodsTableViewer.getTable().getSelectionIndex();
        final int fromIndex = this.getIndexOfPatternMethodsMappingTable(oldIndex, (EList<PatternMethod>)methods);
        int newIndex = oldIndex + num;
        final int toIndex = this.getIndexOfPatternMethodsMappingTable(newIndex, (EList<PatternMethod>)methods);
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                methods.move(toIndex, fromIndex);
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
        this.methodsTableViewer.refresh();
        this.methodsTableViewer.getTable().setSelection(newIndex);
        this.setMethodsButtonsStatus();
    }

    private int getIndexOfPatternMethodsMappingTable(int indexOfTable, EList<PatternMethod> patternMethods) {
        PatternMethod item = this.getTableItem(indexOfTable);
        int index = patternMethods.indexOf((Object)item);
        if (index == -1) {
            System.out.println();
        }
        return index;
    }

    private PatternMethod getTableItem(int index) {
        Object selectItem = this.methodsTableViewer.getElementAt(index);
        if (selectItem instanceof PatternMethod) {
            return (PatternMethod)selectItem;
        }
        return null;
    }

    private void setMethodsButtonsStatus() {
        int selectIndex = this.methodsTableViewer.getTable().getSelectionIndex();
        int length = this.methodsTableViewer.getTable().getItemCount();
        if (selectIndex == -1) {
            this.methodsRemove.setEnabled(false);
            this.methodsEdit.setEnabled(false);
            this.methodsUp.setEnabled(false);
            this.methodsDown.setEnabled(false);
            this.methodsOpenTemplate.setEnabled(false);
            return;
        }
        PatternMethod selectMethod = (PatternMethod)this.methodsTableViewer.getElementAt(selectIndex);
        if (PatternUIHelper.isRenameDisable(selectMethod)) {
            this.methodsEdit.setEnabled(false);
            this.methodsRemove.setEnabled(false);
        } else {
            this.methodsEdit.setEnabled(true);
            this.methodsRemove.setEnabled(true);
        }
        if (selectIndex <= 0) {
            this.methodsUp.setEnabled(false);
        } else {
            this.methodsUp.setEnabled(true);
        }
        if (selectIndex + 1 == length) {
            this.methodsDown.setEnabled(false);
        } else {
            this.methodsDown.setEnabled(true);
        }
        this.methodsOpenTemplate.setEnabled(true);
    }

    private void executeMethodsRemove(Composite methods) {
        Object selectItem;
        int index = this.methodsTableViewer.getTable().getSelectionIndex();
        if (index >= 0 && (selectItem = this.methodsTableViewer.getElementAt(index)) instanceof PatternMethod) {
            if (this.isMethodDeleteDisable((PatternMethod)selectItem)) {
                String message = Messages.ImplementationPage_method_cannot_delete_message;
                this.showErrorMessage(methods, message);
                return;
            }
            final Pattern pattern = this.getPattern();
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            RecordingCommand cmd = new RecordingCommand(editingDomain){

                protected void doExecute() {
                    pattern.getMethods().remove(selectItem);
                }
            };
            editingDomain.getCommandStack().execute((Command)cmd);
            EList allMethods = pattern.getMethods();
            this.setDefaultSelection(allMethods.size() - 3, this.methodsTableViewer, index);
        }
        this.setMethodsButtonsStatus();
    }

    private void executeMethodsAdd(String name) {
        PatternMethod method = PatternFactory.eINSTANCE.createPatternMethod();
        method.setName(name);
        Command command = CreateChildCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getPattern(), (Object)new CommandParameter(null, (Object)PatternPackage.Literals.PATTERN__METHODS, (Object)method), Collections.singletonList(this.getPattern()));
        if (command.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(command);
            PatternUIHelper.addAdapterForNewItem(this.methodsTableViewer, method);
            this.methodsTableViewer.refresh();
            this.methodsTableViewer.getTable().setSelection(this.methodsTableViewer.getTable().getItemCount() - 1);
        }
    }

    protected void executeMethodsEdit(final String name) {
        int index = this.methodsTableViewer.getTable().getSelectionIndex();
        final PatternMethod editPatternMethod = (PatternMethod)this.methodsTableViewer.getElementAt(index);
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                editPatternMethod.setName(name);
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
    }

    private void openPatternTemplate() {
        ISelection selection = this.methodsTableViewer.getSelection();
        String methodId = null;
        if (selection != null && !selection.isEmpty()) {
            PatternMethod method = (PatternMethod)((IStructuredSelection)selection).getFirstElement();
            methodId = method.getID();
        }
        this.openMethodTemplate(methodId);
    }

    private void openMethodTemplate(String methodId) {
        Pattern pattern;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        PatternTemplateEditor editorPart = EditHelper.openTemplateBasicEditor(activePage, pattern = this.getPattern());
        if (editorPart != null) {
            editorPart.setActiveEditor(methodId);
        }
    }

    private void createOrchestrationSection(FormToolkit toolkit, Composite composite) {
        Section orchSection = toolkit.createSection(composite, 256);
        orchSection.setText(Messages.ImplementationPage_orchSection_title);
        GridData gd = new GridData(1810);
        orchSection.setLayoutData((Object)gd);
        String label = Messages.ImplementationPage_orchSection_label;
        Composite orchestration = this.createComposite(toolkit, orchSection, label);
        this.createOrchestrationTable(toolkit, orchestration);
        this.createOrchestrationButtons(toolkit, orchestration);
        orchSection.setClient((Control)orchestration);
    }

    private void createOrchestrationTable(FormToolkit toolkit, Composite orchestration) {
        Composite tableComp = new Composite(orchestration, 0);
        TableColumnLayout layout = new TableColumnLayout();
        tableComp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        tableComp.setLayoutData((Object)gd);
        Table table = toolkit.createTable(tableComp, 2816);
        gd = new GridData(1808);
        gd.verticalIndent = 10;
        gd.horizontalIndent = 10;
        gd.widthHint = 100;
        table.setLayoutData((Object)gd);
        this.orchestrationTableViewer = new TableViewer(table);
        TableColumn tableColumn = new TableColumn(table, 0);
        layout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(230, true));
        this.orchestrationTableViewer.setContentProvider((IContentProvider)new TableObservableListContentProvider(this.orchestrationTableViewer));
        this.orchestrationTableViewer.setLabelProvider((IBaseLabelProvider)new OrchestrationTableLabelProvider());
        this.orchestrationTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ImplementationPage.this.isReadOnly()) {
                    return;
                }
                ImplementationPage.this.setOrchestrationButtonsStatus();
            }
        });
        this.orchestrationTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ImplementationPage.this.isReadOnly()) {
                    return;
                }
                ImplementationPage.this.openOrchestrationWizard();
            }
        });
        this.addDragDropForOrchestrationTable();
    }

    private void addDragDropForOrchestrationTable() {
        if (this.isReadOnly()) {
            return;
        }
        this.orchestrationTableViewer.addDragSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                ImplementationPage.this.isChangOrchestrationeOrder = true;
                ImplementationPage.this.isChangMethodsOrder = false;
                if (ImplementationPage.this.orchestrationTableViewer.getSelection() == null) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (ImplementationPage.this.orchestrationTableViewer.getSelection() != null) {
                    ImplementationPage.this.orchestrationDragIndex = ImplementationPage.this.orchestrationTableViewer.getTable().getSelectionIndex();
                }
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        this.orchestrationTableViewer.addDropSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.orchestrationTableViewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (!ImplementationPage.this.isChangOrchestrationeOrder) {
                    return ImplementationPage.this.checkDropSupport();
                }
                return true;
            }

            public boolean performDrop(Object data) {
                if (ImplementationPage.this.isChangOrchestrationeOrder) {
                    Object currentTarget = this.getCurrentTarget();
                    EList orchestration = ImplementationPage.this.getPattern().getOrchestration();
                    ImplementationPage.this.executeChangeOrder(currentTarget, ImplementationPage.this.orchestrationTableViewer, orchestration, ImplementationPage.this.orchestrationDragIndex);
                    ImplementationPage.this.setOrchestrationButtonsStatus();
                } else {
                    ImplementationPage.this.executeDrop();
                }
                return false;
            }
        });
    }

    protected void executeChangeOrder(Object currentTarget, TableViewer viewer, EList<?> list, int sourceIndex) {
        int targetIndex = 0;
        if (currentTarget == null) {
            targetIndex = viewer.getTable().getItemCount() - 1;
        } else {
            TableItem[] items;
            TableItem[] tableItemArray = items = viewer.getTable().getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (currentTarget.equals(item.getData())) {
                    targetIndex = viewer.getTable().indexOf(item);
                    break;
                }
                ++n2;
            }
        }
        Object item = list.get(0);
        if (item != null && item instanceof PatternMethod) {
            int fromIndex = this.getIndexOfPatternMethodsMappingTable(sourceIndex, list);
            int toIndex = this.getIndexOfPatternMethodsMappingTable(targetIndex, list);
            this.refreshTableContent(list, toIndex, fromIndex);
        } else {
            this.refreshTableContent(list, targetIndex, sourceIndex);
        }
        viewer.refresh();
        viewer.getTable().setSelection(targetIndex);
    }

    private void refreshTableContent(final EList<?> list, final int targetIndex, final int sourceIndex) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                list.move(targetIndex, sourceIndex);
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
    }

    protected boolean checkDropSupport() {
        int index = this.methodsTableViewer.getTable().getSelectionIndex();
        PatternMethod drag = (PatternMethod)this.methodsTableViewer.getElementAt(index);
        String name = drag.getName();
        return !org.eclipse.egf.pattern.extension.PatternFactory.isSpecialMethod((String)name);
    }

    protected void executeDrop() {
        if (this.dropEntry != null) {
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            RecordingCommand cmd = new RecordingCommand(editingDomain){

                protected void doExecute() {
                    MethodCall methodCallNew = PatternFactory.eINSTANCE.createMethodCall();
                    methodCallNew.setCalled(ImplementationPage.this.dropEntry);
                    methodCallNew.setPattern(ImplementationPage.this.getPattern());
                    ImplementationPage.this.getPattern().getOrchestration().add((Object)methodCallNew);
                    PatternUIHelper.addAdapterForNewItem(ImplementationPage.this.orchestrationTableViewer, methodCallNew);
                }
            };
            editingDomain.getCommandStack().execute((Command)cmd);
            this.setOrchestrationButtonsStatus();
        }
    }

    private void createOrchestrationButtons(FormToolkit toolkit, Composite orchestration) {
        Composite buttons = toolkit.createComposite(orchestration, 0);
        GridLayout layout = new GridLayout();
        buttons.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.widthHint = 65;
        this.orchestrationAdd = toolkit.createButton(buttons, "", 8);
        this.orchestrationAdd.setLayoutData((Object)gd);
        this.orchestrationAdd.setImage(Activator.getDefault().getImage("obj16/add.gif"));
        this.orchestrationAdd.setToolTipText(Messages.ImplementationPage_button_add);
        this.orchestrationAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OrchestrationWizard wizard = new OrchestrationWizard(ImplementationPage.this.getPattern(), CallTypeEnum.ADD, null, ImplementationPage.this.getEditingDomain());
                wizard.init(PlatformUI.getWorkbench(), null);
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                int returnValue = dialog.open();
                if (returnValue == 0) {
                    ImplementationPage.this.exectuteOrchestrationAdd(wizard);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.orchestrationEdit = toolkit.createButton(buttons, "", 8);
        this.orchestrationEdit.setLayoutData((Object)gd);
        this.orchestrationEdit.setEnabled(false);
        this.orchestrationEdit.setImage(Activator.getDefault().getImage("obj16/edit.gif"));
        this.orchestrationEdit.setToolTipText(Messages.ImplementationPage_button_edit);
        this.orchestrationEdit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImplementationPage.this.openOrchestrationWizard();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.orchestrationRemove = toolkit.createButton(buttons, "", 8);
        this.orchestrationRemove.setLayoutData((Object)gd);
        this.orchestrationRemove.setEnabled(false);
        this.orchestrationRemove.setImage(Activator.getDefault().getImage("obj16/delete.gif"));
        this.orchestrationRemove.setToolTipText(Messages.ImplementationPage_button_remove);
        this.orchestrationRemove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImplementationPage.this.exectueOrchestrationRemove();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.orchestrationUp = toolkit.createButton(buttons, "", 8);
        this.orchestrationUp.setLayoutData((Object)gd);
        this.orchestrationUp.setEnabled(false);
        this.orchestrationUp.setImage(Activator.getDefault().getImage("obj16/upward.gif"));
        this.orchestrationUp.setToolTipText(Messages.ImplementationPage_button_up);
        this.orchestrationUp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImplementationPage.this.executeOrchestrationUpOrDown(-1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.orchestrationDown = toolkit.createButton(buttons, "", 8);
        this.orchestrationDown.setLayoutData((Object)gd);
        this.orchestrationDown.setEnabled(false);
        this.orchestrationDown.setImage(Activator.getDefault().getImage("obj16/downward.gif"));
        this.orchestrationDown.setToolTipText(Messages.ImplementationPage_button_down);
        this.orchestrationDown.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImplementationPage.this.executeOrchestrationUpOrDown(1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void openOrchestrationWizard() {
        int index = this.orchestrationTableViewer.getTable().getSelectionIndex();
        Object selectItem = this.orchestrationTableViewer.getElementAt(index);
        CallTypeEnum kind = CallTypeEnum.ADD;
        if (selectItem instanceof MethodCall) {
            kind = CallTypeEnum.METHOD_CALL;
        } else if (selectItem instanceof PatternCall) {
            kind = CallTypeEnum.PATTERN_CALL;
        } else if (selectItem instanceof PatternInjectedCall) {
            kind = CallTypeEnum.PATTERNINJECTED_CALL;
        } else {
            if (selectItem instanceof SuperCall) {
                kind = CallTypeEnum.SUPERPATTERN_CALL;
                return;
            }
            if (selectItem instanceof BackCall) {
                kind = CallTypeEnum.BACK_CALL;
                return;
            }
        }
        OrchestrationWizard wizard = new OrchestrationWizard(this.getPattern(), kind, selectItem, this.getEditingDomain());
        wizard.init(PlatformUI.getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        int returnValue = dialog.open();
        if (returnValue == 0) {
            Call selectCall = wizard.getSelectCall();
            this.exectuteOrchestrationEdit(selectCall, selectItem);
        }
    }

    protected void exectuteOrchestrationAdd(OrchestrationWizard wizard) {
        List<Object> selectCallList = new ArrayList<Call>();
        if (wizard.getDefaultKind() == CallTypeEnum.ADD && wizard.getSelectCall() instanceof MethodCall) {
            selectCallList = wizard.getSelectMethodCallList();
        } else {
            Call call = wizard.getSelectCall();
            selectCallList.add(call);
        }
        for (Object object : selectCallList) {
            this.exectuteOrchestrationAddCall((Call)object);
        }
        int n = this.getPattern().getOrchestration().size();
        this.orchestrationTableViewer.getTable().setSelection(n - 1);
        this.setOrchestrationButtonsStatus();
    }

    private void exectuteOrchestrationAddCall(final Call selectCall) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                selectCall.setPattern(ImplementationPage.this.getPattern());
                ImplementationPage.this.getPattern().getOrchestration().add((Object)selectCall);
                PatternUIHelper.addAdapterForNewItem(ImplementationPage.this.orchestrationTableViewer, selectCall);
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
    }

    protected void exectuteOrchestrationEdit(final Call selectCall, final Object selectItem) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                if (selectItem instanceof Call) {
                    int modifyIndex = ImplementationPage.this.getPattern().getOrchestration().indexOf(selectItem);
                    if (modifyIndex >= 0) {
                        ImplementationPage.this.getPattern().getOrchestration().set(modifyIndex, (Object)selectCall);
                        ImplementationPage.this.orchestrationTableViewer.getTable().setSelection(modifyIndex);
                    }
                    ImplementationPage.this.setOrchestrationButtonsStatus();
                }
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
    }

    protected void executeOrchestrationUpOrDown(int num) {
        final int oldIndex = this.orchestrationTableViewer.getTable().getSelectionIndex();
        final int newIndex = oldIndex + num;
        final EList orchestration = this.getPattern().getOrchestration();
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                orchestration.move(newIndex, oldIndex);
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
        this.orchestrationTableViewer.getTable().setSelection(newIndex);
        this.setOrchestrationButtonsStatus();
    }

    protected void exectueOrchestrationRemove() {
        int index = this.orchestrationTableViewer.getTable().getSelectionIndex();
        if (index >= 0) {
            final Object selectItem = this.orchestrationTableViewer.getElementAt(index);
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            RecordingCommand cmd = new RecordingCommand(editingDomain){

                protected void doExecute() {
                    if (selectItem instanceof Call) {
                        ImplementationPage.this.getPattern().getOrchestration().remove(selectItem);
                    }
                }
            };
            editingDomain.getCommandStack().execute((Command)cmd);
            EList orchestration = this.getPattern().getOrchestration();
            this.setDefaultSelection(orchestration.size(), this.orchestrationTableViewer, index);
        }
        this.setOrchestrationButtonsStatus();
    }

    private void setOrchestrationButtonsStatus() {
        int selectIndex = this.orchestrationTableViewer.getTable().getSelectionIndex();
        if (selectIndex == -1) {
            this.orchestrationRemove.setEnabled(false);
            this.orchestrationEdit.setEnabled(false);
            this.orchestrationUp.setEnabled(false);
            this.orchestrationDown.setEnabled(false);
            return;
        }
        int length = this.orchestrationTableViewer.getTable().getItemCount();
        if (length > 0) {
            this.orchestrationRemove.setEnabled(true);
            this.orchestrationEdit.setEnabled(true);
        } else {
            this.orchestrationRemove.setEnabled(false);
            this.orchestrationEdit.setEnabled(false);
        }
        if (selectIndex <= 0) {
            this.orchestrationUp.setEnabled(false);
        } else {
            this.orchestrationUp.setEnabled(true);
        }
        if (selectIndex + 1 == length) {
            this.orchestrationDown.setEnabled(false);
        } else {
            this.orchestrationDown.setEnabled(true);
        }
        Object selectItem = this.orchestrationTableViewer.getElementAt(selectIndex);
        if (selectItem instanceof BackCall) {
            this.orchestrationEdit.setEnabled(false);
        }
    }

    private void createVariablesSection(FormToolkit toolkit, Composite composite) {
        Section varSection = toolkit.createSection(composite, 256);
        varSection.setText(Messages.ImplementationPage_varSection_title);
        GridData gd = new GridData(1810);
        varSection.setLayoutData((Object)gd);
        String label = Messages.ImplementationPage_varSection_label;
        Composite variables = this.createComposite(toolkit, varSection, label);
        this.createVariablesTable(toolkit, variables);
        this.createVariablesButtons(toolkit, variables);
        varSection.setClient((Control)variables);
    }

    private void createVariablesTable(FormToolkit toolkit, Composite variables) {
        Composite tableComp = new Composite(variables, 0);
        TableColumnLayout layout = new TableColumnLayout();
        tableComp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        tableComp.setLayoutData((Object)gd);
        Table table = toolkit.createTable(tableComp, 68352);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gd = new GridData(1808);
        gd.verticalIndent = 10;
        gd.horizontalIndent = 10;
        gd.widthHint = 100;
        table.setLayoutData((Object)gd);
        this.variablesTableViewer = new TableViewer(table);
        String[] colNames = new String[]{Messages.ImplementationPage_column_title_name, Messages.ImplementationPage_column_title_type};
        int[] colWidths = new int[]{130, 135};
        this.variablesTableViewer.setContentProvider((IContentProvider)new TableObservableListContentProvider(this.variablesTableViewer));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.variablesTableViewer, (int)2);
        ParametersTableLabelProvider cellLabelProvider = new ParametersTableLabelProvider();
        int i = 0;
        while (i < colNames.length) {
            TableViewerColumn column = new TableViewerColumn(this.variablesTableViewer, 0);
            column.setLabelProvider((CellLabelProvider)cellLabelProvider);
            column.getColumn().setWidth(colWidths[i]);
            column.getColumn().setText(colNames[i]);
            layout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(colWidths[i], true));
            ++i;
        }
        this.initVariablesTableEditor();
    }

    private void initVariablesTableEditor() {
        if (this.isReadOnly()) {
            return;
        }
        this.variablesTableViewer.setColumnProperties(new String[]{NAME_COLUMN_ID, TYPE_COLUMN_ID});
        TextCellEditor textCellEditor = new TextCellEditor((Composite)this.variablesTableViewer.getTable());
        DialogCellEditor dialogCellEditor = new DialogCellEditor((Composite)this.variablesTableViewer.getTable()){

            protected Object openDialogBox(Control cellEditorWindow) {
                OpenTypeWizard wizard = new OpenTypeWizard(ImplementationPage.this.getSelectItemType(), (EObject)ImplementationPage.this.getPattern());
                wizard.init(PlatformUI.getWorkbench(), null);
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    Object object = wizard.getSelectType();
                    if (object instanceof IProxyEObject) {
                        ImplementationPage.this.updateType(((IProxyEObject)object).getURI().toString());
                    } else if (object instanceof IType) {
                        ImplementationPage.this.updateType(((IType)object).getFullyQualifiedName());
                    }
                }
                return null;
            }
        };
        this.variablesTableViewer.setCellEditors(new CellEditor[]{textCellEditor, dialogCellEditor});
        this.variablesTableViewer.setCellModifier((ICellModifier)new VariablesTableCellModifier(this.getEditingDomain(), this.variablesTableViewer));
        this.variablesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImplementationPage.this.setVariablesButtonsStatus();
            }
        });
    }

    protected void updateType(final String selectType) {
        ISelection selection;
        Object selectItem;
        if (selectType != null && !"".equals(selectType) && (selectItem = ((IStructuredSelection)(selection = this.variablesTableViewer.getSelection())).getFirstElement()) instanceof PatternVariable) {
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            RecordingCommand cmd = new RecordingCommand(editingDomain){

                protected void doExecute() {
                    ((PatternVariable)selectItem).setType(selectType);
                }
            };
            editingDomain.getCommandStack().execute((Command)cmd);
            this.variablesTableViewer.refresh();
        }
    }

    protected String getSelectItemType() {
        int selectionIndex = this.variablesTableViewer.getTable().getSelectionIndex();
        Object selectItem = this.variablesTableViewer.getElementAt(selectionIndex);
        if (selectItem instanceof PatternVariable) {
            return ((PatternVariable)selectItem).getType();
        }
        return "";
    }

    protected PatternMethod getmethodsSelectItem() {
        int selectionIndex = this.methodsTableViewer.getTable().getSelectionIndex();
        Object selectItem = this.methodsTableViewer.getElementAt(selectionIndex);
        if (selectItem instanceof PatternMethod) {
            return (PatternMethod)selectItem;
        }
        return null;
    }

    private void createVariablesButtons(FormToolkit toolkit, final Composite variables) {
        Composite buttons = toolkit.createComposite(variables, 0);
        GridLayout layout = new GridLayout();
        buttons.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.widthHint = 65;
        this.variablesAdd = toolkit.createButton(buttons, "", 8);
        this.variablesAdd.setLayoutData((Object)gd);
        this.variablesAdd.setImage(Activator.getDefault().getImage("obj16/add.gif"));
        this.variablesAdd.setToolTipText(Messages.ImplementationPage_button_add);
        this.variablesAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImplementationPage.this.executeVariablesAdd();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.variablesEdit = toolkit.createButton(buttons, "", 8);
        this.variablesEdit.setLayoutData((Object)gd);
        this.variablesEdit.setEnabled(false);
        this.variablesEdit.setImage(Activator.getDefault().getImage("obj16/edit.gif"));
        this.variablesEdit.setToolTipText(Messages.ImplementationPage_button_edit);
        this.variablesEdit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = ImplementationPage.this.variablesTableViewer.getSelection();
                final Object selectItem = ((IStructuredSelection)selection).getFirstElement();
                final VariablesEditDialog dialog = new VariablesEditDialog(ImplementationPage.this.getSite().getShell(), selectItem);
                dialog.setTitle(Messages.ImplementationPage_variablesEditDialog_title);
                if (dialog.open() == 0) {
                    TransactionalEditingDomain editingDomain = ImplementationPage.this.getEditingDomain();
                    RecordingCommand cmd = new RecordingCommand(editingDomain){

                        protected void doExecute() {
                            ImplementationPage.this.executeVariableEdit(dialog, selectItem);
                        }
                    };
                    editingDomain.getCommandStack().execute((Command)cmd);
                    ImplementationPage.this.variablesTableViewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.variablesRemove = toolkit.createButton(buttons, "", 8);
        this.variablesRemove.setLayoutData((Object)gd);
        this.variablesRemove.setEnabled(false);
        this.variablesRemove.setImage(Activator.getDefault().getImage("obj16/delete.gif"));
        this.variablesRemove.setToolTipText(Messages.ImplementationPage_button_remove);
        this.variablesRemove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImplementationPage.this.executeVariablesRemove(variables);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void setVariablesButtonsStatus() {
        int selectIndex = this.variablesTableViewer.getTable().getSelectionIndex();
        if (selectIndex == -1) {
            this.variablesRemove.setEnabled(false);
            this.variablesEdit.setEnabled(false);
            return;
        }
        int length = this.variablesTableViewer.getTable().getItemCount();
        if (length > 0) {
            this.variablesRemove.setEnabled(true);
            this.variablesEdit.setEnabled(true);
        } else {
            this.variablesRemove.setEnabled(false);
            this.variablesEdit.setEnabled(false);
        }
    }

    protected void executeVariablesAdd() {
        final Pattern pattern = this.getPattern();
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain){

            protected void doExecute() {
                PatternVariable patternVariableNew = PatternFactory.eINSTANCE.createPatternVariable();
                patternVariableNew.setName(ImplementationPage.VARIABLE_NAME_DEFAULT_VALUE);
                patternVariableNew.setType(ImplementationPage.VARIABLE_TYPE_DEFAULT_VALUE);
                pattern.getVariables().add((Object)patternVariableNew);
                PatternUIHelper.addAdapterForNewItem(ImplementationPage.this.variablesTableViewer, patternVariableNew);
            }
        };
        editingDomain.getCommandStack().execute((Command)cmd);
        EList allVariables = pattern.getAllVariables();
        int len = allVariables.size();
        this.variablesTableViewer.getTable().setSelection(len - 1);
        this.setVariablesButtonsStatus();
    }

    private void executeVariableEdit(VariablesEditDialog dialog, Object selectItem) {
        String newName = dialog.getName();
        String newType = dialog.getType();
        if (selectItem instanceof PatternVariable) {
            PatternVariable item = (PatternVariable)selectItem;
            item.setName(newName);
            item.setType(newType);
        }
    }

    protected void executeVariablesRemove(Composite variables) {
        ISelection selection;
        Object removeit;
        int index = this.variablesTableViewer.getTable().getSelectionIndex();
        if (index >= 0 && (removeit = ((IStructuredSelection)(selection = this.variablesTableViewer.getSelection())).getFirstElement()) instanceof PatternVariable) {
            if (this.isVariableDeleteDisable((PatternVariable)removeit)) {
                String message = Messages.ImplementationPage_variable_cannot_delete_message;
                this.showErrorMessage(variables, message);
                return;
            }
            final Pattern pattern = this.getPattern();
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            RecordingCommand cmd = new RecordingCommand(editingDomain){

                protected void doExecute() {
                    pattern.getVariables().remove(removeit);
                }
            };
            editingDomain.getCommandStack().execute((Command)cmd);
            EList allParameters = pattern.getAllVariables();
            this.setDefaultSelection(allParameters.size(), this.variablesTableViewer, index);
        }
        this.setVariablesButtonsStatus();
    }

    private Composite createComposite(FormToolkit toolkit, Section section, String label) {
        Composite container = toolkit.createComposite((Composite)section, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        Label discrip = toolkit.createLabel(container, label, 64);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 4;
        discrip.setLayoutData((Object)gd);
        return container;
    }

    private void setDefaultSelection(int len, TableViewer tableViewer, int index) {
        if (index < len) {
            tableViewer.getTable().setSelection(index);
        } else if (index >= len) {
            tableViewer.getTable().setSelection(index - 1);
        }
    }

    private void showErrorMessage(Composite composite, String message) {
        MessageDialog.openError((Shell)composite.getShell(), (String)Messages.ImplementationPage_Error, (String)message);
    }

    private boolean isMethodDeleteDisable(PatternMethod deleteItem) {
        Pattern pattern = this.getPattern();
        if (pattern != null) {
            EList orchestration = pattern.getOrchestration();
            for (Call call : orchestration) {
                PatternMethod currentCalled;
                if (!(call instanceof MethodCall) || !deleteItem.equals(currentCalled = ((MethodCall)call).getCalled())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isVariableDeleteDisable(PatternVariable deleteItem) {
        Pattern pattern = this.getPattern();
        if (pattern != null) {
            EList orchestration = pattern.getOrchestration();
            for (Call call : orchestration) {
                if (!(call instanceof PatternInjectedCall) || !deleteItem.equals(((PatternInjectedCall)call).getContext())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void bind() {
        this.addBinding(null);
        Pattern pattern = this.getPattern();
        if (pattern != null) {
            this.bindMethodsTable(pattern);
            this.bindOrchestrationTable(pattern);
            this.bindVariablesTableViewer(pattern);
            this.variableNameEmpetyValidationAdapter = PatternUIHelper.addValidationAdapter(this.mmng, this.getPattern(), "org.eclipse.egf.pattern.ui.PatternVariableNameNotEmpty", (Control)this.variablesTableViewer.getTable());
        }
        this.checkReadOnlyModel();
    }

    void bindMethodsTable(Pattern pattern) {
        this.initNameEditorInput();
        if (this.methodsTableViewer != null) {
            this.methodsTableViewer.setInput(null);
            this.methodsTableViewer.setLabelProvider((IBaseLabelProvider)new MethodLabelProvider(PatternUIHelper.getPatternParentMethodsNameList(this.getPattern())));
            IEMFListProperty input = EMFProperties.list((EStructuralFeature)PatternPackage.Literals.PATTERN__METHODS);
            IObservableList observe = input.observe((Object)pattern);
            this.methodsTableViewer.setInput((Object)observe);
        }
    }

    protected void initNameEditorInput() {
        if (this.nameEditor != null) {
            this.nameEditor.setInput(PatternUIHelper.getUseablePatternMethodsNameList(this.getPattern()));
        }
    }

    void bindOrchestrationTable(Pattern pattern) {
        if (this.orchestrationTableViewer != null) {
            IEMFListProperty modelProperty = EMFProperties.list((EStructuralFeature)PatternPackage.Literals.PATTERN__ORCHESTRATION);
            IObservableList observe = modelProperty.observe((Object)pattern);
            this.orchestrationTableViewer.setInput((Object)observe);
        }
    }

    void bindVariablesTableViewer(Pattern pattern) {
        if (this.variablesTableViewer != null) {
            IEMFListProperty input = EMFProperties.list((EStructuralFeature)PatternPackage.Literals.PATTERN__VARIABLES);
            IObservableList observe = input.observe((Object)pattern);
            this.variablesTableViewer.setInput((Object)observe);
        }
    }

    public Button getEditButton() {
        return this.methodsEdit;
    }

    private Pattern getPatternParent() {
        Pattern pattern = this.getPattern();
        return pattern == null ? null : pattern.getSuperPattern();
    }

    public void dispose() {
        PatternUIHelper.removeAdapterForPattern(this.getPattern(), (AdapterImpl)this.variableNameEmpetyValidationAdapter);
        super.dispose();
    }
}

