/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.modifiers;

import org.eclipse.egf.pattern.ui.editors.models.QueryContent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

public class QueryContentTableCellModifier
implements ICellModifier {
    private TableViewer tableViewer;

    public QueryContentTableCellModifier(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
    }

    public boolean canModify(Object element, String property) {
        if ("key".equals(property)) {
            return true;
        }
        return "value".equals(property);
    }

    public Object getValue(Object element, String property) {
        if (element instanceof QueryContent) {
            QueryContent content = (QueryContent)element;
            if ("key".equals(property)) {
                return content.getKey();
            }
            if ("value".equals(property)) {
                return content.getValue();
            }
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        if (value == null) {
            return;
        }
        if (element instanceof TableItem) {
            element = ((TableItem)element).getData();
        }
        String text = value.toString().trim();
        if (element instanceof QueryContent) {
            QueryContent content = (QueryContent)element;
            if ("key".equals(property)) {
                content.setKey(text);
            } else if ("value".equals(property)) {
                content.setValue(text);
            }
        }
        this.tableViewer.refresh();
    }
}

