/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.templateEditor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.helper.EclipseBuilderHelper;
import org.eclipse.egf.core.pde.tools.ConvertProjectOperation;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.plugin.WorkspaceExtensionsModel;
import org.eclipse.pde.internal.core.text.bundle.BundleSymbolicNameHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertPluginProjectOperation
extends ConvertProjectOperation {
    public static final String JET_NATURE_ID = "org.eclipse.jet.jet2Nature";
    private static final String PLUGIN_ID = "org.eclipse.jet";
    private static final String EXTENSION_NAME = "transform";
    private static final String EXTENSION_POINT_ID = "org.eclipse.jet.transform";
    private int K_SOURCE = 1;
    private boolean _hasJetNature;
    private IProject _project;
    private IPlatformBundle platformBundle;

    public ConvertPluginProjectOperation(IProject project, IPlatformBundle platformBundle) {
        super(project, false, false);
        this._project = project;
        this.platformBundle = platformBundle;
    }

    public List<String> addDependencies() {
        return super.addDependencies();
    }

    public List<String> addSourceFolders() {
        return super.addSourceFolders();
    }

    public void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        String[] natureIds;
        IProject project = this.platformBundle.getProject();
        IFile pluginFile = project.getFile("META-INF/MANIFEST.MF");
        IFile plugin = this._project.getFile("META-INF/MANIFEST.MF");
        if (!plugin.exists() && pluginFile.exists()) {
            IFolder folder = this._project.getFolder("META-INF/");
            if (folder == null) {
                throw new IllegalStateException();
            }
            if (!folder.exists()) {
                folder.create(true, true, monitor);
            }
            pluginFile.copy(plugin.getFullPath(), true, monitor);
        }
        super.execute(monitor);
        this._hasJetNature = false;
        IProjectDescription description = this._project.getDescription();
        String[] stringArray = natureIds = description.getNatureIds();
        int n = natureIds.length;
        int n2 = 0;
        while (n2 < n) {
            String natureID = stringArray[n2];
            if (natureID.equals(JET_NATURE_ID)) {
                this._hasJetNature = true;
            }
            ++n2;
        }
        if (!this._hasJetNature) {
            EclipseBuilderHelper.addNature((IProjectDescription)description, (String)JET_NATURE_ID, (IProgressMonitor)monitor);
            this._project.setDescription(description, monitor);
        }
        this.addLinkedSource(project, this._project, monitor);
    }

    protected void fireStructureChanged(IPluginObject child, WorkspaceExtensionsModel workspaceExtensionModel, int changeType) {
        WorkspaceExtensionsModel model = workspaceExtensionModel;
        if (model.isEditable() && model instanceof IModelChangeProvider) {
            ModelChangedEvent e = new ModelChangedEvent((IModelChangeProvider)model, changeType, new Object[]{child}, null);
            if (model.isEditable() && model instanceof IModelChangeProvider) {
                IModelChangeProvider provider = (IModelChangeProvider)model;
                provider.fireModelChanged((IModelChangedEvent)e);
            }
        }
    }

    protected void manageManifestFile(IBundlePluginModelBase model) throws CoreException {
        IBundle bundle = model.getBundleModel().getBundle();
        String pluginId = ConvertPluginProjectOperation.getValidId((String)this._project.getName());
        String pluginName = this.createInitialName(pluginId);
        bundle.setHeader("Bundle-Name", pluginName);
        IManifestHeader header = bundle.getManifestHeader("Bundle-SymbolicName");
        if (header != null && header instanceof BundleSymbolicNameHeader) {
            BundleSymbolicNameHeader symbolic = (BundleSymbolicNameHeader)header;
            if (symbolic.getId() == null || symbolic.getId().trim().length() == 0) {
                symbolic.setId(pluginId);
            }
            if (!symbolic.isSingleton()) {
                symbolic.setSingleton(true);
            }
        } else {
            bundle.setHeader("Bundle-SymbolicName", String.valueOf(pluginId) + ";singleton:=true");
        }
    }

    private void addLinkedSource(IProject userProject, IProject tempProject, IProgressMonitor monitor) throws CoreException {
        ArrayList entries = new ArrayList();
        IJavaProject userJavaProject = JavaCore.create((IProject)userProject);
        IJavaProject tempJavaProject = JavaCore.create((IProject)tempProject);
        try {
            IPackageFragmentRoot[] allPackageFragmentRoots = userJavaProject.getAllPackageFragmentRoots();
            CPListElement[] existing = CPListElement.createFromExisting((IJavaProject)tempJavaProject);
            ArrayList<CPListElement> cpListElements = new ArrayList<CPListElement>();
            CPListElement[] cPListElementArray = existing;
            int n = existing.length;
            int n2 = 0;
            while (n2 < n) {
                CPListElement elment = cPListElementArray[n2];
                cpListElements.add(elment);
                ++n2;
            }
            if (allPackageFragmentRoots != null && allPackageFragmentRoots.length > 0) {
                cPListElementArray = allPackageFragmentRoots;
                n = allPackageFragmentRoots.length;
                n2 = 0;
                while (n2 < n) {
                    CPListElement packageFragmentRoot = cPListElementArray[n2];
                    int kind = packageFragmentRoot.getKind();
                    if (kind == this.K_SOURCE) {
                        IClasspathEntry rawClasspathEntry = packageFragmentRoot.getRawClasspathEntry();
                        IPath fullPath = packageFragmentRoot.getResource().getLocation();
                        IPath path = rawClasspathEntry.getPath();
                        IPath removeLastSegments = path.removeLastSegments(path.segmentCount() - 1);
                        IPath pathFolder = path.removeFirstSegments(path.segmentCount() - 1);
                        pathFolder = this.createFolder(fullPath, pathFolder.toString(), tempProject, monitor);
                        CPListElement newEntrie = new CPListElement(tempJavaProject, 3);
                        newEntrie.setLinkTarget(fullPath);
                        newEntrie.setPath(pathFolder);
                        newEntrie.setExported(true);
                        cpListElements.add(newEntrie);
                    }
                    ++n2;
                }
            }
            BuildPathsBlock.flush(cpListElements, (IPath)tempJavaProject.getOutputLocation(), (IJavaProject)tempJavaProject, null, (IProgressMonitor)monitor);
        }
        finally {
            userJavaProject.close();
            tempJavaProject.close();
        }
    }

    private IPath createFolder(IPath path, String fName, IProject tempProject, IProgressMonitor monitor) throws CoreException {
        String folderName = fName;
        IFolder tempFolder = tempProject.getFolder(folderName);
        IPath fullPath = tempFolder.getFullPath();
        if (tempFolder.exists()) {
            folderName = "temp" + folderName;
            fullPath = this.createFolder(path, folderName, tempProject, monitor);
        }
        return fullPath;
    }
}

