/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.annotations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jet.internal.editor.annotations.JETProblemAnnotation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;

public class JETAnnotationHover
implements IAnnotationHover {
    protected int compareRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            int javaAnnotationLine;
            block5: {
                javaAnnotationLine = document.getLineOfOffset(position.getOffset());
                if (line != javaAnnotationLine) break block5;
                return 1;
            }
            try {
                if (javaAnnotationLine <= line && line <= document.getLineOfOffset(position.getOffset() + position.getLength())) {
                    return 2;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return 0;
    }

    protected List select(List exactMatch, List including) {
        return exactMatch;
    }

    protected List getAnnotationsForLine(ISourceViewer viewer, int line) {
        IDocument document = viewer.getDocument();
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        ArrayList<JETProblemAnnotation> exact = new ArrayList<JETProblemAnnotation>();
        ArrayList<JETProblemAnnotation> including = new ArrayList<JETProblemAnnotation>();
        Iterator e = model.getAnnotationIterator();
        HashMap messagesAtPosition = new HashMap();
        while (e.hasNext()) {
            JETProblemAnnotation a;
            Position position;
            Object o = e.next();
            if (!(o instanceof JETProblemAnnotation) || (position = model.getPosition((Annotation)(a = (JETProblemAnnotation)((Object)o)))) == null || this.isDuplicateAnnotation(messagesAtPosition, position, a.getText())) continue;
            switch (this.compareRulerLine(position, document, line)) {
                case 1: {
                    exact.add(a);
                    break;
                }
                case 2: {
                    including.add(a);
                }
            }
        }
        return this.select(exact, including);
    }

    private boolean isDuplicateAnnotation(Map messagesAtPosition, Position position, String message) {
        if (messagesAtPosition.containsKey(position)) {
            Object value = messagesAtPosition.get(position);
            if (message.equals(value)) {
                return true;
            }
            if (value instanceof List) {
                List messages = (List)value;
                if (messages.contains(message)) {
                    return true;
                }
                messages.add(message);
            } else {
                ArrayList<Object> messages = new ArrayList<Object>();
                messages.add(value);
                messages.add(message);
                messagesAtPosition.put(position, messages);
            }
        } else {
            messagesAtPosition.put(position, message);
        }
        return false;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        List annotations = this.getAnnotationsForLine(sourceViewer, lineNumber);
        if (annotations != null) {
            int size = annotations.size();
            if (size == 1) {
                JETProblemAnnotation annotation = (JETProblemAnnotation)((Object)annotations.get(0));
                String message = annotation.getText();
                if (message != null && message.trim().length() > 0) {
                    return message;
                }
            } else {
                ArrayList<String> messages = new ArrayList<String>();
                int i = 0;
                while (i < size) {
                    JETProblemAnnotation javaAnnotation = (JETProblemAnnotation)((Object)annotations.get(i));
                    String message = javaAnnotation.getText();
                    if (message != null && message.trim().length() > 0) {
                        messages.add(message.trim());
                    }
                    ++i;
                }
                if (messages.size() == 1) {
                    return (String)messages.get(0);
                }
                if (messages.size() > 1) {
                    String result = "Multiple markers at this line\n";
                    int j = 0;
                    while (j < messages.size()) {
                        result = String.valueOf(result) + "    - " + messages.get(j);
                        if (j != messages.size() - 1) {
                            result = String.valueOf(result) + "\n";
                        }
                        ++j;
                    }
                    return result;
                }
            }
        }
        return "";
    }
}

