/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.eval.IEvaluationContext;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jet.compiler.CompileOptionsManager;
import org.eclipse.jet.core.compiler.JETCompilerOptions;
import org.eclipse.jet.core.parser.ProblemSeverity;
import org.eclipse.jet.core.parser.ast.JETASTElement;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.core.parser.ast.JavaDeclaration;
import org.eclipse.jet.core.parser.ast.JavaExpression;
import org.eclipse.jet.core.parser.ast.JavaScriptlet;
import org.eclipse.jet.core.parser.ast.Problem;
import org.eclipse.jet.internal.editor.Activator;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IFileEditorInput;

public class JETEditorHelper {
    public static int getASTElementContentStart(JETASTElement astElement, IDocument jetDocument) {
        int jetStart = astElement.getStart();
        if (astElement instanceof JavaDeclaration) {
            jetStart += 3;
        }
        if (astElement instanceof JavaExpression || astElement instanceof JavaScriptlet) {
            try {
                String jetSnippet = jetDocument.get(jetStart, astElement.getEnd() - jetStart);
                String javaContent = astElement instanceof JavaExpression ? ((JavaExpression)astElement).getJavaContent() : ((JavaScriptlet)astElement).getJavaContent();
                int idx = jetSnippet.indexOf(javaContent);
                jetStart += idx;
            }
            catch (BadLocationException e) {
                Activator.log((Exception)((Object)e));
            }
        }
        return jetStart;
    }

    public static boolean checkOffsetPositions(String javaSource, String jetSource, int jetOffset, int javaOffset, int checkDepth) {
        String jetCheckString;
        boolean result = false;
        String javaCheckString = javaSource.substring(javaOffset, Math.min(javaSource.length(), javaOffset + checkDepth));
        boolean bl = result = javaCheckString.compareTo(jetCheckString = jetSource.substring(jetOffset, Math.min(jetSource.length(), jetOffset + checkDepth))) == 0;
        if (!result) {
            System.err.println("position matching error");
            System.err.println("JET Check String  : " + jetCheckString);
            System.err.println("Java Check String  : " + javaCheckString);
        }
        return result;
    }

    public static List evaluateProblems(JETTextEditor jetEditor, IDocument jetDocument) {
        JETCompilationUnit cu = jetEditor.requestCompilationUnit();
        String packageName = cu.getOutputJavaPackage();
        String className = cu.getOutputJavaClassName();
        ArrayList problems = new ArrayList();
        if (packageName == null || className == null) {
            return problems;
        }
        HashMap mappingPositions = new HashMap();
        String javaSource = jetEditor.compilationHelper().getJavaCode(cu, mappingPositions);
        JETJavaContentProblemRequestor problemRequestor = new JETJavaContentProblemRequestor(problems, mappingPositions, jetDocument);
        try {
            ICompilationUnit compilationUnit = null;
            IJavaProject javaProject = jetEditor.getJavaProject();
            System.out.println("Project: " + javaProject.getElementName());
            if (!javaProject.getElementName().startsWith(".")) {
                System.out.println();
            }
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                if (1 == root.getKind()) {
                    IPackageFragment packageFragment = root.getPackageFragment(packageName);
                    if (packageFragment == null || !packageFragment.exists()) {
                        packageFragment = root.createPackageFragment(packageName, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    compilationUnit = packageFragment.createCompilationUnit(String.valueOf(className) + ".java", javaSource, true, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                ++i;
            }
            WorkingCopyOwner owner = new WorkingCopyOwner(){};
            ICompilationUnit copy = compilationUnit.getWorkingCopy(owner, (IProblemRequestor)problemRequestor, null);
            copy.reconcile(0, true, owner, null);
        }
        catch (JavaModelException e) {
            System.out.println((Object)e);
            Activator.log((Exception)((Object)e));
        }
        return problems;
    }

    public static CompletionProposalCollector collect(IJavaProject javaProject, JETCompilationUnit cu, String codeSnippet, int offset) {
        IEvaluationContext context = javaProject.newEvaluationContext();
        ArrayList<String> importList = new ArrayList<String>();
        importList.addAll(cu.getImports());
        importList.add("org.eclipse.jet.JET2Context");
        importList.add("org.eclipse.jet.JET2Template");
        importList.add("org.eclipse.jet.JET2Writer");
        importList.add("org.eclipse.jet.taglib.RuntimeTagElement");
        importList.add("org.eclipse.jet.taglib.TagInfo");
        String[] imports = new String[importList.size()];
        importList.toArray(imports);
        String packageName = cu.getOutputJavaPackage();
        if (packageName == null) {
            Map options = CompileOptionsManager.getOptions((IProject)javaProject.getProject());
            if (options.isEmpty()) {
                options = JETCompilerOptions.getDefaultCompilerOptions();
            }
            packageName = (String)options.get("org.eclipse.jet.compiledTemplatePackage");
        }
        context.setPackageName(packageName);
        context.setImports(imports);
        CompletionProposalCollector proposalCollector = new CompletionProposalCollector(javaProject);
        try {
            context.codeComplete(codeSnippet, offset, (CompletionRequestor)proposalCollector);
            return proposalCollector;
        }
        catch (JavaModelException e) {
            Activator.log((Exception)((Object)e));
            return null;
        }
    }

    public static IJavaCompletionProposal[] getJavaCompletionProposal(JETTextEditor jetEditor, ITextViewer viewer, int completionOffset) {
        JETCompilationUnit cu = jetEditor.requestCompilationUnit();
        IJavaProject javaProject = jetEditor.getJavaProject();
        String packageName = cu.getOutputJavaPackage();
        String className = cu.getOutputJavaClassName();
        if (packageName == null) {
            Map options = CompileOptionsManager.getOptions((IProject)javaProject.getProject());
            if (options.isEmpty()) {
                options = JETCompilerOptions.getDefaultCompilerOptions();
            }
            packageName = (String)options.get("org.eclipse.jet.compiledTemplatePackage");
        }
        if (className == null && jetEditor.getEditorInput() instanceof IFileEditorInput) {
            String baseClassName;
            IFile file = ((IFileEditorInput)jetEditor.getEditorInput()).getFile();
            String inputName = file.getFullPath().removeFileExtension().lastSegment();
            className = baseClassName = JETEditorHelper.makeJavaClassName(inputName);
        }
        if (packageName == null || className == null) {
            return new IJavaCompletionProposal[0];
        }
        HashMap mappingPositions = new HashMap();
        Document javaDocument = new Document(jetEditor.compilationHelper().getJavaCode(cu, mappingPositions));
        ICompilationUnit compilationUnit = null;
        try {
            IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
            int i = 0;
            if (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                IPackageFragment packageFragment = root.getPackageFragment(packageName);
                if (packageFragment == null || !packageFragment.exists()) {
                    packageFragment = root.createPackageFragment(packageName, true, (IProgressMonitor)new NullProgressMonitor());
                }
                compilationUnit = packageFragment.createCompilationUnit(String.valueOf(className) + ".java", javaDocument.get(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            CompletionProposalCollector proposalCollector = new CompletionProposalCollector(compilationUnit);
            JETASTElement astElement = jetEditor.getASTElement(completionOffset);
            Position javaPosition = (Position)mappingPositions.get(astElement);
            int jetStart = JETEditorHelper.getASTElementContentStart(astElement, viewer.getDocument());
            int javaStart = javaPosition.getOffset();
            int javaCompletionOffset = javaStart + (completionOffset - jetStart);
            compilationUnit.codeComplete(javaCompletionOffset, (CompletionRequestor)proposalCollector);
            Point selection = viewer.getSelectedRange();
            if (selection.y > 0) {
                proposalCollector.setReplacementLength(selection.y);
            }
            IJavaCompletionProposal[] javaProposals = proposalCollector.getJavaCompletionProposals();
            IJavaCompletionProposal[] keywordsProposals = proposalCollector.getKeywordCompletionProposals();
            IJavaCompletionProposal[] unsortedJavaProposals = new IJavaCompletionProposal[javaProposals.length + keywordsProposals.length];
            System.arraycopy(keywordsProposals, 0, unsortedJavaProposals, 0, keywordsProposals.length);
            System.arraycopy(javaProposals, 0, unsortedJavaProposals, keywordsProposals.length, javaProposals.length);
            LinkedList<IJavaCompletionProposal> sortedJavaProposals = new LinkedList<IJavaCompletionProposal>();
            int i2 = 0;
            while (i2 < unsortedJavaProposals.length) {
                IJavaCompletionProposal unsortedJavaProposal = unsortedJavaProposals[i2];
                int index = 0;
                for (IJavaCompletionProposal proposal : sortedJavaProposals) {
                    if (proposal.getRelevance() > unsortedJavaProposal.getRelevance()) continue;
                    index = sortedJavaProposals.indexOf(proposal);
                    break;
                }
                sortedJavaProposals.add(index, unsortedJavaProposal);
                ++i2;
            }
            IJavaCompletionProposal[] results = new IJavaCompletionProposal[sortedJavaProposals.size()];
            sortedJavaProposals.toArray(results);
            JETEditorHelper.adjustResults(results, completionOffset);
            return results;
        }
        catch (JavaModelException e) {
            Activator.log((Exception)((Object)e));
            return new IJavaCompletionProposal[0];
        }
    }

    public static IJavaCompletionProposal[] getJavaCompletionProposal(IJavaProject javaProject, JETCompilationUnit cu, String codeSnippet, ITextViewer viewer, int offset) {
        CompletionProposalCollector proposalCollector = JETEditorHelper.collect(javaProject, cu, codeSnippet, offset);
        if (proposalCollector != null) {
            Point selection = viewer.getSelectedRange();
            if (selection.y > 0) {
                proposalCollector.setReplacementLength(selection.y);
            }
            IJavaCompletionProposal[] javaProposals = proposalCollector.getJavaCompletionProposals();
            IJavaCompletionProposal[] keywordsProposals = proposalCollector.getKeywordCompletionProposals();
            IJavaCompletionProposal[] unsortedJavaProposals = new IJavaCompletionProposal[javaProposals.length + keywordsProposals.length];
            System.arraycopy(keywordsProposals, 0, unsortedJavaProposals, 0, keywordsProposals.length);
            System.arraycopy(javaProposals, 0, unsortedJavaProposals, keywordsProposals.length, javaProposals.length);
            LinkedList<IJavaCompletionProposal> sortedJavaProposals = new LinkedList<IJavaCompletionProposal>();
            int i = 0;
            while (i < unsortedJavaProposals.length) {
                IJavaCompletionProposal unsortedJavaProposal = unsortedJavaProposals[i];
                int index = 0;
                for (IJavaCompletionProposal proposal : sortedJavaProposals) {
                    if (proposal.getRelevance() > unsortedJavaProposal.getRelevance()) continue;
                    index = sortedJavaProposals.indexOf(proposal);
                    break;
                }
                sortedJavaProposals.add(index, unsortedJavaProposal);
                ++i;
            }
            IJavaCompletionProposal[] results = new IJavaCompletionProposal[sortedJavaProposals.size()];
            sortedJavaProposals.toArray(results);
            return results;
        }
        return new IJavaCompletionProposal[0];
    }

    public static void adjustResults(IJavaCompletionProposal[] results, int offset) {
        int i = 0;
        while (i < results.length) {
            if (results[i] instanceof AbstractJavaCompletionProposal) {
                AbstractJavaCompletionProposal proposal = (AbstractJavaCompletionProposal)results[i];
                proposal.setReplacementOffset(offset);
            }
            ++i;
        }
    }

    public static void adjustJavaScriptletProposalResults(IJavaCompletionProposal[] results, int offset) {
        IJavaCompletionProposal iJavaCompletionProposal;
        if (results.length > 0 && (iJavaCompletionProposal = results[0]) instanceof AbstractJavaCompletionProposal) {
            AbstractJavaCompletionProposal proposal = (AbstractJavaCompletionProposal)iJavaCompletionProposal;
            int replacementLength = proposal.getReplacementLength();
            JETEditorHelper.adjustResults(results, offset - replacementLength);
        }
    }

    public static String makeJavaClassName(String name) {
        StringBuffer result = new StringBuffer("_jet_");
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private static final class JETJavaContentProblemRequestor
    implements IProblemRequestor {
        private List problems;
        private List javaProblems;
        private IDocument jetDocument;
        private Map mappingPositions;

        private JETJavaContentProblemRequestor(List problems, Map mappings, IDocument jetDocument) {
            this.problems = problems;
            this.mappingPositions = mappings;
            this.javaProblems = new ArrayList();
            this.jetDocument = jetDocument;
        }

        public List getProblems() {
            return this.problems;
        }

        public void acceptProblem(IProblem problem) {
            this.javaProblems.add(problem);
        }

        public void beginReporting() {
            this.javaProblems.clear();
        }

        public void endReporting() {
            for (IProblem javaProblem : this.javaProblems) {
                int javaProblemOffset = javaProblem.getSourceStart();
                int problemLength = javaProblem.getSourceEnd() - javaProblemOffset + 1;
                JETASTElement astElement = this.getElementForJavaOffset(javaProblemOffset);
                Position pos = (Position)this.mappingPositions.get(astElement);
                int astElementJavaContentStart = pos == null ? -1 : pos.getOffset();
                int jetOffset = pos == null ? 0 : JETEditorHelper.getASTElementContentStart(astElement, this.jetDocument) + (javaProblemOffset - astElementJavaContentStart);
                URI baseLocation = URI.create("");
                Problem problem = new Problem(baseLocation, "", javaProblem.isWarning() ? ProblemSeverity.WARNING : ProblemSeverity.ERROR, -1, javaProblem.getMessage(), (Object[])javaProblem.getArguments(), jetOffset, jetOffset + problemLength, -1, -1);
                this.problems.add(problem);
            }
        }

        public boolean isActive() {
            return true;
        }

        private JETASTElement getElementForJavaOffset(int javaOffset) {
            for (JETASTElement element : this.mappingPositions.keySet()) {
                Position pos = (Position)this.mappingPositions.get(element);
                if (pos.getOffset() > javaOffset || javaOffset >= pos.getOffset() + pos.getLength()) continue;
                return element;
            }
            return null;
        }
    }
}

