/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table.provider;

import java.util.Iterator;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.impl.StringToFileInfoImpl;
import org.eclipse.egerrit.internal.ui.compare.GerritDiffNode;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public class HandleFileSelection {
    private GerritClient fGerritClient;
    private ColumnViewer fViewer;

    public HandleFileSelection(GerritClient gerritClient, ColumnViewer viewer) {
        this.fGerritClient = gerritClient;
        this.fViewer = viewer;
    }

    public void showFileSelection() {
        ISelection selection = this.fViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Iterator itr = structuredSelection.iterator();
            String failedFiles = "";
            while (itr.hasNext()) {
                failedFiles = this.findFailedFiles(itr);
            }
            if (!failedFiles.isEmpty()) {
                UIUtils.displayInformation(Messages.UIFilesTable_3, String.valueOf(Messages.UIFilesTable_2) + '\n' + failedFiles);
            }
        }
    }

    private String findFailedFiles(Iterator<?> itr) {
        String failedFiles = "";
        Object element = itr.next();
        if (element == null) {
            return "";
        }
        FileInfo fileInfo = this.fViewer instanceof TableViewer ? ((StringToFileInfoImpl)element).getValue() : ((GerritDiffNode)((Object)element)).getFileInfo();
        String status = fileInfo.getStatus();
        if (status.compareTo("D") != 0 && !UIUtils.openSingleFile(fileInfo, this.fGerritClient, fileInfo.getRevision(), 0)) {
            failedFiles = String.valueOf(failedFiles) + fileInfo.getPath() + '\n';
        }
        QueryHelpers.markAsReviewed(this.fGerritClient, fileInfo);
        return failedFiles;
    }
}

