/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.utils;

import java.util.Collections;
import java.util.List;
import org.eclipse.egerrit.internal.ui.utils.EditExtractor;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class MarkerRepositioner {
    private Repository repo;
    private String filePath;
    private EditList edits;

    public MarkerRepositioner(Repository repo, String filePath) throws Exception {
        this.repo = repo;
        this.filePath = filePath;
        this.computeEdits();
    }

    private void computeEdits() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Git git = new Git(this.repo);){
            Throwable throwable2 = null;
            Object var5_8 = null;
            try (EditExtractor formatter = new EditExtractor(System.out);){
                formatter.setPathFilter((TreeFilter)PathFilter.create((String)this.filePath));
                formatter.setRepository(git.getRepository());
                AbstractTreeIterator commitTreeIterator = this.prepareTreeParser(git.getRepository(), "HEAD");
                FileTreeIterator workTreeIterator = new FileTreeIterator(git.getRepository());
                List diffEntries = formatter.scan(commitTreeIterator, (AbstractTreeIterator)workTreeIterator);
                for (DiffEntry entry : diffEntries) {
                    formatter.format(entry);
                }
                this.edits = formatter.getEdits();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private AbstractTreeIterator prepareTreeParser(Repository repository, String ref) throws Exception {
        Ref head = repository.getRef(ref);
        Throwable throwable = null;
        Object var5_6 = null;
        try (RevWalk walk = new RevWalk(repository);){
            RevCommit commit = walk.parseCommit((AnyObjectId)head.getObjectId());
            RevTree tree = walk.parseTree((AnyObjectId)commit.getTree().getId());
            CanonicalTreeParser oldTreeParser = new CanonicalTreeParser();
            Throwable throwable2 = null;
            Object var11_14 = null;
            try (ObjectReader oldReader = repository.newObjectReader();){
                oldTreeParser.reset(oldReader, (AnyObjectId)tree.getId());
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            return oldTreeParser;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public int getNewPositionFor(int originalLine) {
        if (this.edits == null) {
            return originalLine;
        }
        return this.computePosition(originalLine, (List<Edit>)this.edits, 0);
    }

    private int computePosition(int originalPosition, List<Edit> editList, int delta) {
        if (editList.isEmpty()) {
            return originalPosition + delta;
        }
        Edit current = editList.get(0);
        if (current.getBeginA() > originalPosition) {
            return originalPosition + delta;
        }
        if (current.getBeginA() == originalPosition && current.getEndA() == originalPosition) {
            return originalPosition + delta;
        }
        if (originalPosition >= current.getBeginA() && originalPosition < current.getEndA()) {
            if (current.getType() == Edit.Type.DELETE) {
                return -current.getBeginA();
            }
            if (current.getType() == Edit.Type.REPLACE) {
                return originalPosition;
            }
            return originalPosition;
        }
        return this.computePosition(originalPosition, editList.size() == 1 ? Collections.emptyList() : editList.subList(1, editList.size()), delta + this.lineDelta(current));
    }

    private int lineDelta(Edit edit) {
        if (edit.getType() == Edit.Type.INSERT) {
            return edit.getLengthB();
        }
        if (edit.getType() == Edit.Type.EMPTY) {
            return 0;
        }
        if (edit.getType() == Edit.Type.DELETE) {
            return -edit.getLengthA();
        }
        if (edit.getType() == Edit.Type.REPLACE) {
            return edit.getLengthB() - edit.getLengthA();
        }
        return 0;
    }

    public void setEdits(EditList edits) {
        this.edits = edits;
    }

    public MarkerRepositioner() {
    }
}

