/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.CherryPickRevisionCommand;
import org.eclipse.egerrit.internal.core.command.ListBranchesCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.core.rest.CherryPickInput;
import org.eclipse.egerrit.internal.model.BranchInfo;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.editors.CherryPickDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CherryPickProcess {
    private GerritClient fGerritClient = null;
    private ChangeInfo fChangeInfo = null;

    public void handleCherryPick(Shell shell, GerritClient gerritClient, ChangeInfo changeInfo, final RevisionInfo revision) {
        this.fGerritClient = gerritClient;
        this.fChangeInfo = changeInfo;
        BranchInfo[] listBranchesCmdResult = this.listBranches();
        ArrayList<String> listBranchesRef = new ArrayList<String>();
        Iterator<BranchInfo> it = Arrays.asList(listBranchesCmdResult).iterator();
        while (it.hasNext()) {
            listBranchesRef.add(it.next().getRef());
        }
        final CherryPickDialog cherryPickDialog = new CherryPickDialog((Composite)shell, listBranchesRef, revision.getCommit().getMessage());
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                int ret = cherryPickDialog.open();
                if (ret == 0) {
                    CherryPickProcess.this.cherryPickRevision(CherryPickProcess.this.fChangeInfo.getId(), revision.getId(), cherryPickDialog.getBranch(), cherryPickDialog.getMessage());
                }
            }
        });
    }

    private ChangeInfo cherryPickRevision(String changeId, String revisionId, String branch, String message) {
        CherryPickRevisionCommand cherryPickCmd = this.fGerritClient.cherryPickRevision(changeId, revisionId);
        CherryPickInput cherryPickInput = new CherryPickInput();
        cherryPickInput.setDestination(branch);
        cherryPickInput.setMessage(message);
        cherryPickCmd.setCommandInput((Object)cherryPickInput);
        ChangeInfo listBranchesCmdResult = null;
        try {
            listBranchesCmdResult = (ChangeInfo)cherryPickCmd.call();
        }
        catch (EGerritException e3) {
            EGerritCorePlugin.logError((String)(String.valueOf(this.fGerritClient.getRepository().formatGerritVersion()) + e3.getMessage()));
        }
        return listBranchesCmdResult;
    }

    private BranchInfo[] listBranches() {
        ListBranchesCommand listBranchesCmd = this.fGerritClient.listBranches(this.fChangeInfo.getProject());
        BranchInfo[] listBranchesCmdResult = null;
        try {
            listBranchesCmdResult = (BranchInfo[])listBranchesCmd.call();
        }
        catch (EGerritException e3) {
            EGerritCorePlugin.logError((String)(String.valueOf(this.fGerritClient.getRepository().formatGerritVersion()) + e3.getMessage()));
        }
        return listBranchesCmdResult;
    }
}

