/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.utils.ActiveWorkspaceRevision;
import org.eclipse.egerrit.internal.ui.utils.GerritToGitMapping;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egit.ui.internal.dialogs.CheckoutConflictDialog;
import org.eclipse.egit.ui.internal.fetch.FetchGerritChangeWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CheckoutRevision
extends Action {
    private RevisionInfo revision;
    private GerritClient gerritClient;
    private ChangeInfo changeInfo;

    public CheckoutRevision(RevisionInfo revision, GerritClient gerritClient) {
        this.revision = revision;
        this.gerritClient = gerritClient;
        this.changeInfo = this.revision.getChangeInfo();
        this.setText(Messages.CheckoutRevision_0);
    }

    public void run() {
        Repository localRepo = this.findLocalRepo(this.gerritClient, this.changeInfo.getProject());
        if (localRepo == null) {
            Status status = new Status(4, "org.eclipse.egerrit.core", Messages.CheckoutRevision_1);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.CheckoutRevision_2, (String)Messages.CheckoutRevision_3, (IStatus)status);
            return;
        }
        String psSelected = this.revision.getRef();
        if (psSelected == null || psSelected.isEmpty()) {
            Status status = new Status(4, "org.eclipse.egerrit.core", Messages.CheckoutRevision_4);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.CheckoutRevision_2, (String)Messages.CheckoutRevision_3, (IStatus)status);
        }
        FetchGerritChangeWizard var = new FetchGerritChangeWizard(localRepo, psSelected);
        WizardDialog w = new WizardDialog(this.getShell(), (IWizard)var);
        String currentActiveBranchName = this.getCurrentBranchName(localRepo);
        w.create();
        String dialogErrorMsg = w.getErrorMessage();
        String existingLocalBranchName = this.getTargetBranchName(localRepo);
        if (existingLocalBranchName != null && currentActiveBranchName.compareTo(existingLocalBranchName) == 0) {
            ActiveWorkspaceRevision.getInstance().activateCurrentRevision(this.gerritClient, this.changeInfo.getUserSelectedRevision());
            return;
        }
        if (dialogErrorMsg != null && dialogErrorMsg.contains("already exists")) {
            int result = this.checkOutOrNot(existingLocalBranchName);
            if (result == 256) {
                w.open();
                return;
            }
            if (result == 1) {
                return;
            }
            try {
                this.checkoutBranch(existingLocalBranchName, localRepo);
            }
            catch (Exception exception) {}
        } else {
            try {
                w.open();
            }
            catch (Exception exception) {}
        }
        ActiveWorkspaceRevision.getInstance().activateCurrentRevision(this.gerritClient, this.changeInfo.getUserSelectedRevision());
    }

    private String getCurrentBranchName(Repository localRepo) {
        String head = null;
        try {
            head = localRepo.getFullBranch();
        }
        catch (IOException iOException) {}
        if (head.startsWith(Messages.CheckoutRevision_7)) {
            try {
                return localRepo.getBranch();
            }
            catch (IOException iOException) {}
        }
        return head;
    }

    private int checkOutOrNot(String branchName) {
        IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode("org.eclipse.egerrit.prefs");
        Preferences editorPrefs = prefs.node("checkout");
        int choice = editorPrefs.getInt("doCheckout", 0);
        if (choice != 0) {
            return choice;
        }
        String title = Messages.CheckoutRevision_11;
        String message = String.valueOf(Messages.CheckoutRevision_12) + this.changeInfo.getSubject() + Messages.CheckoutRevision_13 + Messages.CheckoutRevision_14 + Messages.CheckoutRevision_15 + branchName + Messages.CheckoutRevision_16 + Messages.CheckoutRevision_17 + Messages.CheckoutRevision_18;
        MessageDialogWithToggle dialog = new MessageDialogWithToggle(Display.getDefault().getActiveShell(), title, null, message, 0, new String[]{Messages.CheckoutRevision_19, Messages.CheckoutRevision_20, Messages.CheckoutRevision_21}, 0, Messages.CheckoutRevision_22, false);
        dialog.open();
        int result = dialog.getReturnCode();
        if (result != 1 && dialog.getToggleState()) {
            editorPrefs.putInt("doCheckout", result);
            try {
                editorPrefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
        return result;
    }

    private void checkoutBranch(String branchName, Repository repo) throws Exception {
        CheckoutCommand command = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Git gitRepo = new Git(repo);){
                command = gitRepo.checkout();
                command.setCreateBranch(false);
                command.setName(branchName);
                command.setForce(false);
                command.call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            CheckoutResult result = command.getResult();
            new CheckoutConflictDialog(Display.getDefault().getActiveShell(), repo, result.getConflictList()).open();
        }
    }

    private String getTargetBranchName(Repository localRepo) {
        Set<String> branches = null;
        try {
            branches = this.getShortLocalBranchNames(new Git(localRepo));
        }
        catch (GitAPIException gitAPIException) {
            Status status = new Status(4, "org.eclipse.egerrit.core", Messages.CheckoutRevision_24);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.CheckoutRevision_2, (String)Messages.CheckoutRevision_26, (IStatus)status);
            return Messages.CheckoutRevision_27;
        }
        String shortName = String.valueOf(this.changeInfo.get_number()) + "/" + this.changeInfo.getUserSelectedRevision().get_number();
        Iterator<String> iterator = branches.iterator();
        String branchName = null;
        while (iterator.hasNext()) {
            String setElement = iterator.next();
            if (!setElement.contains(shortName)) continue;
            branchName = setElement;
            break;
        }
        return branchName;
    }

    private Set<String> getShortLocalBranchNames(Git git) throws GitAPIException {
        HashSet<String> branches = new HashSet<String>();
        Iterator iter = git.branchList().call().iterator();
        while (iter.hasNext()) {
            branches.add(Repository.shortenRefName((String)((Ref)iter.next()).getName()));
        }
        return branches;
    }

    private Repository findLocalRepo(GerritClient gerrit, String projectName) {
        GerritToGitMapping gerritToGitMap = null;
        try {
            gerritToGitMap = new GerritToGitMapping(new URIish(gerrit.getRepository().getURIBuilder(false).toString()), projectName);
        }
        catch (URISyntaxException e2) {
            EGerritCorePlugin.logError((String)(String.valueOf(gerrit.getRepository().formatGerritVersion()) + e2.getMessage()));
        }
        Repository jgitRepo = null;
        try {
            jgitRepo = gerritToGitMap.find();
        }
        catch (IOException e2) {
            EGerritCorePlugin.logError((String)(String.valueOf(gerrit.getRepository().formatGerritVersion()) + e2.getMessage()));
        }
        return jgitRepo;
    }

    private Shell getShell() {
        return Display.getDefault().getActiveShell();
    }
}

