/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal.editors.outline;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.fx.ide.jdt.ui.internal.JavaFXUIPlugin;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.osgi.service.prefs.BackingStoreException;

public class PropertyContentOutlinePage
extends ContentOutlinePage {
    private List<Object> hierarchicalStructure = new ArrayList<Object>();
    private List<Property> flatStructure = new ArrayList<Property>();
    private Pair[] properties = new Pair[0];
    private IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("propertiesoutline");
    private static final String PREF_SORTED = "sorted";
    private static final String PREF_HIERARCHICAL = "hierarchical";
    private Action sortAction;
    private Action hierarchicalAction;
    private String groupRegexp = "_|\\.|/";
    private IDocument document;
    private PropertiesFileEditor editor;

    public PropertyContentOutlinePage(PropertiesFileEditor editor) {
        IEditorInput input = editor.getEditorInput();
        IDocumentProvider provider = editor.getDocumentProvider();
        this.editor = editor;
        this.document = provider.getDocument((Object)input);
        this.document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                try {
                    PropertyContentOutlinePage.this.setProperties(PropertyContentOutlinePage.this.getPairs(event.fDocument));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        try {
            this.properties = this.getPairs(this.document);
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.sortAction = new Action("", 2){

            public void run() {
                PropertyContentOutlinePage.this.preferences.putBoolean(PropertyContentOutlinePage.PREF_SORTED, this.isChecked());
                try {
                    PropertyContentOutlinePage.this.preferences.flush();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
            }
        };
        this.sortAction.setImageDescriptor(JavaFXUIPlugin.getDefault().getImageRegistry().getDescriptor(JavaFXUIPlugin.ALPHASORT_ICON));
        this.sortAction.setChecked(this.isSorted());
        this.hierarchicalAction = new Action("", 2){

            public void run() {
                PropertyContentOutlinePage.this.preferences.putBoolean(PropertyContentOutlinePage.PREF_HIERARCHICAL, this.isChecked());
                try {
                    PropertyContentOutlinePage.this.preferences.flush();
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
            }
        };
        this.hierarchicalAction.setImageDescriptor(JavaFXUIPlugin.getDefault().getImageRegistry().getDescriptor(JavaFXUIPlugin.HIERACHICAL_ICON));
        this.hierarchicalAction.setChecked(this.isHierarchical());
        this.preferences.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getKey().equals(PropertyContentOutlinePage.PREF_SORTED)) {
                    boolean val = PropertyContentOutlinePage.this.isSorted();
                    PropertyContentOutlinePage.this.setSorted(val);
                    PropertyContentOutlinePage.this.sortAction.setChecked(val);
                } else if (event.getKey().equals(PropertyContentOutlinePage.PREF_HIERARCHICAL)) {
                    boolean val = PropertyContentOutlinePage.this.isHierarchical();
                    PropertyContentOutlinePage.this.setHierarchical(val);
                    PropertyContentOutlinePage.this.hierarchicalAction.setChecked(val);
                }
            }
        });
    }

    public Pair[] getPairs(IDocument document) throws UnsupportedEncodingException, IOException {
        Properties p = new Properties();
        p.load(new ByteArrayInputStream(document.get().getBytes("UTF-8")));
        Pair[] pairs = new Pair[p.entrySet().size()];
        int i = 0;
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            pairs[i++] = new Pair((String)e.getKey(), (String)e.getValue());
        }
        return pairs;
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        toolBarManager.add((IAction)this.hierarchicalAction);
        toolBarManager.add((IAction)this.sortAction);
        Action a = new Action("", 1){

            public void run() {
                try {
                    PropertyContentOutlinePage.this.getTreeViewer().getTree().setRedraw(false);
                    PropertyContentOutlinePage.this.getTreeViewer().collapseAll();
                }
                finally {
                    PropertyContentOutlinePage.this.getTreeViewer().getTree().setRedraw(true);
                }
            }
        };
        a.setImageDescriptor(JavaFXUIPlugin.getDefault().getImageRegistry().getDescriptor(JavaFXUIPlugin.COLLAPSE_ICON));
        toolBarManager.add((IAction)a);
    }

    protected void fireSelectionChanged(ISelection selection) {
        super.fireSelectionChanged(selection);
        Object o = ((IStructuredSelection)selection).getFirstElement();
        String searchKey = null;
        int selectionLength = 0;
        if (o instanceof PropertyGroup) {
            searchKey = ((PropertyGroup)o).name;
        } else if (o instanceof Property) {
            searchKey = ((Property)o).pair.key;
            selectionLength = ((Property)o).pair.value.length();
        }
        if (searchKey == null) {
            return;
        }
        int lines = this.document.getNumberOfLines();
        try {
            int i = 0;
            while (i < lines) {
                IRegion r = this.document.getLineInformation(i);
                String line = this.document.get(r.getOffset(), r.getLength());
                if (line.startsWith(searchKey)) {
                    this.editor.selectAndReveal(r.getOffset() + r.getLength() - selectionLength, selectionLength);
                    break;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void setSorted(boolean sorted) {
        if (sorted) {
            this.getTreeViewer().setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    if (e1 instanceof PropertyGroup && e2 instanceof PropertyGroup) {
                        return ((PropertyGroup)e1).name.compareTo(((PropertyGroup)e2).name);
                    }
                    if (e1 instanceof Property && e2 instanceof Property) {
                        String k1 = ((Property)e1).pair.key.replaceAll(PropertyContentOutlinePage.this.groupRegexp, "");
                        String k2 = ((Property)e2).pair.key.replaceAll(PropertyContentOutlinePage.this.groupRegexp, "");
                        return k1.compareTo(k2);
                    }
                    if (e1 instanceof Property) {
                        return -1;
                    }
                    if (e2 instanceof Property) {
                        return -1;
                    }
                    return super.compare(viewer, e1, e2);
                }
            });
        } else {
            this.getTreeViewer().setComparator(null);
        }
    }

    protected void setHierarchical(boolean val) {
        if (val) {
            this.getTreeViewer().setInput(this.hierarchicalStructure);
        } else {
            this.getTreeViewer().setInput(this.flatStructure);
        }
    }

    private void createHierarchicalStructure() {
        ArrayList<Property> found = new ArrayList<Property>();
        ArrayList<Property> added = new ArrayList<Property>();
        Pair[] pairArray = this.properties;
        int n = this.properties.length;
        int n2 = 0;
        while (n2 < n) {
            Pair property = pairArray[n2];
            boolean isFound = false;
            Iterator<Property> it = this.flatStructure.iterator();
            while (it.hasNext()) {
                Property p = it.next();
                if (!p.pair.key.equals(property.key)) continue;
                p.pair = property;
                isFound = true;
                found.add(p);
                it.remove();
            }
            if (!isFound) {
                added.add(new Property(property));
            }
            ++n2;
        }
        for (Property p : this.flatStructure) {
            if (p.parent != null) {
                p.parent.items.remove(p);
                p.parent = null;
                continue;
            }
            this.hierarchicalStructure.remove(p);
        }
        this.flatStructure.clear();
        this.flatStructure.addAll(found);
        for (Property p : added) {
            ArrayList<String> parts = new ArrayList<String>(Arrays.asList(p.pair.key.split(this.groupRegexp)));
            if (parts.size() > 1) {
                PropertyGroup group = this.getGroup(this.hierarchicalStructure, parts);
                if (parts.size() > 1) {
                    PropertyGroup tmp = group;
                    PropertyGroup root = null;
                    int i = 0;
                    while (i < parts.size() - 1) {
                        tmp = new PropertyGroup(tmp, (String)parts.get(i));
                        if (i == 0) {
                            root = tmp;
                        }
                        ++i;
                    }
                    p.parent = tmp;
                    p.parent.items.add(p);
                    if (group == null) {
                        this.hierarchicalStructure.add(root);
                    }
                } else {
                    p.parent = group;
                    p.parent.items.add(p);
                }
            } else {
                this.hierarchicalStructure.add(p);
            }
            this.flatStructure.add(p);
        }
        this.removeEmptyGroups(this.hierarchicalStructure);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setLabelProvider((IBaseLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof PropertyGroup) {
                    cell.setText(((PropertyGroup)element).name);
                    cell.setImage(JavaFXUIPlugin.getDefault().getImageRegistry().get(JavaFXUIPlugin.GROUP_ICON));
                    cell.setStyleRanges(null);
                } else if (element instanceof Property) {
                    cell.setImage(JavaFXUIPlugin.getDefault().getImageRegistry().get(JavaFXUIPlugin.KEY_ICON));
                    StyledString s = new StyledString(((Property)element).pair.key);
                    Object text = ((Property)element).pair.value;
                    if (((String)text).length() > 20) {
                        text = ((String)text).substring(0, 20) + "...";
                    }
                    s.append(" : " + (String)text, StyledString.DECORATIONS_STYLER);
                    cell.setStyleRanges(s.getStyleRanges());
                    cell.setText(s.getString());
                }
                super.update(cell);
            }
        });
        viewer.setContentProvider((IContentProvider)new HierarchicalContentProvider());
        if (this.isSorted()) {
            this.setSorted(true);
        }
        this.createHierarchicalStructure();
        if (this.isHierarchical()) {
            viewer.setInput(this.hierarchicalStructure);
        } else {
            viewer.setInput(this.flatStructure);
        }
    }

    public void setProperties(Pair[] properties) {
        this.properties = properties;
        this.createHierarchicalStructure();
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().refresh();
        }
    }

    private boolean isSorted() {
        return this.preferences.getBoolean(PREF_SORTED, true);
    }

    private boolean isHierarchical() {
        return this.preferences.getBoolean(PREF_HIERARCHICAL, false);
    }

    private void removeEmptyGroups(List<?> list) {
        Iterator<?> it = list.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof PropertyGroup)) continue;
            this.removeEmptyGroups(((PropertyGroup)o).groups);
            if (((PropertyGroup)o).groups.size() != 0 || ((PropertyGroup)o).items.size() != 0) continue;
            it.remove();
        }
    }

    private PropertyGroup getGroup(List<?> list, List<String> parts) {
        PropertyGroup group = null;
        for (Object o : list) {
            PropertyGroup tmp;
            if (!(o instanceof PropertyGroup) || !((PropertyGroup)o).name.equals(parts.get(0))) continue;
            parts.remove(0);
            group = (PropertyGroup)o;
            if (parts.size() > 1 && (tmp = this.getGroup(group.groups, parts)) != null) {
                return tmp;
            }
            return group;
        }
        return group;
    }

    static class HierarchicalContentProvider
    implements ITreeContentProvider {
        HierarchicalContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof PropertyGroup) {
                Object[] groups = ((PropertyGroup)parentElement).groups.toArray();
                Object[] items = ((PropertyGroup)parentElement).items.toArray();
                Object[] rv = new Object[groups.length + items.length];
                System.arraycopy(groups, 0, rv, 0, groups.length);
                System.arraycopy(items, 0, rv, groups.length, items.length);
                return rv;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof PropertyGroup) {
                return ((PropertyGroup)element).parent;
            }
            if (element instanceof Property) {
                return ((Property)element).parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof PropertyGroup) {
                return ((PropertyGroup)element).groups.size() > 0 || ((PropertyGroup)element).items.size() > 0;
            }
            return false;
        }
    }

    static class LabelProvider
    extends ColumnLabelProvider {
        LabelProvider() {
        }

        public String getText(Object element) {
            return super.getText(element);
        }
    }

    public static class Pair {
        public final String key;
        public final String value;

        public Pair(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class Property {
        private PropertyGroup parent;
        public Pair pair;

        public Property(Pair pair) {
            this(null, pair);
        }

        public Property(PropertyGroup parent, Pair pair) {
            this.parent = parent;
            this.pair = pair;
        }

        public String toString() {
            return super.toString() + "#" + this.pair.key + " / " + this.pair.value;
        }
    }

    public static class PropertyGroup {
        private PropertyGroup parent;
        public String name;
        private List<PropertyGroup> groups = new ArrayList<PropertyGroup>();
        private List<Property> items = new ArrayList<Property>();

        public PropertyGroup(String name) {
            this(null, name);
        }

        public PropertyGroup(PropertyGroup parent, String name) {
            this.parent = parent;
            if (parent != null) {
                parent.groups.add(this);
            }
            this.name = name;
        }

        public String toString() {
            return super.toString() + "#" + this.name;
        }
    }
}

