/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.log;

import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;

public interface Logger {
    public void log(@NonNull Level var1, @NonNull String var2);

    default public void log(@NonNull Level level, @NonNull Supplier<@NonNull String> messageSupplier) {
        if (this.isEnabled(level)) {
            this.log(level, messageSupplier.get());
        }
    }

    public void log(@NonNull Level var1, @NonNull String var2, @NonNull Throwable var3);

    default public void log(@NonNull Level level, @NonNull Supplier<@NonNull String> messageSupplier, @NonNull Throwable t) {
        if (this.isEnabled(level)) {
            this.log(level, messageSupplier.get(), t);
        }
    }

    public void logf(@NonNull Level var1, @NonNull String var2, Object ... var3);

    public void logf(@NonNull Level var1, @NonNull String var2, @NonNull Throwable var3, Object ... var4);

    public void trace(@NonNull String var1);

    default public void trace(@NonNull Supplier<@NonNull String> messageSupplier) {
        if (this.isEnabled(Level.TRACE)) {
            this.trace(messageSupplier.get());
        }
    }

    public void debug(@NonNull String var1);

    default public void debug(@NonNull Supplier<@NonNull String> messageSupplier) {
        if (this.isEnabled(Level.DEBUG)) {
            this.debug(messageSupplier.get());
        }
    }

    public void info(@NonNull String var1);

    default public void info(@NonNull Supplier<@NonNull String> messageSupplier) {
        if (this.isEnabled(Level.INFO)) {
            this.info(messageSupplier.get());
        }
    }

    public void warning(@NonNull String var1);

    default public void warning(@NonNull Supplier<@NonNull String> messageSupplier) {
        if (this.isEnabled(Level.WARNING)) {
            this.warning(messageSupplier.get());
        }
    }

    public void error(@NonNull String var1);

    default public void error(@NonNull Supplier<@NonNull String> messageSupplier) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(messageSupplier.get());
        }
    }

    public void fatal(@NonNull String var1);

    default public void fatal(@NonNull Supplier<@NonNull String> messageSupplier) {
        if (this.isEnabled(Level.FATAL)) {
            this.fatal(messageSupplier.get());
        }
    }

    public void trace(@NonNull String var1, @NonNull Throwable var2);

    default public void trace(@NonNull Supplier<@NonNull String> messageSupplier, @NonNull Throwable t) {
        if (this.isEnabled(Level.TRACE)) {
            this.trace(messageSupplier.get(), t);
        }
    }

    public void debug(@NonNull String var1, @NonNull Throwable var2);

    default public void debug(@NonNull Supplier<@NonNull String> messageSupplier, @NonNull Throwable t) {
        if (this.isEnabled(Level.DEBUG)) {
            this.debug(messageSupplier.get(), t);
        }
    }

    public void info(@NonNull String var1, @NonNull Throwable var2);

    default public void info(@NonNull Supplier<@NonNull String> messageSupplier, @NonNull Throwable t) {
        if (this.isEnabled(Level.INFO)) {
            this.info(messageSupplier.get(), t);
        }
    }

    public void warning(@NonNull String var1, @NonNull Throwable var2);

    default public void warning(@NonNull Supplier<@NonNull String> messageSupplier, @NonNull Throwable t) {
        if (this.isEnabled(Level.WARNING)) {
            this.warning(messageSupplier.get(), t);
        }
    }

    public void error(@NonNull String var1, @NonNull Throwable var2);

    default public void error(@NonNull Supplier<@NonNull String> messageSupplier, @NonNull Throwable t) {
        if (this.isEnabled(Level.ERROR)) {
            this.error(messageSupplier.get(), t);
        }
    }

    public void fatal(@NonNull String var1, @NonNull Throwable var2);

    default public void fatal(@NonNull Supplier<@NonNull String> messageSupplier, @NonNull Throwable t) {
        if (this.isEnabled(Level.FATAL)) {
            this.fatal(messageSupplier.get(), t);
        }
    }

    public void tracef(@NonNull String var1, Object ... var2);

    public void debugf(@NonNull String var1, Object ... var2);

    public void infof(@NonNull String var1, Object ... var2);

    public void warningf(@NonNull String var1, Object ... var2);

    public void errorf(@NonNull String var1, Object ... var2);

    public void fatalf(@NonNull String var1, Object ... var2);

    public void tracef(@NonNull String var1, @NonNull Throwable var2, Object ... var3);

    public void debugf(@NonNull String var1, @NonNull Throwable var2, Object ... var3);

    public void infof(@NonNull String var1, @NonNull Throwable var2, Object ... var3);

    public void warningf(@NonNull String var1, @NonNull Throwable var2, Object ... var3);

    public void errorf(@NonNull String var1, @NonNull Throwable var2, Object ... var3);

    public void fatalf(@NonNull String var1, @NonNull Throwable var2, Object ... var3);

    public boolean isEnabled(Level var1);

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        FATAL;

    }
}

