/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.fx.core.Util;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.jdt.annotation.NonNull;

public interface Resource<@NonNull O> {
    public O getNativeResource();

    public boolean release();

    public static Resource<@NonNull Path> createTempResource(final @NonNull Path path) {
        return new Resource<Path>(){

            @Override
            public boolean release() {
                try {
                    return Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    LoggerCreator.createLogger(Util.class).error("Unable to delete path '" + path + "'", (Throwable)e);
                    return false;
                }
            }

            @Override
            public Path getNativeResource() {
                return path;
            }
        };
    }

    public static Resource<@NonNull Path> createResource(final @NonNull Path path) {
        return new Resource<Path>(){

            @Override
            public boolean release() {
                return true;
            }

            @Override
            public Path getNativeResource() {
                return path;
            }
        };
    }
}

