/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.text.HitInfo;
import java.util.ArrayList;
import java.util.List;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import org.eclipse.fx.ui.controls.styledtext.ActionEvent;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.VerifyEvent;
import org.eclipse.fx.ui.controls.styledtext.skin.StyledTextSkin;

public class StyledTextBehavior
extends BehaviorBase<StyledTextArea> {
    private static final List<KeyBinding> KEY_BINDINGS = new ArrayList<KeyBinding>();

    static {
        KEY_BINDINGS.add(new KeyBinding(null, KeyEvent.KEY_PRESSED, "Consume"));
    }

    public StyledTextBehavior(StyledTextArea styledText) {
        super((Control)styledText, KEY_BINDINGS);
    }

    protected void callActionForEvent(KeyEvent arg0) {
        if (arg0.getEventType() == KeyEvent.KEY_PRESSED) {
            this.keyPressed(arg0, ((StyledTextArea)this.getControl()).getContent().getLineAtOffset(((StyledTextArea)this.getControl()).getCaretOffset()));
        }
        super.callActionForEvent(arg0);
    }

    protected void callAction(String arg0) {
        super.callAction(arg0);
    }

    public void mousePressed(MouseEvent arg0) {
        super.mousePressed(arg0);
        ((StyledTextArea)this.getControl()).requestFocus();
    }

    public boolean invokeAction(ActionEvent.ActionType action) {
        ActionEvent evt = new ActionEvent(this.getControl(), (EventTarget)this.getControl(), action);
        Event.fireEvent((EventTarget)this.getControl(), (Event)evt);
        return evt.isConsumed();
    }

    private void keyPressed(KeyEvent event, int currentRowIndex) {
        VerifyEvent evt = new VerifyEvent(this.getControl(), (EventTarget)this.getControl(), event);
        Event.fireEvent((EventTarget)this.getControl(), (Event)evt);
        if (evt.isConsumed()) {
            event.consume();
            return;
        }
        int offset = ((StyledTextArea)this.getControl()).getCaretOffset();
        switch (event.getCode()) {
            case SHIFT: 
            case CONTROL: 
            case ALT: {
                break;
            }
            case LEFT: {
                if (event.isAltDown()) {
                    this.invokeAction(ActionEvent.ActionType.WORD_PREVIOUS);
                    break;
                }
                if (offset == 0) {
                    event.consume();
                    break;
                }
                int newOffset = offset - 1;
                ((StyledTextArea)this.getControl()).getContent().getLineAtOffset(offset);
                ((StyledTextArea)this.getControl()).getContent().getLineAtOffset(newOffset);
                ((StyledTextArea)this.getControl()).impl_setCaretOffset(newOffset, event.isShiftDown());
                event.consume();
                break;
            }
            case RIGHT: {
                if (event.isAltDown()) {
                    this.invokeAction(ActionEvent.ActionType.WORD_NEXT);
                    break;
                }
                if (event.isMetaDown()) {
                    int currentLine = ((StyledTextArea)this.getControl()).getContent().getLineAtOffset(offset);
                    int lineOffset = ((StyledTextArea)this.getControl()).getContent().getOffsetAtLine(currentLine);
                    String lineContent = ((StyledTextArea)this.getControl()).getContent().getLine(currentLine);
                    ((StyledTextArea)this.getControl()).impl_setCaretOffset(lineOffset + lineContent.length(), event.isShiftDown());
                    event.consume();
                    break;
                }
                if (offset + 1 > ((StyledTextArea)this.getControl()).getContent().getCharCount()) break;
                int newOffset = offset + 1;
                ((StyledTextArea)this.getControl()).impl_setCaretOffset(newOffset, event.isShiftDown());
                event.consume();
                break;
            }
            case UP: {
                int rowIndex = currentRowIndex;
                if (rowIndex == 0) break;
                int colIdx = offset - ((StyledTextArea)this.getControl()).getContent().getOffsetAtLine(rowIndex);
                int lineOffset = ((StyledTextArea)this.getControl()).getContent().getOffsetAtLine(--rowIndex);
                int newCaretPosition = lineOffset + colIdx;
                int maxPosition = lineOffset + ((StyledTextArea)this.getControl()).getContent().getLine(rowIndex).length();
                ((StyledTextArea)this.getControl()).impl_setCaretOffset(Math.min(newCaretPosition, maxPosition), event.isShiftDown());
                break;
            }
            case DOWN: {
                int rowIndex = currentRowIndex;
                if (rowIndex + 1 == ((StyledTextArea)this.getControl()).getContent().getLineCount()) break;
                int colIdx = offset - ((StyledTextArea)this.getControl()).getContent().getOffsetAtLine(rowIndex);
                int lineOffset = ((StyledTextArea)this.getControl()).getContent().getOffsetAtLine(++rowIndex);
                int newCaretPosition = lineOffset + colIdx;
                int maxPosition = lineOffset + ((StyledTextArea)this.getControl()).getContent().getLine(rowIndex).length();
                ((StyledTextArea)this.getControl()).impl_setCaretOffset(Math.min(newCaretPosition, maxPosition), event.isShiftDown());
                break;
            }
            case ENTER: {
                int line = ((StyledTextArea)this.getControl()).getContent().getLineAtOffset(((StyledTextArea)this.getControl()).getCaretOffset());
                String lineContent = ((StyledTextArea)this.getControl()).getContent().getLine(line);
                char[] chars = lineContent.toCharArray();
                String prefix = "";
                int i = 0;
                while (i < chars.length) {
                    if (chars[i] != ' ') break;
                    prefix = String.valueOf(prefix) + " ";
                    ++i;
                }
                ((StyledTextArea)this.getControl()).getContent().replaceTextRange(((StyledTextArea)this.getControl()).getCaretOffset(), 0, String.valueOf(event.getText()) + prefix);
                ((StyledTextArea)this.getControl()).setCaretOffset(offset + 1 + prefix.length());
                break;
            }
            case DELETE: {
                if (event.isMetaDown()) {
                    this.invokeAction(ActionEvent.ActionType.DELETE_WORD_NEXT);
                    break;
                }
                ((StyledTextArea)this.getControl()).getContent().replaceTextRange(((StyledTextArea)this.getControl()).getCaretOffset(), 1, "");
                ((StyledTextArea)this.getControl()).setCaretOffset(offset);
                break;
            }
            case BACK_SPACE: {
                if (event.isMetaDown()) {
                    this.invokeAction(ActionEvent.ActionType.DELETE_WORD_PREVIOUS);
                    break;
                }
                ((StyledTextArea)this.getControl()).getContent().replaceTextRange(((StyledTextArea)this.getControl()).getCaretOffset() - 1, 1, "");
                ((StyledTextArea)this.getControl()).setCaretOffset(offset - 1);
                break;
            }
            case TAB: {
                event.consume();
                if (event.isShiftDown()) break;
                ((StyledTextArea)this.getControl()).getContent().replaceTextRange(((StyledTextArea)this.getControl()).getCaretOffset(), 0, "    ");
                ((StyledTextArea)this.getControl()).setCaretOffset(offset + 4);
                break;
            }
            case V: {
                if (event.isShortcutDown()) {
                    ((StyledTextArea)this.getControl()).paste();
                    event.consume();
                    break;
                }
            }
            case C: {
                if (event.isShortcutDown()) {
                    ((StyledTextArea)this.getControl()).copy();
                    event.consume();
                    break;
                }
            }
            default: {
                String text;
                if (event.isMetaDown() || event.isControlDown() || (text = event.getText()).length() <= 0) break;
                ((StyledTextArea)this.getControl()).getContent().replaceTextRange(((StyledTextArea)this.getControl()).getCaretOffset(), 0, text);
                ((StyledTextArea)this.getControl()).setCaretOffset(offset + 1);
            }
        }
    }

    public void mousePressed(MouseEvent event, List<StyledTextSkin.LineCell> visibleCells) {
        Point2D p = new Point2D(event.getX(), event.getY());
        for (StyledTextSkin.LineCell cell : visibleCells) {
            if (!cell.getBoundsInParent().contains(p)) continue;
            if (cell.getDomainElement() == null) break;
            p = p.subtract(cell.getLayoutX(), cell.getLayoutY());
            Region g = (Region)cell.getGraphic();
            p = p.subtract(g.getLayoutX(), g.getLayoutY());
            TextFlow flow = (TextFlow)g.getChildrenUnmodifiable().get(0);
            p = p.subtract(flow.getLayoutX(), flow.getLayoutY());
            for (Node n : flow.getChildren()) {
                HitInfo info;
                TextFlow text = (TextFlow)n;
                if (!text.getBoundsInParent().contains(p) || (info = ((Text)text.getChildren().get(0)).impl_hitTestChar(new Point2D(p.getX() - text.getLayoutX(), 0.0))).getInsertionIndex() < 0) continue;
                int offset = (Integer)text.getUserData() + info.getInsertionIndex();
                ((StyledTextArea)this.getControl()).impl_setCaretOffset(offset, event.isShiftDown());
                return;
            }
            int offset = cell.getDomainElement().getLineOffset() + cell.getDomainElement().getLineLength();
            ((StyledTextArea)this.getControl()).impl_setCaretOffset(offset, event.isShiftDown());
            break;
        }
        ((StyledTextArea)this.getControl()).requestFocus();
        Event.fireEvent((EventTarget)this.getControl(), (Event)event.copyFor((Object)this.getControl(), (EventTarget)this.getControl()));
    }
}

