/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.model.internal;

import org.eclipse.fx.ide.model.IFXEventHandlerProperty;
import org.eclipse.fx.ide.model.internal.FXClass;
import org.eclipse.fx.ide.model.internal.FXProperty;
import org.eclipse.fx.ide.model.internal.utils.Util;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class FXEventHandlerProperty
extends FXProperty
implements IFXEventHandlerProperty {
    private IType eventType;

    public FXEventHandlerProperty(FXClass fxClass, String name, IJavaElement javaElement, boolean isStatic) {
        super(fxClass, name, javaElement, isStatic);
    }

    public static boolean isEventHandler(IJavaProject jp, String erasedFQNType) throws JavaModelException {
        String checkType = erasedFQNType;
        do {
            if ("javafx.event.EventHandler".equals(checkType)) {
                return true;
            }
            IType t = jp.findType(checkType);
            if ((checkType = t.getSuperclassName()) == null) continue;
            checkType = Util.getFQNType(t, checkType);
        } while (checkType != null);
        return false;
    }

    @Override
    public IType getEventType() {
        if (this.eventType == null) {
            try {
                IMethod m = (IMethod)this.getJavaElement();
                String signature = this.isSetable() ? m.getParameterTypes()[0] : m.getReturnType();
                IType t = (IType)m.getParent();
                String fqnType = Util.toFQN(t, signature);
                this.eventType = this.getFXClass().getJavaProject().findType(fqnType);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return this.eventType;
    }

    @Override
    public String getEventTypeAsString(boolean fqn) {
        IType t = this.getEventType();
        if (t == null) {
            return "?";
        }
        return fqn ? t.getFullyQualifiedName() : t.getElementName();
    }

    public String toString() {
        return "FXEventHandlerProperty(" + this.getName() + ")";
    }
}

