/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.provisional.JavaModelAccess;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AutomaticModuleNaming;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
class InternalModuleSupport {
    private static final Logger log = LoggerFactory.getLogger(InternalModuleSupport.class);
    private static final int PATCH_MODULE = 6;

    InternalModuleSupport() {
    }

    public static void configureClasspath(IMavenProjectFacade facade, IClasspathDescriptor classpath, IProgressMonitor monitor) throws CoreException {
        LinkedHashSet<String> requiredModules;
        IJavaProject javaProject = JavaCore.create((IProject)facade.getProject());
        if (javaProject == null || !javaProject.exists()) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((requiredModules = new LinkedHashSet<String>(InternalModuleSupport.getRequiredModules(javaProject, monitor))).isEmpty() || classpath.getEntryDescriptors().isEmpty() || monitor.isCanceled()) {
            return;
        }
        List<IClasspathEntryDescriptor> entryDescriptors = classpath.getEntryDescriptors();
        HashMap<String, IClasspathEntryDescriptor> moduleMap = new HashMap<String, IClasspathEntryDescriptor>(entryDescriptors.size());
        HashMap<IClasspathEntryDescriptor, String> descriptorsMap = new HashMap<IClasspathEntryDescriptor, String>(entryDescriptors.size());
        for (IClasspathEntryDescriptor entry2 : entryDescriptors) {
            if (monitor.isCanceled()) {
                return;
            }
            String moduleName = InternalModuleSupport.getModuleName(entry2.getEntryKind(), entry2.getPath(), monitor);
            moduleMap.put(moduleName, entry2);
            descriptorsMap.put(entry2, moduleName);
        }
        HashSet<String> visitedModules = new HashSet<String>(entryDescriptors.size());
        InternalModuleSupport.collectTransitiveRequiredModules(requiredModules, visitedModules, moduleMap, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        descriptorsMap.forEach((entry, module) -> {
            if (requiredModules.contains(module)) {
                entry.setClasspathAttribute("module", Boolean.TRUE.toString());
            }
        });
    }

    private static void collectTransitiveRequiredModules(Set<String> requiredModules, Set<String> visitedModules, Map<String, IClasspathEntryDescriptor> moduleMap, IProgressMonitor monitor) throws JavaModelException {
        if (monitor.isCanceled() || requiredModules.isEmpty()) {
            return;
        }
        LinkedHashSet<String> transitiveModules = new LinkedHashSet<String>();
        for (String req : requiredModules) {
            if (visitedModules.contains(req)) continue;
            Set<String> modules = InternalModuleSupport.getRequiredModules(moduleMap.get(req), monitor);
            transitiveModules.addAll(modules);
            visitedModules.add(req);
        }
        transitiveModules.removeAll(visitedModules);
        if (!transitiveModules.isEmpty()) {
            requiredModules.addAll(transitiveModules);
            InternalModuleSupport.collectTransitiveRequiredModules(transitiveModules, visitedModules, moduleMap, monitor);
        }
    }

    private static Set<String> getRequiredModules(IClasspathEntryDescriptor entry, IProgressMonitor monitor) throws JavaModelException {
        if (entry != null && !monitor.isCanceled()) {
            if (1 == entry.getEntryKind()) {
                return InternalModuleSupport.getRequiredModules(entry.getPath().toFile());
            }
            if (2 == entry.getEntryKind()) {
                return InternalModuleSupport.getRequiredModules(InternalModuleSupport.getJavaProject(entry.getPath()), monitor);
            }
        }
        return Collections.emptySet();
    }

    public static Set<String> getRequiredModules(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        IModuleDescription moduleDescription = project.getModuleDescription();
        if (moduleDescription != null) {
            String[] reqModules = JavaModelAccess.getRequiredModules((IModuleDescription)moduleDescription);
            return Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(reqModules)));
        }
        return Collections.emptySet();
    }

    private static Set<String> getRequiredModules(File file) {
        block13: {
            if (!file.isFile()) {
                return Collections.emptySet();
            }
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (ZipFile zipFile = new ZipFile(file);){
                    IModule.IModuleReference[] moduleRefs;
                    IBinaryModule module = null;
                    ClassFileReader reader = ClassFileReader.read((ZipFile)zipFile, (String)"module-info.class");
                    if (reader == null || (module = reader.getModuleDeclaration()) == null || (moduleRefs = module.requires()) == null) break block13;
                    return Stream.of(moduleRefs).map(m -> new String(m.name())).collect(Collectors.toCollection(LinkedHashSet::new));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | ClassFormatException ex) {
                log.error(ex.getMessage(), ex);
            }
        }
        return Collections.emptySet();
    }

    public static String getModuleName(int entryKind, IPath entryPath, IProgressMonitor monitor) {
        String module = null;
        if (entryPath != null) {
            if (1 == entryKind) {
                module = InternalModuleSupport.getModuleName(entryPath.toFile());
            } else if (2 == entryKind) {
                module = InternalModuleSupport.getModuleName(InternalModuleSupport.getJavaProject(entryPath), monitor);
            }
        }
        return module;
    }

    private static String getModuleName(IJavaProject project, IProgressMonitor monitor) {
        String module = null;
        if (project != null) {
            try {
                if (project.getModuleDescription() == null) {
                    MavenProject mavenProject;
                    String buildName = null;
                    IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getProject(project.getProject());
                    if (facade != null && (mavenProject = facade.getMavenProject(monitor)) != null) {
                        buildName = mavenProject.getBuild().getFinalName();
                    }
                    if (buildName == null || buildName.isEmpty()) {
                        buildName = project.getElementName();
                    }
                    module = new String(AutomaticModuleNaming.determineAutomaticModuleName((String)buildName, (boolean)false, null));
                } else {
                    module = project.getModuleDescription().getElementName();
                }
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return module;
    }

    private static IJavaProject getJavaProject(IPath projectPath) {
        if (projectPath == null || projectPath.isEmpty()) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectPath.lastSegment());
        if (project.isAccessible()) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    private static String getModuleName(File file) {
        if (!file.isFile()) {
            return null;
        }
        char[] moduleName = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile zipFile = new ZipFile(file);){
                IBinaryModule module = null;
                ClassFileReader reader = ClassFileReader.read((ZipFile)zipFile, (String)"module-info.class");
                if (reader != null && (module = reader.getModuleDeclaration()) != null) {
                    moduleName = module.name();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassFormatException ex) {
            log.error(ex.getMessage(), ex);
        }
        if (moduleName == null) {
            moduleName = AutomaticModuleNaming.determineAutomaticModuleName((String)file.getAbsolutePath());
        }
        return new String(moduleName);
    }

    public static boolean isModuleEntry(IClasspathEntry entry) {
        return Arrays.stream(entry.getExtraAttributes()).anyMatch(p -> "module".equals(p.getName()) && "true".equals(p.getValue()));
    }

    public static int determineModularClasspathProperty(IClasspathEntry entry) {
        return InternalModuleSupport.isModuleEntry(entry) ? 4 : 5;
    }

    public static IRuntimeClasspathEntry createRuntimeClasspathEntry(IFolder folder, int classpathProperty, IProject project) {
        if (classpathProperty == 4 && !folder.exists((IPath)new Path("module-info.class"))) {
            classpathProperty = 6;
        }
        IRuntimeClasspathEntry newArchiveRuntimeClasspathEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)folder.getFullPath(), (int)classpathProperty);
        if (classpathProperty == 6) {
            ((RuntimeClasspathEntry)newArchiveRuntimeClasspathEntry).setJavaProject(JavaCore.create((IProject)project));
        }
        return newArchiveRuntimeClasspathEntry;
    }

    public static int determineClasspathPropertyForMainProject(boolean isModularConfiguration, IJavaProject javaProject) {
        if (!isModularConfiguration) {
            return 3;
        }
        if (!JavaRuntime.isModularProject((IJavaProject)javaProject)) {
            return 5;
        }
        return 4;
    }

    public static boolean isModularConfiguration(ILaunchConfiguration configuration) {
        return JavaRuntime.isModularConfiguration((ILaunchConfiguration)configuration);
    }

    public static IRuntimeClasspathEntry newModularProjectRuntimeClasspathEntry(IJavaProject javaProject) {
        return JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)javaProject, (int)(JavaRuntime.isModularProject((IJavaProject)javaProject) ? 4 : 5));
    }
}

