/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.preferences.context;

import javafx.scene.layout.BorderPane;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.fx.core.Memento;
import org.eclipse.fx.core.MementoStore;
import org.eclipse.fx.ui.preferences.PreferencePage;
import org.eclipse.fx.ui.preferences.PreferencePageFactory;
import org.eclipse.fx.ui.preferences.PreferencePageProvider;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;

@Component(property={"service.context.key:String=org.eclipse.fx.ui.preferences.PreferencePageFactory"})
public class PreferencePageFactoryCF
extends ContextFunction
implements IContextFunction {
    public Object compute(IEclipseContext context, String contextKey) {
        return ContextInjectionFactory.make(PreferencePageFactoryImpl.class, (IEclipseContext)context);
    }

    static class PreferencePageFactoryImpl
    implements PreferencePageFactory {
        private final IEclipseContext context;
        private final MementoStore store;

        @Inject
        public PreferencePageFactoryImpl(IEclipseContext context, @Optional MementoStore store) {
            this.context = context;
            this.store = store;
        }

        public PreferencePage make(BorderPane parent, PreferencePageProvider provider) {
            IEclipseContext ctx = this.context.createChild(provider.id());
            ctx.set(BorderPane.class, (Object)parent);
            ctx.set(PreferencePageProvider.class, (Object)provider);
            Memento memento = provider.memento().orElseGet(() -> {
                if (this.store != null) {
                    String prefId = FrameworkUtil.getBundle(provider.getClass()).getSymbolicName();
                    return this.store.getMemento(prefId);
                }
                return null;
            });
            if (memento != null) {
                ctx.set(Memento.class, (Object)memento);
            }
            return (PreferencePage)ContextInjectionFactory.make((Class)provider.pageType(), (IEclipseContext)ctx);
        }
    }
}

