/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.di.interopt;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ThreadSynchronize.class}, property={"service.ranking:Integer=-1"})
public class UISynchronizeImpl
implements ThreadSynchronize {
    private LoggerFactory factory;
    private Logger logger;

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setLoggerFactory(LoggerFactory factory) {
        this.factory = factory;
        this.logger = null;
    }

    public void unsetLoggerFactory(LoggerFactory factory) {
        if (this.factory == factory) {
            this.factory = null;
            this.logger = null;
        }
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = this.factory.createLogger(this.getClass().getName());
        }
        return this.logger;
    }

    public <V> V syncExec(Callable<V> callable, V defaultValue) {
        if (Display.getDefault().getThread() == Thread.currentThread()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        FutureTask<V> task = new FutureTask<V>(callable);
        Display.getDefault().asyncExec(task);
        try {
            Object v = task.get();
            return v;
        }
        catch (InterruptedException | ExecutionException e) {
            this.getLogger().error("Unable to wait until the task is completed", (Throwable)e);
        }
        finally {
            task.cancel(true);
        }
        return defaultValue;
    }

    public void syncExec(Runnable runnable) {
        if (Display.getDefault().getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            FutureTask<Object> task = new FutureTask<Object>(runnable, null);
            Display.getDefault().asyncExec(task);
            try {
                try {
                    task.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    this.getLogger().error("Unable to wait until the task is completed", (Throwable)e);
                    task.cancel(true);
                }
            }
            finally {
                task.cancel(true);
            }
        }
    }

    public <V> Future<V> asyncExec(Callable<V> callable) {
        FutureTask<V> task = new FutureTask<V>(callable);
        Display.getDefault().asyncExec(task);
        return task;
    }

    public void asyncExec(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    public Subscription scheduleExecution(long delay, final Runnable runnable) {
        final AtomicBoolean b = new AtomicBoolean(true);
        Runnable wrapper = () -> {
            if (b.get()) {
                runnable.run();
            }
        };
        final Display display = Display.getDefault();
        display.timerExec((int)delay, wrapper);
        return new Subscription(){

            public void dispose() {
                b.set(false);
                display.timerExec(-1, runnable);
            }
        };
    }

    public <T> CompletableFuture<T> scheduleExecution(long delay, Callable<T> runnable) {
        CompletableFuture future = new CompletableFuture();
        Display display = Display.getDefault();
        display.timerExec((int)delay, () -> {
            try {
                if (!future.isCancelled()) {
                    future.complete(runnable.call());
                }
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public boolean isCurrent() {
        return Display.getDefault().getThread() == Thread.currentThread();
    }

    public <T> T block(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ThreadSynchronize.BlockCondition<T> blockCondition) {
        Display d = Display.getDefault();
        while (blockCondition.isBlocked()) {
            if (d.readAndDispatch()) continue;
            d.sleep();
        }
        return null;
    }
}

