/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.bindings.internal;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.ListBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class FlatMapValueListBinding<A, B>
extends ListBinding<B> {
    private Observable[] currentDependencies;
    private ObservableList<A> source;
    private Function<A, ObservableValue<B>> map;

    public FlatMapValueListBinding(ObservableList<A> list, Function<A, ObservableValue<B>> map) {
        this.source = list;
        this.map = map;
        this.updateDependencies();
    }

    private Observable[] computeDependencies() {
        List<Observable> toWatch = this.source.stream().map(this.map).collect(Collectors.toList());
        toWatch.add((Observable)this.source);
        return toWatch.toArray(new Observable[0]);
    }

    private void updateDependencies() {
        if (this.currentDependencies != null) {
            this.unbind(this.currentDependencies);
        }
        this.currentDependencies = this.computeDependencies();
        this.bind(this.currentDependencies);
    }

    protected ObservableList<B> computeValue() {
        this.updateDependencies();
        return FXCollections.observableList(this.source.stream().map(this.map).map(v -> v.getValue()).collect(Collectors.toList()));
    }

    public void dispose() {
        if (this.currentDependencies != null) {
            this.unbind(this.currentDependencies);
            this.currentDependencies = null;
        }
        super.dispose();
    }
}

