/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.emf.edit.ui.dnd;

import java.util.ArrayList;
import java.util.Collection;
import javafx.event.EventHandler;
import javafx.scene.control.Cell;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.command.DragAndDropFeedback;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.fx.emf.edit.ui.AdapterFactoryCellFactory;
import org.eclipse.fx.emf.edit.ui.CellUtil;
import org.eclipse.fx.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jdt.annotation.NonNull;

public class EditingDomainCellDropAdapter
implements AdapterFactoryCellFactory.ICellCreationListener {
    final EditingDomain editingDomain;
    Command dndCommand;
    @NonNull IDnDFeedbackHandler feedbackHandler = new DefaultFeedbackHandler();

    public EditingDomainCellDropAdapter(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public @NonNull IDnDFeedbackHandler getFeedbackHandler() {
        return this.feedbackHandler;
    }

    public void setFeedbackHandler(IDnDFeedbackHandler feedbackHandler) {
        if (feedbackHandler == null) {
            throw new IllegalArgumentException("The feeback handler cannot be null");
        }
        this.feedbackHandler = feedbackHandler;
    }

    @Override
    public void cellCreated(final Cell<?> cell) {
        cell.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                Object object;
                double height;
                Object item = cell.getItem();
                Cell<?> node = CellUtil.getRowNode(cell);
                double y = event.getY();
                float position = (float)(y / (height = cell.getLayoutBounds().getHeight()));
                Command command = DragAndDropCommand.create((EditingDomain)EditingDomainCellDropAdapter.this.editingDomain, (Object)item, (float)position, (int)6, (int)2, (Collection)((Collection)(object = LocalTransfer.INSTANCE.getObject())));
                if (command.canExecute()) {
                    EditingDomainCellDropAdapter.this.dndCommand = command;
                    if (command instanceof DragAndDropFeedback) {
                        DragAndDropFeedback dndFeedback = (DragAndDropFeedback)command;
                        int feedback = dndFeedback.getFeedback();
                        if ((feedback & 2) != 0) {
                            EditingDomainCellDropAdapter.this.feedbackHandler.onFeedbackInsertBefore(node);
                        } else if ((feedback & 4) != 0) {
                            EditingDomainCellDropAdapter.this.feedbackHandler.onFeedbackInsertAfter(node);
                        } else if ((feedback & 1) != 0) {
                            EditingDomainCellDropAdapter.this.feedbackHandler.onFeedbackSelect(node);
                        } else {
                            EditingDomainCellDropAdapter.this.feedbackHandler.onFeedbackNone(node);
                        }
                        if (System.getProperties().getProperty("os.name").toLowerCase().contains("mac")) {
                            event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
                        } else {
                            ArrayList<TransferMode> modes = new ArrayList<TransferMode>();
                            if ((feedback & 1) != 0) {
                                modes.add(TransferMode.COPY);
                            }
                            if ((feedback & 4) != 0) {
                                modes.add(TransferMode.LINK);
                            }
                            if ((feedback & 2) != 0) {
                                modes.add(TransferMode.MOVE);
                            }
                            event.acceptTransferModes(modes.toArray(new TransferMode[modes.size()]));
                        }
                    }
                } else {
                    EditingDomainCellDropAdapter.this.dndCommand = null;
                    EditingDomainCellDropAdapter.this.feedbackHandler.onFeedbackNone(node);
                }
            }
        });
        cell.setOnDragExited((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                EditingDomainCellDropAdapter.this.feedbackHandler.onFeedbackNone(CellUtil.getRowNode(cell));
            }
        });
        cell.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                if (EditingDomainCellDropAdapter.this.dndCommand != null) {
                    EditingDomainCellDropAdapter.this.editingDomain.getCommandStack().execute(EditingDomainCellDropAdapter.this.dndCommand);
                }
                event.setDropCompleted(true);
                event.consume();
            }
        });
    }

    public static class DefaultFeedbackHandler
    implements IDnDFeedbackHandler {
        @Override
        public void onFeedbackInsertBefore(Cell<?> cell) {
            cell.setStyle("-fx-border-color: red transparent transparent transparent;");
        }

        @Override
        public void onFeedbackInsertAfter(Cell<?> cell) {
            cell.setStyle("-fx-border-color: transparent transparent red transparent;");
        }

        @Override
        public void onFeedbackSelect(Cell<?> cell) {
            cell.setStyle("-fx-border-color: transparent;");
        }

        @Override
        public void onFeedbackNone(Cell<?> cell) {
            cell.setStyle("-fx-border-color: transparent;");
        }
    }

    public static interface IDnDFeedbackHandler {
        public void onFeedbackInsertBefore(Cell<?> var1);

        public void onFeedbackInsertAfter(Cell<?> var1);

        public void onFeedbackSelect(Cell<?> var1);

        public void onFeedbackNone(Cell<?> var1);
    }
}

