/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.emf.edit.ui.dnd;

import java.util.ArrayList;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.Cell;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import org.eclipse.fx.emf.edit.ui.AdapterFactoryCellFactory;
import org.eclipse.fx.emf.edit.ui.CellUtil;
import org.eclipse.fx.emf.edit.ui.dnd.LocalTransfer;

public class CellDragAdapter
implements AdapterFactoryCellFactory.ICellCreationListener {
    @Override
    public void cellCreated(final Cell<?> cell) {
        cell.setOnDragDetected((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Dragboard db = cell.startDragAndDrop(TransferMode.ANY);
                ClipboardContent content = new ClipboardContent();
                content.putString("dummy content");
                db.setContent((Map)content);
                MultipleSelectionModel<?> selectionModel = CellUtil.getSelectionModel(cell);
                ObservableList selectedItems = selectionModel.getSelectedItems();
                ArrayList<Object> items = new ArrayList<Object>(selectedItems.size());
                for (Object item : selectedItems) {
                    if (item instanceof TreeItem) {
                        items.add(((TreeItem)item).getValue());
                        continue;
                    }
                    items.add(item);
                }
                LocalTransfer.INSTANCE.setObject(items);
                event.consume();
            }
        });
    }
}

