/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.core.AbstractModule;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavadocContents;
import org.eclipse.jdt.internal.core.ModularClassFile;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.util.LRUCache;

public class BinaryModule
extends BinaryMember
implements AbstractModule {
    private IBinaryModule info;

    public BinaryModule(JavaElement parent, String name) {
        super(parent, name);
    }

    public BinaryModule(JavaElement parent, IBinaryModule info) {
        super(parent, String.valueOf(info.name()));
        this.info = info;
    }

    @Override
    public IModule getModuleInfo() throws JavaModelException {
        if (this.info == null) {
            ModularClassFile classFile = (ModularClassFile)this.parent;
            this.info = classFile.getBinaryModuleInfo();
        }
        return this.info;
    }

    @Override
    public IAnnotation[] getAnnotations() throws JavaModelException {
        IBinaryModule moduleInfo = (IBinaryModule)this.getModuleInfo();
        IBinaryAnnotation[] binaryAnnotations = moduleInfo.getAnnotations();
        long tagBits = moduleInfo.getTagBits() & 0xFFFFBFFFFFFFFFFFL;
        return this.getAnnotations(binaryAnnotations, tagBits);
    }

    @Override
    public IJavaElement[] getChildren() throws JavaModelException {
        return NO_ELEMENTS;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public int getFlags() throws JavaModelException {
        if (this.getModuleInfo().isOpen()) {
            return 32;
        }
        return 0;
    }

    @Override
    public char getHandleMementoDelimiter() {
        return '`';
    }

    @Override
    public String getKey(boolean forceOpen) throws JavaModelException {
        return this.getKey(this, forceOpen);
    }

    @Override
    public ISourceRange getSourceRange() throws JavaModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            ((ModularClassFile)this.getClassFile()).getBuffer();
            return mapper.getSourceRange(this);
        }
        return SourceMapper.UNKNOWN_RANGE;
    }

    @Override
    public String getAttachedJavadoc(IProgressMonitor monitor) throws JavaModelException {
        JavadocContents javadocContents = this.getJavadocContents(monitor);
        if (javadocContents == null) {
            return null;
        }
        return javadocContents.getModuleDoc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavadocContents getJavadocContents(IProgressMonitor monitor) throws JavaModelException {
        JavaModelManager.PerProjectInfo projectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfoCheckExistence(this.getJavaProject().getProject());
        JavadocContents cachedJavadoc = null;
        LRUCache<IJavaElement, Object> lRUCache = projectInfo.javadocCache;
        synchronized (lRUCache) {
            cachedJavadoc = (JavadocContents)projectInfo.javadocCache.get(this);
        }
        if (cachedJavadoc != null && cachedJavadoc != BinaryType.EMPTY_JAVADOC) {
            return cachedJavadoc;
        }
        URL baseLocation = this.getJavadocBaseLocation();
        if (baseLocation == null) {
            return null;
        }
        StringBuffer pathBuffer = new StringBuffer(baseLocation.toExternalForm());
        if (pathBuffer.charAt(pathBuffer.length() - 1) != '/') {
            pathBuffer.append('/');
        }
        pathBuffer.append(this.getElementName()).append("-summary.html");
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        String contents = this.getURLContents(baseLocation, String.valueOf(pathBuffer));
        JavadocContents javadocContents = new JavadocContents(contents);
        LRUCache<IJavaElement, Object> lRUCache2 = projectInfo.javadocCache;
        synchronized (lRUCache2) {
            projectInfo.javadocCache.put(this, javadocContents);
        }
        return javadocContents;
    }

    @Override
    public String toString(String lineDelimiter) {
        StringBuffer buffer = new StringBuffer();
        try {
            this.toStringContent(buffer, lineDelimiter);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }
}

