/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.net;

import java.util.ArrayList;
import org.eclipse.core.internal.net.StringMatcher;

public class StringUtil {
    public static String[] split(String value, String[] delimiters) {
        ArrayList<String> result = new ArrayList<String>();
        int firstIndex = 0;
        int separator = 0;
        while (firstIndex != -1) {
            firstIndex = -1;
            int i = 0;
            while (i < delimiters.length) {
                int index = value.indexOf(delimiters[i]);
                if (index != -1 && (index < firstIndex || firstIndex == -1)) {
                    firstIndex = index;
                    separator = i;
                }
                ++i;
            }
            if (firstIndex != -1) {
                int newStart;
                if (firstIndex != 0) {
                    result.add(value.substring(0, firstIndex));
                }
                if ((newStart = firstIndex + delimiters[separator].length()) > value.length()) continue;
                value = value.substring(newStart);
                continue;
            }
            if (value.length() <= 0) continue;
            result.add(value);
        }
        return result.toArray(new String[0]);
    }

    public static final boolean equals(CharSequence sequence1, CharSequence sequence2) {
        if (sequence1 == sequence2) {
            return true;
        }
        if (sequence1 == null || sequence2 == null) {
            return false;
        }
        return sequence1.equals(sequence2);
    }

    public static String replace(String source, String from, String to) {
        if (from.length() == 0) {
            return source;
        }
        StringBuffer buffer = new StringBuffer();
        int current = 0;
        int pos = 0;
        while (pos != -1) {
            pos = source.indexOf(from, current);
            if (pos == -1) {
                buffer.append(source.substring(current));
                continue;
            }
            buffer.append(source.substring(current, pos));
            buffer.append(to);
            current = pos + from.length();
        }
        return buffer.toString();
    }

    public static boolean hostMatchesFilter(String host, String filter) {
        String suffixMatchingFilter = "*" + filter;
        StringMatcher matcher = new StringMatcher(suffixMatchingFilter, true, false);
        return matcher.match(host);
    }
}

